/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience.monitor;

import com.yy.IMediaVideo;
import com.yy.IMediaVideoSDK;
import com.yy.yylivekit.Env;
import com.yy.yylivekit.audience.monitor.AcceptanceRulesV2;
import com.yy.yylivekit.audience.services.OnStreamsBroadcastingV2;
import com.yy.yylivekit.audience.services.OpQueryStreamInfoV2;
import com.yy.yylivekit.audience.services.OpUpdateStreamInfoV2;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.Channel;
import com.yy.yylivekit.model.GroupInfo;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.TransConfig;
import com.yy.yylivekit.services.Service;
import com.yy.yylivekit.services.retrystrategies.RetryFixedCounts;
import com.yy.yylivekit.services.retrystrategies.RetryNone;
import com.yy.yylivekit.services.retrystrategies.RetryStrategy;
import com.yy.yylivekit.threading.RunInMain;
import com.yy.yylivekit.utils.Cleanup;
import com.yyproto.base.ProtoReq;
import com.yyproto.outlet.IProtoMgr;
import com.yyproto.outlet.SvcRequest;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;

public class StreamsMonitor {
    private static final String TAG = "StreamsMonitor";
    public final Delegate delegate;
    private final long uid;
    private final Service service = Service.instance();
    private final IMediaVideo media = IMediaVideoSDK.instance().getMedia();
    private final Cleanup cleanup = new Cleanup("StreamsMonitor");
    private List<SvcRequest.UserGroupIdAndAppid> subscribeItems = new ArrayList<SvcRequest.UserGroupIdAndAppid>();
    private Runnable job;
    private Channel channel;
    private State state;
    private long lastStreamVersion = 0L;
    private AcceptanceRulesV2 rules;

    public StreamsMonitor(long uid, Channel channel, Delegate delegate) {
        this.changeState(State.Closed);
        this.uid = uid;
        this.channel = channel;
        this.delegate = delegate;
        YLKLog.i(TAG, "StreamsMonitor create uid:" + uid + ",channel:" + channel + ",hash:" + this.hashCode());
    }

    public void open(boolean needReqAvp, final OpenCompletion openCompletion) {
        Assert.assertNotNull((Object)openCompletion);
        Assert.assertTrue((!State.Opened.equals((Object)this.state) ? 1 : 0) != 0);
        YLKLog.i(TAG, "StreamsMonitor open hash:" + this.hashCode());
        this.lastStreamVersion = 0L;
        this.changeState(State.Opening);
        this.unSubscribeBroadcastGroup();
        this.subscribeBroadcastGroup();
        this.cleanup.push("unSubscribeBroadcastGroup", new Runnable(){

            @Override
            public void run() {
                StreamsMonitor.this.unSubscribeBroadcastGroup();
            }
        });
        this.startup(needReqAvp, new StartupCompletion(){

            @Override
            public void onStartupSuccess() {
                YLKLog.i(StreamsMonitor.TAG, "StreamsMonitor onStartupSuccess hash:" + this.hashCode());
                if (State.Closed.equals((Object)StreamsMonitor.this.state)) {
                    YLKLog.i(StreamsMonitor.TAG, "startup state has closed!");
                    return;
                }
                StreamsMonitor.this.setupStreamsBC();
                StreamsMonitor.this.changeState(State.Opened);
                openCompletion.onStreamsMonitorOpenSuccess();
            }

            @Override
            public void onStartupFailed(Service.LaunchFailure failure, String msg) {
                openCompletion.onStreamsMonitorOpenFailed(failure, msg);
            }
        });
    }

    public void close() {
        YLKLog.i(TAG, "StreamsMonitor close hash:" + this.hashCode());
        if (this.job != null) {
            RunInMain.removeCallbacks(this.job);
            this.job = null;
        }
        this.changeState(State.Closed);
        this.cleanup.flush(null);
    }

    private void subscribeBroadcastGroup() {
        ArrayList<SvcRequest.UserGroupIdAndAppid> items = new ArrayList<SvcRequest.UserGroupIdAndAppid>();
        SvcRequest.UserGroupIdAndAppid groupIdAndAppid = new SvcRequest.UserGroupIdAndAppid();
        groupIdAndAppid.mGroupType = 2L;
        groupIdAndAppid.mGroupId = this.channel.sub;
        int[] nArray = new int[1];
        Env.instance();
        nArray[0] = 10588;
        groupIdAndAppid.mAppIds = nArray;
        items.add(groupIdAndAppid);
        SvcRequest.SvcSubScribeGroupAndAppidReq subSvcReq = new SvcRequest.SvcSubScribeGroupAndAppidReq(items.toArray(new SvcRequest.UserGroupIdAndAppid[items.size()]));
        IProtoMgr.instance().getSvc().sendRequest((ProtoReq)subSvcReq);
        YLKLog.i(TAG, "subscribeBroadcastGroup :" + this.subscribeItems);
        this.subscribeItems.addAll(items);
    }

    private void unSubscribeBroadcastGroup() {
        ArrayList<SvcRequest.UserGroupIdAndAppid> items = new ArrayList<SvcRequest.UserGroupIdAndAppid>();
        if (!FP.empty(this.subscribeItems)) {
            items.addAll(this.subscribeItems);
        }
        YLKLog.i(TAG, "unSubscribeBroadcastGroup :" + this.subscribeItems);
        if (!FP.empty(items)) {
            SvcRequest.SvcUnsubScribeGroupAndAppidReq subSvcReq = new SvcRequest.SvcUnsubScribeGroupAndAppidReq(items.toArray(new SvcRequest.UserGroupIdAndAppid[items.size()]));
            IProtoMgr.instance().getSvc().sendRequest((ProtoReq)subSvcReq);
            this.subscribeItems.clear();
        }
    }

    private void startup(boolean needReqAvp, final StartupCompletion completion) {
        YLKLog.i(TAG, "startup YlkMediaConfigs=" + Env.instance().getYlkMediaConfigs() + ",hash:" + this.hashCode());
        boolean supportsH265 = Env.instance().getYlkMediaConfigs().isSupportH265Decode();
        final long startTS = System.currentTimeMillis();
        OpQueryStreamInfoV2 request = new OpQueryStreamInfoV2(this.uid, this.channel, needReqAvp, supportsH265, new OpQueryStreamInfoV2.Completion(){

            @Override
            public void didQueryStreamInfo(final byte[] avpInfo, final long version, final Channel cl, final AcceptanceRulesV2 acceptanceRules, final List<LiveInfo> anchorLiveInfoList, final Set<LiveInfo> viewerLiveInfoSet, final List<GroupInfo> groupInfoList, final Map<Long, Map<Short, Long>> metaDataMap, final Set<TransConfig> transConfigs) {
                if (StreamsMonitor.this.channel == null || !StreamsMonitor.this.channel.equals(cl) || State.Closed.equals((Object)StreamsMonitor.this.state)) {
                    YLKLog.e(StreamsMonitor.TAG, "OpQueryStreamInfo return ignore! CurrentChannel=" + StreamsMonitor.this.channel + ", resultToChannel=" + cl);
                    return;
                }
                if (StreamsMonitor.this.job != null) {
                    RunInMain.removeCallbacks(StreamsMonitor.this.job);
                }
                StreamsMonitor.this.job = new Runnable(){

                    @Override
                    public void run() {
                        YLKLog.i(StreamsMonitor.TAG, "OpQueryStreamInfo dispatch begin hash:" + this.hashCode());
                        if (StreamsMonitor.this.channel == null || !StreamsMonitor.this.channel.equals(cl) || State.Closed.equals((Object)StreamsMonitor.this.state)) {
                            YLKLog.i(StreamsMonitor.TAG, "OpQueryStreamInfo dispatch ignore, channel is nil Or unSame!!");
                            return;
                        }
                        int cost = (int)(System.currentTimeMillis() - startTS);
                        if (avpInfo != null && avpInfo.length != 0) {
                            YLKLog.i(StreamsMonitor.TAG, "OpQueryStreamInfo set avp ");
                            StreamsMonitor.this.media.liveSetAvpInfo(avpInfo, cost);
                        } else {
                            YLKLog.i(StreamsMonitor.TAG, "OpQueryStreamInfo avp is nul ");
                        }
                        StreamsMonitor.this.rules = acceptanceRules;
                        StreamsMonitor.this.delegate.onUpdateMetaData(true, metaDataMap);
                        StreamsMonitor.this.delegate.onUpdateTransConfig(true, transConfigs);
                        StreamsMonitor.this.updateSubscriptionIfNeeded(true, version, anchorLiveInfoList, viewerLiveInfoSet, groupInfoList);
                        completion.onStartupSuccess();
                        YLKLog.i(StreamsMonitor.TAG, "OpQueryStreamInfo dispatch end hash:" + this.hashCode());
                    }
                };
                RunInMain.dispatchAtFrontOfQueue(StreamsMonitor.this.job);
            }
        });
        this.sendOpQueryStreamRequest(request, completion, new RetryFixedCounts(3, 5000L));
    }

    private void sendOpQueryStreamRequest(final OpQueryStreamInfoV2 request, final StartupCompletion completion, RetryStrategy retryStrategy) {
        this.service.launch(request, new Service.LaunchCompletion(){

            @Override
            public void onLaunchFailed(Service.LaunchFailure failure, String msg) {
                if (Service.LaunchFailure.RequestTimeout.equals((Object)failure)) {
                    YLKLog.i(StreamsMonitor.TAG, "sendOpQueryStreamRequest try request");
                    StreamsMonitor.this.sendOpQueryStreamRequest(request, completion, new RetryNone(Integer.MAX_VALUE));
                } else {
                    completion.onStartupFailed(failure, msg);
                }
            }
        }, retryStrategy);
    }

    private void updateSubscriptionIfNeeded(boolean firstUpdate, long newVersion, List<LiveInfo> anchorLiveInfoList, Set<LiveInfo> viewerLiveInfoSet, List<GroupInfo> groupInfoList) {
        if (newVersion == this.lastStreamVersion) {
            return;
        }
        YLKLog.i(TAG, "StreamsMonitor streams updated (" + this.lastStreamVersion + " -> " + newVersion + ") hash:" + this.hashCode());
        YLKLog.i(TAG, "StreamsMonitor anchorLiveInfo: " + anchorLiveInfoList);
        YLKLog.i(TAG, "StreamsMonitor viewerLiveInfo: " + viewerLiveInfoSet);
        YLKLog.i(TAG, "StreamsMonorot groupInfoList: " + groupInfoList);
        this.lastStreamVersion = newVersion;
        this.delegate.onUpdateLiveInfo(firstUpdate, new HashSet<LiveInfo>(anchorLiveInfoList), new HashSet<LiveInfo>(viewerLiveInfoSet), new HashSet<GroupInfo>(groupInfoList));
    }

    private void setupStreamsBC() {
        YLKLog.i(TAG, "StreamsMonitor setupStreamsBC hash:" + this.hashCode());
        final OnStreamsBroadcastingV2 onBroadcasting = new OnStreamsBroadcastingV2(this.rules, new OnStreamsBroadcastingV2.Callback(){

            @Override
            public void onStreamsBroadcasting(long version, List<LiveInfo> anchorLiveInfoList, Set<LiveInfo> viewerLiveInfoSet, List<GroupInfo> groupInfoList, Map<Long, Map<Short, Long>> metaDataMap, Set<TransConfig> transConfigs) {
                if (State.Closed.equals((Object)StreamsMonitor.this.state)) {
                    YLKLog.i(StreamsMonitor.TAG, "onStreamsBroadcasting state has closed!");
                    return;
                }
                YLKLog.i(StreamsMonitor.TAG, "StreamsMonitor onStreamsBroadcasting hash:" + this.hashCode());
                StreamsMonitor.this.delegate.onUpdateMetaData(false, metaDataMap);
                StreamsMonitor.this.delegate.onUpdateTransConfig(false, transConfigs);
                StreamsMonitor.this.updateSubscriptionIfNeeded(false, version, anchorLiveInfoList, viewerLiveInfoSet, groupInfoList);
            }

            @Override
            public void onUpdateStreamInfo(long currentVersion, long requestVersion) {
                if (State.Closed.equals((Object)StreamsMonitor.this.state)) {
                    YLKLog.i(StreamsMonitor.TAG, "onUpdateStreamInfo state has closed!");
                    return;
                }
                YLKLog.i(StreamsMonitor.TAG, "StreamsMonitor onUpdateStreamInfo hash:" + this.hashCode());
                boolean supportsH265 = Env.instance().getYlkMediaConfigs().isSupportH265Decode();
                Service.instance().launch(new OpUpdateStreamInfoV2(StreamsMonitor.this.uid, StreamsMonitor.this.channel, supportsH265, currentVersion, requestVersion, new OpUpdateStreamInfoV2.Completion(){

                    @Override
                    public void didUpdateStreamInfo(long version, Channel cl, List<LiveInfo> anchorLiveInfoList, Set<LiveInfo> viewerLiveInfoSet, List<GroupInfo> groupInfoList, Map<Long, Map<Short, Long>> metaDataMap, Set<TransConfig> transConfigs) {
                        if (StreamsMonitor.this.channel == null || !StreamsMonitor.this.channel.equals(cl) || State.Closed.equals((Object)StreamsMonitor.this.state)) {
                            YLKLog.e(StreamsMonitor.TAG, "OpUpdateStreamInfoV2 return ignore! CurrentChannel=" + StreamsMonitor.this.channel + ", resultToChannel=" + cl);
                            return;
                        }
                        YLKLog.i(StreamsMonitor.TAG, "StreamsMonitor didUpdateStreamInfo hash:" + this.hashCode());
                        StreamsMonitor.this.delegate.onUpdateMetaData(false, metaDataMap);
                        StreamsMonitor.this.delegate.onUpdateTransConfig(false, transConfigs);
                        StreamsMonitor.this.updateSubscriptionIfNeeded(false, version, anchorLiveInfoList, viewerLiveInfoSet, groupInfoList);
                    }
                }), null, (RetryStrategy)new RetryFixedCounts(3, 5000L));
            }
        });
        this.service.register(onBroadcasting);
        this.cleanup.push("unregister streamsBC", new Runnable(){

            @Override
            public void run() {
                YLKLog.i(StreamsMonitor.TAG, "unregister streamsBC hash:" + this.hashCode());
                StreamsMonitor.this.service.unregister(onBroadcasting);
            }
        });
    }

    private void changeState(State next) {
        if (this.state == next) {
            return;
        }
        YLKLog.i(TAG, "StreamsMonitor state: " + (Object)((Object)this.state) + " -> " + (Object)((Object)next) + ",hash:" + this.hashCode());
        this.state = next;
    }

    private static interface StartupCompletion {
        public void onStartupSuccess();

        public void onStartupFailed(Service.LaunchFailure var1, String var2);
    }

    public static interface OpenCompletion {
        public void onStreamsMonitorOpenSuccess();

        public void onStreamsMonitorOpenFailed(Service.LaunchFailure var1, String var2);
    }

    public static interface Delegate {
        public void onUpdateLiveInfo(boolean var1, Set<LiveInfo> var2, Set<LiveInfo> var3, Set<GroupInfo> var4);

        public void onUpdateMetaData(boolean var1, Map<Long, Map<Short, Long>> var2);

        public void onUpdateTransConfig(boolean var1, Set<TransConfig> var2);
    }

    static enum State {
        Closed,
        Opening,
        Opened;

    }
}

