/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience;

import com.medialib.video.MediaVideoMsg;
import com.yy.yylivekit.ILivePlayer;
import com.yy.yylivekit.audience.LivePlayer;
import com.yy.yylivekit.audience.streamline.IComplete;
import com.yy.yylivekit.audience.streamline.IHandler;
import com.yy.yylivekit.audience.streamline.LineFrom0Handler;
import com.yy.yylivekit.audience.streamline.LineFrom1Handler;
import com.yy.yylivekit.audience.streamline.LineFrom2Handler;
import com.yy.yylivekit.audience.streamline.LineFrom9Handler;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.VideoGearInfo;
import com.yy.yylivekit.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class StreamLineHandler {
    private static final String TAG = "StreamLineHandler";
    public final Map<Integer, IHandler> handlerMap = new HashMap<Integer, IHandler>(){
        {
            this.put(0, new LineFrom0Handler());
            this.put(1, new LineFrom1Handler());
            this.put(2, new LineFrom2Handler());
            this.put(9, new LineFrom9Handler());
        }
    };
    private final LivePlayer mLivePlayer;
    private List<ILivePlayer.StreamLineEventHandler> streamLineEventHandlers = new ArrayList<ILivePlayer.StreamLineEventHandler>();
    private volatile Map<Integer, Map<Integer, List<VideoGearInfo>>> mLineToQualitys = new HashMap<Integer, Map<Integer, List<VideoGearInfo>>>();

    public StreamLineHandler(LivePlayer livePlayer) {
        this.mLivePlayer = livePlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamLineEventHandler(ILivePlayer.StreamLineEventHandler handler) {
        List<ILivePlayer.StreamLineEventHandler> list = this.streamLineEventHandlers;
        synchronized (list) {
            YLKLog.i(TAG, "addStreamLineEventHandler() called with: handler = [" + handler + "]");
            this.streamLineEventHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStreamLineEventHandler(ILivePlayer.StreamLineEventHandler handler) {
        List<ILivePlayer.StreamLineEventHandler> list = this.streamLineEventHandlers;
        synchronized (list) {
            YLKLog.i(TAG, "removeStreamLineEventHandler() called with: handler = [" + handler + "]");
            this.streamLineEventHandlers.remove(handler);
        }
    }

    public LiveInfo getLiveInfo() {
        return this.mLivePlayer.getCurLiveInfo();
    }

    public void process(MediaVideoMsg.LiveStreamLineInfo lineInfo) {
        IHandler handler = this.handlerMap.get(lineInfo.lineFrom);
        if (handler == null || !this.mLivePlayer.isStartState()) {
            YLKLog.i(TAG, "onLiveStreamLineInfo() handler: " + handler + ",State: " + this.mLivePlayer.isStartState());
            return;
        }
        handler.handle(this.mLivePlayer, lineInfo, new IComplete(){

            @Override
            public void onLiveStreamLineInfo(final int videoSource, final int curLine, final VideoGearInfo curVideoQuality, final Map<Integer, Map<Integer, List<VideoGearInfo>>> sourceLineQualities) {
                YLKLog.i(StreamLineHandler.TAG, "onLiveStreamLineInfo videoSource = [" + videoSource + "], curLine = [" + curLine + "], curVideoQuality = [" + curVideoQuality + "], sourceLineQualities = [" + sourceLineQualities + "]");
                StreamLineHandler.this.mLivePlayer.innerSetVideoLine(curLine);
                StreamLineHandler.this.mLineToQualitys = new HashMap<Integer, Map<Integer, List<VideoGearInfo>>>(sourceLineQualities);
                StreamLineHandler.this.iterateStreamLineEventHandlers(new CollectionUtils.Visitor<ILivePlayer.StreamLineEventHandler>(){

                    @Override
                    public void onVisit(ILivePlayer.StreamLineEventHandler eventHandler) {
                        eventHandler.onLiveStreamLineInfo(StreamLineHandler.this.mLivePlayer, StreamLineHandler.this.getLiveInfo(), videoSource, curLine, curVideoQuality, new HashMap<Integer, Map<Integer, List<VideoGearInfo>>>(sourceLineQualities));
                    }
                });
            }
        });
    }

    public void notifyNoVideoLine() {
        YLKLog.i(TAG, "notifyNoVideoLine() called");
        this.mLineToQualitys = new HashMap<Integer, Map<Integer, List<VideoGearInfo>>>();
        this.iterateStreamLineEventHandlers(new CollectionUtils.Visitor<ILivePlayer.StreamLineEventHandler>(){

            @Override
            public void onVisit(ILivePlayer.StreamLineEventHandler eventHandler) {
                int videoSource = ((StreamLineHandler)StreamLineHandler.this).mLivePlayer.getCurLiveInfo().source;
                int curLine = StreamLineHandler.this.mLivePlayer.getCurLineNum();
                VideoGearInfo videoQuality = StreamLineHandler.this.mLivePlayer.getCurVideoQuality();
                eventHandler.onLiveStreamLineInfo(StreamLineHandler.this.mLivePlayer, StreamLineHandler.this.getLiveInfo(), videoSource, curLine, videoQuality, Collections.EMPTY_MAP);
            }
        });
    }

    public void fetchAllVideoLine() {
        if (!this.mLivePlayer.hasVideo()) {
            return;
        }
        if (this.mLivePlayer.getCurStreamInfo() == null || this.mLivePlayer.getCurStreamInfo().video == null) {
            return;
        }
        if (this.mLivePlayer.getCurLiveInfo().isMix) {
            this.handlerMap.get(0).fetchAllVideoLine(this.mLivePlayer.getAllLiveInfo());
        } else {
            LineFrom9Handler lineFrom9Handler = (LineFrom9Handler)this.handlerMap.get(9);
            MediaVideoMsg.LiveStreamLineInfo lineInfo = lineFrom9Handler.generateLineInfo(this.mLivePlayer.getCurLiveInfo(), this.mLivePlayer.getCurLineNum());
            this.process(lineInfo);
        }
    }

    public Map<Integer, Map<Integer, List<VideoGearInfo>>> getAllLines() {
        return new HashMap<Integer, Map<Integer, List<VideoGearInfo>>>(this.mLineToQualitys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void iterateStreamLineEventHandlers(CollectionUtils.Visitor<ILivePlayer.StreamLineEventHandler> visitor) {
        List<ILivePlayer.StreamLineEventHandler> list = this.streamLineEventHandlers;
        synchronized (list) {
            CollectionUtils.iterate(this.streamLineEventHandlers, visitor);
        }
    }
}

