/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience;

import com.yy.yylivekit.audience.SubscribHandler;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.GroupInfo;
import com.yyproto.utils.FP;
import java.util.HashSet;
import java.util.Set;

public class RadioPlayer {
    private final Set<GroupInfo> playSet = new HashSet<GroupInfo>();
    private final Set<GroupInfo> saleSet = new HashSet<GroupInfo>();

    public void addGroupInfo(Set<GroupInfo> groupInfos) {
        YLKLog.i("YLK", "addGroupInfo | registerGroup:" + groupInfos);
        this.playSet.addAll(groupInfos);
    }

    public void addGroupInfo(Set<GroupInfo> groupInfos, int appid) {
        YLKLog.i("YLK", "addGroupInfo | registerGroup:" + groupInfos + ", appid:" + appid);
        HashSet<GroupInfo> newGroupInfos = new HashSet<GroupInfo>();
        for (GroupInfo groupInfo : groupInfos) {
            newGroupInfos.add(new GroupInfo(appid, groupInfo.name, groupInfo.type));
            newGroupInfos.add(groupInfo);
        }
        this.addGroupInfo(newGroupInfos);
    }

    public void removeGroupInfo(Set<GroupInfo> groupInfos) {
        YLKLog.i("YLK", "removeGroupInfo | unregisterGroup:" + groupInfos);
        boolean ret = this.playSet.removeAll(groupInfos);
        if (ret) {
            this.saleSet.clear();
            this.saleSet.addAll(groupInfos);
        }
    }

    public void removeGroupInfo(Set<GroupInfo> groupInfos, int appid) {
        YLKLog.i("YLK", "removeGroupInfo | unregisterGroup:" + groupInfos + ", appid:" + appid);
        if (FP.empty(groupInfos)) {
            return;
        }
        HashSet<GroupInfo> saleGroupInfos = new HashSet<GroupInfo>();
        for (GroupInfo groupInfo : groupInfos) {
            saleGroupInfos.add(new GroupInfo(appid, groupInfo.name, groupInfo.type));
        }
        saleGroupInfos.addAll(groupInfos);
        this.removeGroupInfo(saleGroupInfos);
    }

    public void play() {
        YLKLog.i("YLK", "play | registerGroup:" + this.playSet);
        for (GroupInfo group : this.playSet) {
            SubscribHandler.instance.registerGroup(group);
        }
        SubscribHandler.instance.execute();
    }

    public void stop() {
        this.stop(this.saleSet);
    }

    public void release() {
        YLKLog.i("YLK", "release RadioPlayer!");
        this.playSet.clear();
        this.saleSet.clear();
    }

    public boolean isContain(Set<GroupInfo> groupSet) {
        return this.playSet.equals(groupSet);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RadioPlayer that = (RadioPlayer)o;
        return this.playSet.equals(that.playSet);
    }

    public int hashCode() {
        return this.playSet.hashCode();
    }

    private void stop(Set<GroupInfo> saleGroups) {
        YLKLog.i("YLK", "stop | unRegisterGroup>:" + saleGroups);
        for (GroupInfo group : saleGroups) {
            SubscribHandler.instance.unRegisterGroup(group);
        }
        SubscribHandler.instance.execute();
    }
}

