/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience;

import android.os.Build;
import android.os.Message;
import android.util.Log;
import com.duowan.mobile.mediaproxy.YVideoViewLayout;
import com.medialib.video.MediaVideoMsg;
import com.yy.IMediaVideo;
import com.yy.IMediaVideoSDK;
import com.yy.videoplayer.IVideoLibInfoExt;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.vr.VRMotionWithTouchWrapper;
import com.yy.yylivekit.Env;
import com.yy.yylivekit.YLKLive;
import com.yy.yylivekit.YLKVideoSDKGlues;
import com.yy.yylivekit.audience.AudienceEventHandler;
import com.yy.yylivekit.audience.Differences;
import com.yy.yylivekit.audience.SubscribHandler;
import com.yy.yylivekit.audience.Transfers;
import com.yy.yylivekit.audience.monitor.StreamsMonitor;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.Channel;
import com.yy.yylivekit.model.ClientRole;
import com.yy.yylivekit.model.GroupInfo;
import com.yy.yylivekit.model.LiveEventHandler;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.StreamInfo;
import com.yy.yylivekit.model.TransConfig;
import com.yy.yylivekit.model.YLKMediaConfigs;
import com.yy.yylivekit.services.Service;
import com.yy.yylivekit.threading.RunInMain;
import com.yy.yylivekit.utils.Cleanup;
import com.yy.yylivekit.utils.RuntimeKit;
import com.yy.yylivekit.utils.Triple;
import com.yy.yylivekit.utils.Tuple;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import junit.framework.Assert;

public class Audience
implements LiveEventHandler {
    private static final String TAG = "Audience";
    private final IMediaVideo media = IMediaVideoSDK.instance().getMedia();
    private final Cleanup cleanups = new Cleanup(this.getClass().getSimpleName());
    private final Object infoListLock = new Object();
    private final List<AudienceEventHandler> handlers = new ArrayList<AudienceEventHandler>();
    private final String cleanFastJoin = "clean fastJoin";
    private long uid;
    private Channel channel;
    private StreamsMonitor streamsMonitor;
    private Set<LiveInfo> anchorInitialSet;
    private Set<LiveInfo> viewInitialSet;
    private Set<GroupInfo> groupInitialSet;
    private Set<GroupInfo> groupInfoSet;
    private Set<LiveInfo> liveInfoSet;
    private Set<LiveInfo> fastLiveInfoSet;
    private Map<Long, Map<Short, Long>> metaDataMap;
    private Set<TransConfig> transConfigs;
    private VRMotionWithTouchWrapper vrMotionWithTouchWrapper;
    private boolean needMixture = true;
    private boolean needTranscode = false;
    private volatile boolean needRetryRequest = false;

    private Audience() {
        YLKLog.d(TAG, "Audience init begin>>>>");
        YLKLog.d(TAG, "YYVideoLibMgr init begin");
        YYVideoLibMgr.instance().init(Env.instance().context(), RuntimeKit.appVersion(Env.instance().context()), Env.instance().names().app, Build.VERSION.RELEASE, Build.MODEL, "");
        YYVideoLibMgr.instance().setVideoInfoListener((IVideoLibInfoExt)new YLKVideoSDKGlues());
        YVideoViewLayout.setUseYYVideoLib((boolean)true);
        YLKLog.d(TAG, "YYVideoLibMgr init finish");
        YLKLive.instance().addEventHandler(this);
        YLKLive.instance().addLiveChangeEventHandler(new YLKLive.LiveChangeEventHandler(){

            @Override
            public void roleChanged(ClientRole role, boolean updateImmediately) {
                YLKLog.i(Audience.TAG, "roleChanged clientRole:" + (Object)((Object)role) + ",updateImmediately:" + updateImmediately);
                SubscribHandler.instance.cleanStreams(Audience.this.needMixture);
                Audience.this.switchTransmitters(role);
            }

            @Override
            public void svcStateReady() {
                YLKLog.i(Audience.TAG, "svcStateReady YLKLive.State:" + (Object)((Object)YLKLive.instance().getState()) + ", needRetryRequest:" + Audience.this.needRetryRequest);
                if (!YLKLive.instance().getState().equals((Object)YLKLive.State.Idle) && Audience.this.needRetryRequest) {
                    Audience.this.monitorOpen(Audience.this.streamsMonitor, false);
                }
            }
        });
        this.setupMsgHandler();
        this.setNeedMixture(Env.instance().getRole() != ClientRole.Anchor, this.needTranscode);
        this.switchTransmitters(Env.instance().getRole());
        this.vrMotionWithTouchWrapper = new VRMotionWithTouchWrapper(Env.instance().context());
        YLKLog.d(TAG, "Audience init finish!!!!");
    }

    public static Audience instance() {
        return Holder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addEventHandler(AudienceEventHandler handler) {
        YLKLog.i(TAG, "addEventHandler handler:" + handler);
        List<AudienceEventHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeEventHandler(AudienceEventHandler handler) {
        YLKLog.i(TAG, "removeEventHandler handler:" + handler);
        List<AudienceEventHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.remove(handler);
        }
        return 0;
    }

    public Set<LiveInfo> getLiveInfoSet() {
        return this.liveInfoSet;
    }

    public boolean isSupportH264HwDecode() {
        return Env.instance().getYlkMediaConfigs().isH264HardwareDecodeAvailable();
    }

    public boolean isSupportH265HwDecode() {
        return Env.instance().getYlkMediaConfigs().isH265HardwareDecodeAvailable();
    }

    public int enableH264HwDecode(final boolean hwDecode) {
        YLKLog.i(TAG, "enableH264HwDecode hwDecode:" + hwDecode);
        if (hwDecode && !this.isSupportH264HwDecode()) {
            YLKLog.i(TAG, "enableH264HwDecode hwDecode:" + hwDecode + " failed!");
            return 1;
        }
        Env.instance().setHwEnableCustomerValue(302);
        this.media.setConfigs(0, (Map)new HashMap<Integer, Integer>(){
            {
                this.put(302, hwDecode ? 1 : 0);
            }
        });
        return 0;
    }

    public int enableH265HwDecode(final boolean hwDecode) {
        YLKLog.i(TAG, "enableH265HwDecode hwDecode:" + hwDecode);
        if (hwDecode && !this.isSupportH265HwDecode()) {
            YLKLog.i(TAG, "enableH265HwDecode hwDecode:" + hwDecode + " failed!");
            return 1;
        }
        Env.instance().setHwEnableCustomerValue(316);
        this.media.setConfigs(0, (Map)new HashMap<Integer, Integer>(){
            {
                this.put(316, hwDecode ? 1 : 0);
            }
        });
        return 0;
    }

    public boolean isH264HwDecodeEnabled() {
        return this.media.getConfig(302) == 1;
    }

    public boolean isH265HwDecodeEnabled() {
        return this.media.getConfig(316) == 1;
    }

    public int setNeedMixture(boolean needMixture, boolean needTranscode) {
        YLKLog.i(TAG, "setNeedMixture needMixture:" + needMixture + ",needTranscode:" + needTranscode);
        this.needTranscode = needTranscode;
        return this.innerSetNeedMixture(needMixture, true);
    }

    private int innerSetNeedMixture(boolean needMixture, boolean updateImmediate) {
        YLKLog.i(TAG, "innerSetNeedMixture cacheNeedMixture:" + this.needMixture + ",needMixture:" + needMixture + ",updateImmediate" + updateImmediate);
        if (this.needMixture ^ needMixture || updateImmediate) {
            this.needMixture = needMixture;
            if (updateImmediate) {
                return this.updateByMixture();
            }
            return 0;
        }
        return 1;
    }

    public void enableRenderVolumeDisplay(boolean enable) {
        YLKLog.i(TAG, "enableRenderVolumeDisplay enable:" + enable);
        this.media.EnableRenderVolumeDisplay(enable);
    }

    public void enableLowLatency(final boolean enable) {
        YLKLog.i(TAG, "enableLowLatency enable:" + enable);
        this.media.setConfigs(0, (Map)new HashMap<Integer, Integer>(){
            {
                this.put(344, enable ? 1 : 0);
            }
        });
    }

    public void cancelEnableFastAccess() {
        Log.d((String)TAG, (String)"cancelEnableFastAccess called");
        SubscribHandler.instance.setEnableFastAccess(false);
    }

    public VRMotionWithTouchWrapper getVRMonitorWithTouch() {
        if (this.vrMotionWithTouchWrapper == null) {
            this.vrMotionWithTouchWrapper = new VRMotionWithTouchWrapper(Env.instance().context());
        }
        return this.vrMotionWithTouchWrapper;
    }

    public YLKMediaConfigs getLiveCodeRateConfig() {
        return Env.instance().getYlkMediaConfigs();
    }

    private void fastPlayWithoutJoin(String json) {
        if (!this.needMixture) {
            YLKLog.i(TAG, "fastPlayWithoutJoin will return!");
            return;
        }
        if (!FP.empty((CharSequence)json)) {
            final LiveInfo fastLiveInfo = LiveInfo.generateByJson(json);
            YLKLog.i(TAG, "fastPlayWithoutJoin fastLiveInfo = [" + fastLiveInfo + "]");
            this.cleanFastLiveInfo();
            if (fastLiveInfo == null) {
                this.iterateEventHandlers(new EventHandlerVisitor(){

                    @Override
                    public void visit(AudienceEventHandler handler) {
                        handler.onNoLiveInfoNotify();
                    }
                });
            } else {
                this.fastLiveInfoSet = new HashSet<LiveInfo>(){
                    {
                        this.add(fastLiveInfo);
                    }
                };
                this.cleanups.push("clean fastJoin", new Runnable(){

                    @Override
                    public void run() {
                        Audience.this.iterateEventHandlers(new EventHandlerVisitor(){

                            @Override
                            public void visit(AudienceEventHandler handler) {
                                handler.didRemoveLiveInfoSet(Audience.this.fastLiveInfoSet);
                            }
                        });
                    }
                });
                this.iterateEventHandlers(new EventHandlerVisitor(){

                    @Override
                    public void visit(AudienceEventHandler handler) {
                        handler.didAddLiveInfoSet(Audience.this.fastLiveInfoSet);
                    }
                });
            }
        } else {
            YLKLog.i(TAG, "fastPlayWithoutJoin onNoLiveInfoNotify");
            this.iterateEventHandlers(new EventHandlerVisitor(){

                @Override
                public void visit(AudienceEventHandler handler) {
                    handler.onNoLiveInfoNotify();
                }
            });
        }
    }

    private void switchTransmitters(ClientRole role) {
        if (role == ClientRole.Anchor) {
            if (!FP.empty(this.fastLiveInfoSet)) {
                YLKLog.i(TAG, "switchTransmitters didRemove fastLiveInfoSet!!");
                this.iterateEventHandlers(new EventHandlerVisitor(){

                    @Override
                    public void visit(AudienceEventHandler handler) {
                        handler.didRemoveLiveInfoSet(Audience.this.fastLiveInfoSet);
                    }
                });
            }
            SubscribHandler.instance.switchTransmitters(new Transfers.RapidTransfers());
        } else {
            SubscribHandler.instance.switchTransmitters(new Transfers.CDNTransfers());
        }
    }

    private void setupStreamsMonitor(boolean needReqAvp) {
        Assert.assertNull((Object)this.streamsMonitor);
        Assert.assertNotNull((Object)this.uid);
        Assert.assertNotNull((Object)this.channel);
        this.liveInfoSet = new HashSet<LiveInfo>();
        this.groupInfoSet = new HashSet<GroupInfo>();
        this.resetInitialInfo();
        this.cleanups.push("Clean Old StreamInfos & GroupInfos", new Runnable(){

            @Override
            public void run() {
                Audience.this.resetInitialInfo();
            }
        });
        StreamsMonitor monitor = new StreamsMonitor(this.uid, this.channel, new StreamsMonitor.Delegate(){

            private Set<GroupInfo> chooseGroupInfo(Set<GroupInfo> groupInfos) {
                HashSet<GroupInfo> target = new HashSet<GroupInfo>();
                for (GroupInfo groupInfo : groupInfos) {
                    if (Audience.this.needMixture && groupInfo.type == 3) continue;
                    target.add(groupInfo);
                }
                return target;
            }

            private Set<LiveInfo> copyLiveInfoSet(Set<LiveInfo> liveInfoSet) {
                HashSet<LiveInfo> targetSet = new HashSet<LiveInfo>();
                for (LiveInfo li : liveInfoSet) {
                    targetSet.add(new LiveInfo(li.uid, li.micNo, li.source, this.copyStreamInfoList(li.streamInfoList), li.isMix));
                }
                return targetSet;
            }

            private List<StreamInfo> copyStreamInfoList(List<StreamInfo> streamInfoList) {
                CopyOnWriteArrayList<StreamInfo> targetList = new CopyOnWriteArrayList<StreamInfo>();
                for (StreamInfo stream : streamInfoList) {
                    try {
                        targetList.add(stream.clone());
                    }
                    catch (Throwable e) {
                        YLKLog.i(Audience.TAG, "copyStreamInfoList failed:" + e);
                    }
                }
                return targetList;
            }

            private Set<GroupInfo> copyGroupInfoSet(Set<GroupInfo> groupInfoSet) {
                HashSet<GroupInfo> targetSet = new HashSet<GroupInfo>();
                for (GroupInfo gi : groupInfoSet) {
                    try {
                        targetSet.add(gi.clone());
                    }
                    catch (Throwable e) {
                        YLKLog.i(Audience.TAG, "copyGroupInfoSet failed: " + e);
                    }
                }
                return targetSet;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUpdateLiveInfo(boolean firstUpdate, Set<LiveInfo> anchorSet, Set<LiveInfo> viewerSet, Set<GroupInfo> groupSet) {
                YLKLog.i(Audience.TAG, "onUpdateLiveInfo firstUpdate = [" + firstUpdate + "], anchorSet = [" + anchorSet + "], viewerSet = [" + viewerSet + "], groupSet = [" + groupSet + "]");
                if (anchorSet == null) {
                    anchorSet = new HashSet<LiveInfo>();
                }
                if (viewerSet == null) {
                    viewerSet = new HashSet<LiveInfo>();
                }
                Audience.this.anchorInitialSet = this.copyLiveInfoSet(anchorSet);
                Audience.this.viewInitialSet = this.copyLiveInfoSet(viewerSet);
                Audience.this.groupInitialSet = this.copyGroupInfoSet(groupSet);
                anchorSet = this.filterTranscode(anchorSet);
                if (FP.empty(anchorSet) && FP.empty(viewerSet)) {
                    boolean hasEffective = false;
                    for (GroupInfo gi : groupSet) {
                        if (gi.type == 5) continue;
                        hasEffective = true;
                        break;
                    }
                    if (!hasEffective) {
                        Audience.this.groupInitialSet.clear();
                        groupSet.clear();
                    }
                }
                if (firstUpdate) {
                    Audience.this.liveInfoSet = !Audience.this.needMixture ? anchorSet : viewerSet;
                    Audience.this.groupInfoSet = this.chooseGroupInfo(groupSet);
                    Audience.this.cleanups.addFilter("clean fastJoin");
                    return;
                }
                Object object = Audience.this.infoListLock;
                synchronized (object) {
                    Set<LiveInfo> newLiveInfoSet = !Audience.this.needMixture ? anchorSet : viewerSet;
                    Audience.this.liveInfoSetDiffEval(Audience.this.liveInfoSet, newLiveInfoSet);
                    Set<GroupInfo> newGroupInfoSet = this.chooseGroupInfo(groupSet);
                    Audience.this.groupInfoSetDiffEval(Audience.this.groupInfoSet, newGroupInfoSet);
                }
            }

            Set<LiveInfo> filterTranscode(Set<LiveInfo> anchorSet) {
                YLKLog.i(Audience.TAG, "filterTranscode start: anchorSet = [" + anchorSet + "]");
                HashSet<LiveInfo> target = new HashSet<LiveInfo>();
                for (LiveInfo liveInfo : anchorSet) {
                    ArrayList<StreamInfo> wannerRemove = new ArrayList<StreamInfo>();
                    for (StreamInfo si : liveInfo.streamInfoList) {
                        if (si.type != 1) continue;
                        wannerRemove.add(si);
                    }
                    if (FP.empty(liveInfo.streamInfoList)) continue;
                    liveInfo.streamInfoList.removeAll(wannerRemove);
                    target.add(liveInfo);
                }
                YLKLog.i(Audience.TAG, "filterTranscode end: anchorSet = [" + target + "]");
                return target;
            }

            @Override
            public void onUpdateMetaData(boolean firstUpdate, final Map<Long, Map<Short, Long>> metaDataMap) {
                Audience.this.metaDataMap = metaDataMap;
                if (firstUpdate) {
                    return;
                }
                Audience.this.iterateEventHandlers(new EventHandlerVisitor(){

                    @Override
                    public void visit(AudienceEventHandler handler) {
                        handler.onUpdateMetaData(new HashMap<Long, Map<Short, Long>>(metaDataMap));
                    }
                });
            }

            @Override
            public void onUpdateTransConfig(boolean firstUpdate, Set<TransConfig> transConfig) {
                Triple<Set<TransConfig>, Set<TransConfig>, Set<TransConfig>> diff = Differences.eval(Audience.this.transConfigs, transConfig);
                if (FP.empty((Collection)((Collection)diff.a)) && FP.empty((Collection)((Collection)diff.c))) {
                    return;
                }
                Audience.this.transConfigs = transConfig;
                Audience.this.iterateEventHandlers(new EventHandlerVisitor(){

                    @Override
                    public void visit(AudienceEventHandler handler) {
                        handler.onTransConfigNotify(new HashSet<TransConfig>(Audience.this.transConfigs));
                    }
                });
            }
        });
        YLKLog.i(TAG, "StreamsMonitor open hash:" + this.hashCode());
        this.streamsMonitor = monitor;
        this.monitorOpen(this.streamsMonitor, needReqAvp);
        this.cleanups.push("teardownStreamsMonitor", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = Audience.this.infoListLock;
                synchronized (object) {
                    HashSet gcopy;
                    HashSet copy;
                    if (FP.empty((Collection)Audience.this.liveInfoSet)) {
                        Audience.this.liveInfoSet = new HashSet();
                    }
                    if (!FP.empty(copy = new HashSet(Audience.this.liveInfoSet))) {
                        YLKLog.i(Audience.TAG, "StreamsMonitor close removeLiveInfo:" + this.hashCode());
                        Audience.this.iterateEventHandlers(new EventHandlerVisitor(){

                            @Override
                            public void visit(AudienceEventHandler handler) {
                                handler.didRemoveLiveInfoSet(copy);
                            }
                        });
                        Audience.this.liveInfoSet.clear();
                    }
                    if (FP.empty((Collection)Audience.this.groupInfoSet)) {
                        Audience.this.groupInfoSet = new HashSet();
                    }
                    if (!FP.empty(gcopy = new HashSet(Audience.this.groupInfoSet))) {
                        YLKLog.i(Audience.TAG, "StreamsMonitor close removeGroupInfo:" + this.hashCode());
                        Audience.this.iterateEventHandlers(new EventHandlerVisitor(){

                            @Override
                            public void visit(AudienceEventHandler handler) {
                                handler.didRemoveGroupInfoSet(gcopy);
                            }
                        });
                        Audience.this.groupInfoSet.clear();
                    }
                }
                if (Audience.this.streamsMonitor != null) {
                    Audience.this.streamsMonitor.close();
                    Audience.this.streamsMonitor = null;
                }
            }
        });
    }

    void monitorOpen(StreamsMonitor monitor, boolean needReqAvp) {
        if (monitor == null) {
            YLKLog.i(TAG, "monitorOpen monitor = [" + monitor + "], needReqAvp = [" + needReqAvp + "]");
            return;
        }
        monitor.open(needReqAvp, new StreamsMonitor.OpenCompletion(){

            @Override
            public void onStreamsMonitorOpenSuccess() {
                YLKLog.i("YLK", "onStreamsMonitorOpenSuccess");
                Audience.this.needRetryRequest = false;
                Audience.this.iterateEventHandlers(new EventHandlerVisitor(){

                    @Override
                    public void visit(AudienceEventHandler handler) {
                        handler.onUpdateMetaData(new HashMap<Long, Map<Short, Long>>(Audience.this.metaDataMap));
                        handler.didAddGroupInfoSet(new HashSet<GroupInfo>(Audience.this.groupInfoSet));
                        if (Audience.this.channel != null && ((Audience)Audience.this).channel.delayJoin && !FP.empty((Collection)Audience.this.fastLiveInfoSet)) {
                            YLKLog.i(Audience.TAG, "onStreamsMonitorOpenSuccess didUpdateLiveInfoSet fromSet=" + Audience.this.fastLiveInfoSet + ", toSet=" + Audience.this.liveInfoSet);
                            Audience.this.liveInfoSetDiffEval(Audience.this.fastLiveInfoSet, Audience.this.liveInfoSet);
                            Audience.this.cleanFastLiveInfo();
                        } else if (!FP.empty((Collection)Audience.this.liveInfoSet)) {
                            YLKLog.i(Audience.TAG, "onStreamsMonitorOpenSuccess didAddLiveInfoSet= [" + Audience.this.liveInfoSet + "]");
                            handler.didAddLiveInfoSet(Audience.this.liveInfoSet);
                        } else {
                            handler.onNoLiveInfoNotify();
                        }
                    }
                });
            }

            @Override
            public void onStreamsMonitorOpenFailed(Service.LaunchFailure failure, String msg) {
                YLKLog.e(Audience.TAG, "onStreamsMonitorOpenFailed: " + (Object)((Object)failure) + ",state:" + (Object)((Object)YLKLive.instance().getState()) + ",streamsMonitor:" + Audience.this.streamsMonitor);
                if (!YLKLive.instance().getState().equals((Object)YLKLive.State.Idle) && Audience.this.streamsMonitor != null && failure.equals((Object)Service.LaunchFailure.SvcUnReady)) {
                    Audience.this.needRetryRequest = true;
                }
            }
        });
    }

    void liveInfoSetDiffEval(Set<LiveInfo> liveInfoSet, Set<LiveInfo> newLiveInfoSet) {
        final Triple<Set<LiveInfo>, Set<LiveInfo>, Set<LiveInfo>> diff = Differences.eval(liveInfoSet, newLiveInfoSet, new Differences.DiffOption(){

            public boolean accept(Object l, Object r) {
                YLKLog.i(Audience.TAG, "liveInfoSetDiffEval > accept l:" + l);
                YLKLog.i(Audience.TAG, "liveInfoSetDiffEval > accept r:" + r);
                return l.hashCode() == r.hashCode();
            }
        });
        YLKLog.i(TAG, "liveInfoSetDiffEval > OLD:" + liveInfoSet);
        YLKLog.i(TAG, "liveInfoSetDiffEval > NEW:" + newLiveInfoSet);
        YLKLog.i(TAG, "liveInfoSetDiffEval > DL:" + diff.a);
        YLKLog.i(TAG, "liveInfoSetDiffEval > DS:" + diff.b);
        YLKLog.i(TAG, "liveInfoSetDiffEval > DR:" + diff.c);
        if (FP.size((Collection)((Collection)diff.a)) > 0) {
            YLKLog.i(TAG, "liveInfoSetDiffEval Remove:" + diff.a);
            this.iterateEventHandlers(new EventHandlerVisitor(){

                @Override
                public void visit(AudienceEventHandler handler) {
                    handler.didRemoveLiveInfoSet(new HashSet<LiveInfo>((Collection)diff.a));
                }
            });
        }
        if (FP.size((Collection)((Collection)diff.c)) > 0) {
            YLKLog.i(TAG, "liveInfoSetDiffEval add:" + diff.c);
            this.iterateEventHandlers(new EventHandlerVisitor(){

                @Override
                public void visit(AudienceEventHandler handler) {
                    handler.didAddLiveInfoSet(new HashSet<LiveInfo>((Collection)diff.c));
                }
            });
        }
        if (FP.size((Collection)((Collection)diff.b)) > 0) {
            YLKLog.i(TAG, "UpdateLiveInfoSetDiffEval > OLD:" + diff.b);
            YLKLog.i(TAG, "UpdateLiveInfoSetDiffEval > NEW:" + newLiveInfoSet);
            final Tuple<Set<LiveInfo>, Set<LiveInfo>> update = Differences.updateCheck((Set)diff.b, newLiveInfoSet, new Differences.DiffOption(){

                public boolean accept(Object l, Object r) {
                    LiveInfo oldLi = (LiveInfo)l;
                    LiveInfo newLi = (LiveInfo)r;
                    if (FP.size(oldLi.streamInfoList) != FP.size(newLi.streamInfoList)) {
                        return true;
                    }
                    Triple<Set<StreamInfo>, Set<StreamInfo>, Set<StreamInfo>> diffStream = Differences.eval(new HashSet<StreamInfo>(oldLi.streamInfoList), new HashSet<StreamInfo>(newLi.streamInfoList), new Differences.DiffOption(){

                        public boolean accept(Object l, Object r) {
                            StreamInfo oldStream = (StreamInfo)l;
                            StreamInfo newStream = (StreamInfo)r;
                            YLKLog.i(Audience.TAG, "liveInfoSetDiffEval accept old = [" + l + "], \n new = [" + r + "]");
                            boolean equals = true;
                            equals &= oldStream.equals(newStream);
                            equals &= oldStream.video != null && newStream.video != null && oldStream.video.width == newStream.video.width && oldStream.video.height == newStream.video.height && oldStream.video.codeRate == newStream.video.codeRate;
                            equals &= oldStream.video != null && newStream.video != null && oldStream.video.mixLayout != null && newStream.video.mixLayout != null && oldStream.video.mixLayout.equals(newStream.video.mixLayout);
                            return equals &= oldStream.video != null && newStream.video != null && oldStream.video.videoGearInfo != null && newStream.video.videoGearInfo != null && oldStream.video.videoGearInfo.gear == newStream.video.videoGearInfo.gear && oldStream.video.videoGearInfo.seq == newStream.video.videoGearInfo.seq && FP.eq((Object)oldStream.video.videoGearInfo.name, (Object)newStream.video.videoGearInfo.name);
                        }
                    });
                    return FP.size((Collection)((Collection)diffStream.a)) > 0 || FP.size((Collection)((Collection)diffStream.c)) > 0;
                }
            });
            YLKLog.i(TAG, "liveInfoSetDiffEval Update from:" + update.a + " ---> to:" + update.b);
            this.iterateEventHandlers(new EventHandlerVisitor(){

                @Override
                public void visit(AudienceEventHandler handler) {
                    if (!FP.empty((Collection)((Collection)update.a)) && !FP.empty((Collection)((Collection)update.b))) {
                        handler.didUpdateLiveInfoSet(new HashSet<LiveInfo>((Collection)update.a), new HashSet<LiveInfo>((Collection)update.b));
                    }
                }
            });
        }
        liveInfoSet.clear();
        if (!FP.empty(newLiveInfoSet)) {
            liveInfoSet.addAll(newLiveInfoSet);
        }
        if (FP.empty(liveInfoSet)) {
            this.iterateEventHandlers(new EventHandlerVisitor(){

                @Override
                public void visit(AudienceEventHandler handler) {
                    handler.onNoLiveInfoNotify();
                }
            });
        }
    }

    void groupInfoSetDiffEval(Set<GroupInfo> groupInfoSet, Set<GroupInfo> newGroupInfoSet) {
        final Triple<Set<GroupInfo>, Set<GroupInfo>, Set<GroupInfo>> diff = Differences.eval(groupInfoSet, newGroupInfoSet);
        if (FP.size((Collection)((Collection)diff.a)) > 0) {
            groupInfoSet.removeAll((Collection)diff.a);
            YLKLog.i(TAG, "groupInfoSetDiffEval remove:" + diff.a);
            this.iterateEventHandlers(new EventHandlerVisitor(){

                @Override
                public void visit(AudienceEventHandler handler) {
                    handler.didRemoveGroupInfoSet(new HashSet<GroupInfo>((Collection)diff.a));
                }
            });
        }
        if (FP.size((Collection)((Collection)diff.c)) > 0) {
            groupInfoSet.addAll((Collection)diff.c);
            YLKLog.i(TAG, "groupInfoSetDiffEval add:" + diff.c);
            this.iterateEventHandlers(new EventHandlerVisitor(){

                @Override
                public void visit(AudienceEventHandler handler) {
                    handler.didAddGroupInfoSet(new HashSet<GroupInfo>((Collection)diff.c));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateEventHandlers(EventHandlerVisitor visitor) {
        List<AudienceEventHandler> list = this.handlers;
        synchronized (list) {
            for (AudienceEventHandler handler : this.handlers) {
                visitor.visit(handler);
            }
        }
    }

    @Override
    public void onJoinSuccess(Channel channel) {
        boolean delayJoin;
        YLKLog.i(TAG, "onJoinSuccess channel:" + channel + ",hash:" + this.hashCode());
        this.channel = channel;
        this.uid = YLKLive.instance().getUid();
        this.cleanups.flush(null);
        if (channel == null) {
            return;
        }
        this.cleanFastLiveInfo();
        boolean bl = delayJoin = channel != null && channel.delayJoin;
        if (delayJoin) {
            this.fastPlayWithoutJoin(YLKLive.instance().getChannelSource());
        }
        this.setupStreamsMonitor(!delayJoin);
        SubscribHandler.instance.startTrigger();
        this.cleanups.push("stopTrigger", new Runnable(){

            @Override
            public void run() {
                SubscribHandler.instance.stopTrigger();
            }
        });
    }

    @Override
    public void onJoinFailed(int statusCode, String message) {
    }

    @Override
    public void onLeave() {
        this.uid = 0L;
        this.channel = null;
        this.needRetryRequest = false;
        Env.instance().defaultVideoLineNum = -1;
        Env.instance().currentStreamVersion = 0L;
        YLKLog.i(TAG, "Audience onLeave hash:" + this.hashCode());
        SubscribHandler.instance.cleanStreams().cleanGroups().execute();
        this.cleanups.flush(null);
        YLKLog.i(TAG, "Audience onLeave fastLiveInfoSet:" + this.fastLiveInfoSet);
    }

    private void cleanFastLiveInfo() {
        YLKLog.i(TAG, "cleanFastLiveInfo called");
        if (this.fastLiveInfoSet != null) {
            this.fastLiveInfoSet.clear();
        }
    }

    private void resetInitialInfo() {
        this.anchorInitialSet = null;
        this.viewInitialSet = null;
        this.groupInitialSet = null;
    }

    private int updateByMixture() {
        YLKLog.i(TAG, "updateByMixture called");
        if (this.anchorInitialSet == null && this.viewInitialSet == null && this.groupInitialSet == null) {
            return 1;
        }
        if (this.streamsMonitor != null && this.streamsMonitor.delegate != null) {
            this.streamsMonitor.delegate.onUpdateLiveInfo(false, this.anchorInitialSet, this.viewInitialSet, this.groupInitialSet);
            return 0;
        }
        return 1;
    }

    private void setupMsgHandler() {
        final ArrayList<Integer> needMsgType = new ArrayList<Integer>(){
            {
                this.add(201);
                this.add(130);
                this.add(136);
                this.add(222);
                this.add(504);
                this.add(502);
                this.add(205);
            }
        };
        YLKLive.instance().registerMediaEventHandler(new YLKLive.MediaMsgEventHandler(){

            @Override
            public void handleMessage(Message mediaMsg) {
                if (!needMsgType.contains(mediaMsg.what)) {
                    return;
                }
                final Object obj = mediaMsg.obj;
                final int what = mediaMsg.what;
                RunInMain.dispatch(new Runnable(){

                    @Override
                    public void run() {
                        switch (what) {
                            case 201: {
                                YLKLog.i(Audience.TAG, "onAudioLinkInfoNotity:" + obj);
                                Audience.this.iterateEventHandlers(new EventHandlerVisitor(){

                                    @Override
                                    public void visit(AudienceEventHandler handler) {
                                        handler.onAudioLinkInfoNotify((MediaVideoMsg.MediaLinkInfo)obj);
                                    }
                                });
                                break;
                            }
                            case 130: {
                                YLKLog.i(Audience.TAG, "onVideoViewerLossNotifyInfo:" + obj);
                                Audience.this.iterateEventHandlers(new EventHandlerVisitor(){

                                    @Override
                                    public void visit(AudienceEventHandler handler) {
                                        handler.onVideoViewerLossNotifyInfo((MediaVideoMsg.VideoViewLossNotifyInfo)obj);
                                    }
                                });
                                break;
                            }
                            case 136: {
                                YLKLog.i(Audience.TAG, "onFirstFrameSeeNotify:" + obj);
                                Audience.this.iterateEventHandlers(new EventHandlerVisitor(){

                                    @Override
                                    public void visit(AudienceEventHandler handler) {
                                        handler.onFirstFrameSeeNotify((MediaVideoMsg.FirstFrameSeeInfo)obj);
                                    }
                                });
                                break;
                            }
                            case 222: {
                                Audience.this.iterateEventHandlers(new EventHandlerVisitor(){

                                    @Override
                                    public void visit(AudienceEventHandler handler) {
                                        handler.onAudioRenderVolume((MediaVideoMsg.AudioRenderVolumeInfo)obj);
                                    }
                                });
                                break;
                            }
                            case 504: {
                                YLKLog.i(Audience.TAG, "onLiveStreamLineInfo:" + obj);
                                MediaVideoMsg.LiveStreamLineInfo lineInfo = (MediaVideoMsg.LiveStreamLineInfo)obj;
                                if (lineInfo.lineFrom != 2) break;
                                YLKLog.i(Audience.TAG, "onLiveStreamLineInfo onSuggestPlayVideoLine:" + lineInfo.curLineSeq);
                                Env.instance().defaultVideoLineNum = lineInfo.curLineSeq;
                                break;
                            }
                            case 502: {
                                YLKLog.i(Audience.TAG, "onLiveAudioStreamStatus:" + obj);
                                Audience.this.iterateEventHandlers(new EventHandlerVisitor(){

                                    @Override
                                    public void visit(AudienceEventHandler handler) {
                                        handler.onAudioStreamStatusInfo((MediaVideoMsg.LiveAudioStreamStatusInfo)obj);
                                    }
                                });
                                break;
                            }
                            case 205: {
                                YLKLog.i(Audience.TAG, "onChannelAudioStateNotify:" + obj);
                                Audience.this.iterateEventHandlers(new EventHandlerVisitor(){

                                    @Override
                                    public void visit(AudienceEventHandler handler) {
                                        handler.onChannelAudioStateNotify((MediaVideoMsg.ChannelAudioStateInfo)obj);
                                    }
                                });
                                break;
                            }
                        }
                    }
                });
            }
        });
    }

    private static class Holder {
        private static final Audience instance = new Audience();

        private Holder() {
        }
    }

    private static interface EventHandlerVisitor {
        public void visit(AudienceEventHandler var1);
    }

    static interface FilterCallback {
        public void remove(LiveInfo var1, Set<StreamInfo> var2);
    }
}

