/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.utils;

import com.yy.livekit.protocol.nano.StreamCliMsg2C;
import com.yy.yylivekit.services.core.Uint32;
import com.yyproto.utils.FP;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class MessageUtils {
    public static String printStreams(StreamCliMsg2C.StreamInfo[] streams) {
        if (FP.empty((Object[])streams)) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (StreamCliMsg2C.StreamInfo streamInfo : streams) {
            MessageUtils.printStreamInfo(streamInfo, stringBuffer);
            stringBuffer.append("\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void printStreamInfo(StreamCliMsg2C.StreamInfo streamInfo, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return;
        }
        if (streamInfo != null) {
            stringBuffer.append("StreamInfo{");
            stringBuffer.append("streamName:" + streamInfo.streamName);
            stringBuffer.append(",appid:" + streamInfo.appid);
            stringBuffer.append(",bid:" + streamInfo.bid);
            stringBuffer.append(",uid:" + Uint32.toUInt(streamInfo.uid).longValue());
            stringBuffer.append(",cid:" + Uint32.toUInt(streamInfo.cid).longValue());
            stringBuffer.append(",sid:" + Uint32.toUInt(streamInfo.sid).longValue());
            stringBuffer.append(",micNo:" + streamInfo.micNo);
            stringBuffer.append(",json:" + streamInfo.json);
            stringBuffer.append(",audioVideoGroup:" + streamInfo.audioVideoGroup);
            stringBuffer.append(",metadata:" + streamInfo.metadata);
            stringBuffer.append(",streamGroup:" + streamInfo.streamGroup);
            stringBuffer.append(",mix:" + streamInfo.mix);
            stringBuffer.append(",extend:" + streamInfo.extend);
            stringBuffer.append(",type:" + streamInfo.type);
            stringBuffer.append(",ver:" + streamInfo.ver);
            stringBuffer.append(",gear:" + streamInfo.gear);
            stringBuffer.append(",mixGroupNo:" + streamInfo.mixGroupNo);
            stringBuffer.append("}");
        } else {
            stringBuffer.append("StreamInfo{}");
        }
    }

    public static String printRules(StreamCliMsg2C.StreamVisibilityRule[] rules) {
        if (FP.empty((Object[])rules)) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (StreamCliMsg2C.StreamVisibilityRule rule : rules) {
            MessageUtils.printVisibilityRule(rule, stringBuffer);
            stringBuffer.append("\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void printVisibilityRule(StreamCliMsg2C.StreamVisibilityRule visibilityRule, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return;
        }
        if (visibilityRule != null) {
            stringBuffer.append("StreamVisibilityRule{");
            MessageUtils.printFieldRegion(visibilityRule.type, stringBuffer, "type");
            stringBuffer.append(",");
            MessageUtils.printFieldRegion(visibilityRule.mix, stringBuffer, "mix");
            stringBuffer.append(",");
            MessageUtils.printFieldRegion(visibilityRule.gear, stringBuffer, "gear");
            stringBuffer.append(",");
            MessageUtils.printObjectRegion(visibilityRule.json, stringBuffer, "json");
            stringBuffer.append("}");
        } else {
            stringBuffer.append("StreamVisibilityRule{}");
        }
    }

    public static String printClientAttribute(StreamCliMsg2C.ClientAttribute clientAttribute) {
        if (clientAttribute == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("H265:").append(clientAttribute.h265).append(" ");
        sb.append("Cpu:").append(clientAttribute.cpu).append(" ");
        sb.append("CpuFrequency:").append(clientAttribute.cpuFrequency).append(" ");
        sb.append("GraphicsCard:").append(clientAttribute.graphicsCard).append(" ");
        sb.append("DeviceMemory:").append(clientAttribute.deviceMemory).append(" ");
        return sb.toString();
    }

    private static void printFieldRegion(StreamCliMsg2C.FieldRegion fieldRegion, StringBuffer stringBuffer, String field) {
        if (stringBuffer == null) {
            return;
        }
        stringBuffer.append(field);
        if (fieldRegion != null) {
            stringBuffer.append("{");
            MessageUtils.printIntegerRegion(fieldRegion.integer, stringBuffer, "integer");
            stringBuffer.append(",");
            MessageUtils.printStringRegion(fieldRegion.str, stringBuffer, "str");
            stringBuffer.append(",");
            MessageUtils.printObjectRegion(fieldRegion.attr, stringBuffer, "attr");
            stringBuffer.append("}");
        } else {
            stringBuffer.append("{}");
        }
    }

    private static void printIntegerRegion(StreamCliMsg2C.IntegerRegion integerRegion, StringBuffer stringBuffer, String field) {
        if (stringBuffer == null) {
            return;
        }
        stringBuffer.append(field);
        if (integerRegion != null) {
            stringBuffer.append("{");
            String discrete = integerRegion.discrete != null ? Arrays.toString(integerRegion.discrete.values) : null;
            String range = integerRegion.range != null ? "min:" + integerRegion.range.minValue + ",max:" + integerRegion.range.maxValue : null;
            stringBuffer.append("discrete:" + discrete);
            stringBuffer.append(",");
            stringBuffer.append("range:" + range);
            stringBuffer.append("}");
        } else {
            stringBuffer.append("{}");
        }
    }

    private static void printStringRegion(StreamCliMsg2C.StringRegion stringRegion, StringBuffer stringBuffer, String field) {
        if (stringBuffer == null) {
            return;
        }
        stringBuffer.append(field);
        if (stringRegion != null) {
            stringBuffer.append("{");
            stringBuffer.append("values:" + Arrays.toString(stringRegion.values));
            stringBuffer.append("}");
        } else {
            stringBuffer.append("{}");
        }
    }

    private static void printObjectRegion(StreamCliMsg2C.ObjectRegion objectRegion, StringBuffer stringBuffer, String field) {
        if (stringBuffer == null) {
            return;
        }
        stringBuffer.append(field);
        if (objectRegion != null && !FP.empty(objectRegion.fields)) {
            stringBuffer.append("{");
            Set<Map.Entry<String, StreamCliMsg2C.FieldRegion>> entrySet = objectRegion.fields.entrySet();
            for (Map.Entry<String, StreamCliMsg2C.FieldRegion> entry : entrySet) {
                stringBuffer.append(entry.getKey() + ":");
                MessageUtils.printFieldRegion(entry.getValue(), stringBuffer, "");
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append("{}");
        }
    }
}

