/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.utils.PrefStorage;
import com.yyproto.utils.FP;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.UUID;

public final class RuntimeKit {
    private static final String TAG = "RuntimeKit";
    private static volatile String uniqueID;
    private static volatile String appVersion;

    private RuntimeKit() {
    }

    public static long getTotalRam(Context context) {
        try {
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
            manager.getMemoryInfo(info);
            return info.totalMem;
        }
        catch (Exception e) {
            YLKLog.i(TAG, "getTotalRam failed!");
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCurCPU() {
        String CurPath = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq";
        int result = 0;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader("/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq");
            br = new BufferedReader(fr);
            String text = br.readLine();
            result = Integer.parseInt(text.trim());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static String appVersion(Context context) {
        if (!FP.empty((CharSequence)appVersion)) {
            return appVersion;
        }
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            appVersion = info.versionName;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return appVersion;
    }

    public static String appPackageName(Context context) {
        String pkgName;
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            pkgName = info.packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            pkgName = null;
        }
        return pkgName;
    }

    public static String uniqueID(Context context) {
        if (uniqueID != null) {
            return uniqueID;
        }
        PrefStorage storage = new PrefStorage(context.getApplicationContext(), TAG);
        storage.load(new PrefStorage.Load(){

            @Override
            public String key() {
                return "Unique ID";
            }

            @Override
            public String guard() {
                return null;
            }

            @Override
            public boolean decode(String content) {
                uniqueID = content;
                return true;
            }
        });
        if (uniqueID == null) {
            uniqueID = UUID.randomUUID().toString();
            storage.store(new PrefStorage.Store(){

                @Override
                public String key() {
                    return "Unique ID";
                }

                @Override
                public String encoded() {
                    return uniqueID;
                }
            });
        }
        return uniqueID;
    }
}

