/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.trigger;

public class PeriodicJob<T> {
    public final long id = System.currentTimeMillis();
    public final T parmas;
    public State state;
    public final Condition condition;
    public final Action action;
    public long intervalMillis;
    public final boolean autoRepeat;
    long lastFire;
    long lastInvalidate;
    boolean immediately = false;

    public PeriodicJob(long intervalMillis, T parmas, Action action) {
        this(intervalMillis, parmas, false, new Condition(){

            @Override
            public Boolean shouldTrigger() {
                return true;
            }
        }, action);
    }

    public PeriodicJob(long intervalMillis, T parmas, boolean autoRepeat, Condition condition, Action action) {
        this.intervalMillis = intervalMillis;
        this.condition = condition;
        this.action = action;
        this.parmas = parmas;
        this.autoRepeat = autoRepeat;
    }

    public void invalidate() {
        this.immediately = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeriodicJob that = (PeriodicJob)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "PeriodicJob{id=" + this.id + ", autoRepeat=" + this.autoRepeat + ", state=" + (Object)((Object)this.state) + '}';
    }

    public static interface Action<T> {
        public void onTrigger(PeriodicJob var1, Completion var2);
    }

    public static interface Completion {
        public void onComplete(PeriodicJob var1, Boolean var2);
    }

    public static interface Condition {
        public Boolean shouldTrigger();
    }

    public static enum State {
        Idle,
        Firing;

    }
}

