/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.observables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;

public class ObservableList<ValueType> {
    private final List<ValueType> list = new ArrayList<ValueType>();
    private final HashMap<Object, ArrayList<Observer<ValueType>>> observers = new HashMap();

    private void forAllObservers(Iterator<ValueType> iterator) {
        for (ArrayList<Observer<ValueType>> list : this.observers.values()) {
            for (Observer<ValueType> o : list) {
                iterator.iterate(o);
            }
        }
    }

    public List<ValueType> get() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void add(final ValueType object) {
        this.forAllObservers(new Iterator<ValueType>(){

            @Override
            public void iterate(Observer<ValueType> observer) {
                observer.willAdd(object);
            }
        });
        this.list.add(object);
        this.forAllObservers(new Iterator<ValueType>(){

            @Override
            public void iterate(Observer<ValueType> observer) {
                observer.didAdd(object);
                observer.updated(false, ObservableList.this.list);
            }
        });
    }

    public void add(int index, final ValueType object) {
        this.forAllObservers(new Iterator<ValueType>(){

            @Override
            public void iterate(Observer<ValueType> observer) {
                observer.willAdd(object);
            }
        });
        this.list.add(index, object);
        this.forAllObservers(new Iterator<ValueType>(){

            @Override
            public void iterate(Observer<ValueType> observer) {
                observer.didAdd(object);
                observer.updated(false, ObservableList.this.list);
            }
        });
    }

    public void remove(ValueType object) {
        Assert.assertTrue((boolean)this.list.contains(object));
        if (!this.list.contains(object)) {
            return;
        }
        int idx = this.list.indexOf(object);
        this.remove(idx);
    }

    public void remove(int index) {
        Assert.assertTrue((this.list.size() > index ? 1 : 0) != 0);
        final ValueType object = this.list.get(index);
        this.forAllObservers(new Iterator<ValueType>(){

            @Override
            public void iterate(Observer<ValueType> observer) {
                observer.willRemove(object);
            }
        });
        this.list.remove(index);
        this.forAllObservers(new Iterator<ValueType>(){

            @Override
            public void iterate(Observer<ValueType> observer) {
                observer.didRemove(object);
                observer.updated(false, ObservableList.this.list);
            }
        });
    }

    public ValueType at(int index) {
        return this.list.get(index);
    }

    public void clear() {
        while (!this.list.isEmpty()) {
            ValueType object = this.list.get(0);
            this.remove(object);
        }
    }

    public Boolean contains(ValueType object) {
        return this.list.contains(object);
    }

    public void register(Object context, Boolean wantsInitial, Observer<ValueType> observer) {
        ArrayList<Observer<Object>> itsObservers = this.observers.get(context);
        if (itsObservers == null) {
            itsObservers = new ArrayList();
            this.observers.put(context, itsObservers);
        }
        itsObservers.add(observer);
        if (wantsInitial.booleanValue()) {
            observer.updated(true, this.list);
        }
    }

    public void unregister(Object context) {
        this.observers.remove(context);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(ObservableList[").append(this.observers.size()).append("]");
        if (this.list.size() == 0) {
            sb.append(" <empty> ");
        } else if (this.list.size() > 1) {
            sb.append("\n");
        }
        for (ValueType v : this.list) {
            sb.append(v).append("\n");
        }
        sb.append(")");
        return sb.toString();
    }

    private static interface Iterator<InnerValue> {
        public void iterate(Observer<InnerValue> var1);
    }

    public static abstract class Observer<InnerValue> {
        public void willAdd(InnerValue object) {
        }

        public void didAdd(InnerValue object) {
        }

        public void willRemove(InnerValue object) {
        }

        public void didRemove(InnerValue object) {
        }

        public void updated(boolean isInitial, List<InnerValue> objects) {
        }
    }
}

