/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.model;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;

public class LiveMeta {
    public final int level;
    public final VideoMeta video;
    public final AudioMeta audio;
    public final String group;

    public LiveMeta(int level, VideoMeta video, AudioMeta audio, String group) {
        this.level = level;
        this.video = video;
        this.audio = audio;
        this.group = group;
    }

    public String toString() {
        return "LiveMeta{level=" + this.level + ", video=" + this.video + ", audio=" + this.audio + ", group='" + this.group + '\'' + '}';
    }

    public static class AudioMeta {
        public final String name;
        public final String group;

        public AudioMeta(String name, String group) {
            this.name = name;
            this.group = group;
        }

        public String toString() {
            return "AudioMeta{name='" + this.name + '\'' + ", group='" + this.group + '\'' + '}';
        }
    }

    public static class VideoMeta {
        public final String name;
        public final EncodeMeta encode;

        public VideoMeta(String name, EncodeMeta encode) {
            this.name = name;
            this.encode = encode;
        }

        public String toString() {
            return "VideoMeta{name='" + this.name + '\'' + ", encode=" + this.encode + '}';
        }
    }

    public static class ModifyMeta {
        public final int width;
        public final int height;
        public final int minCodeRate;
        public final int maxCodeRate;
        public final int minFrameRate;
        public final int maxFrameRate;
        public int encodeId;
        public String encodeParam;

        public ModifyMeta(int width, int height, int minCodeRate, int maxCodeRate, int minFrameRate, int maxFrameRate, int encodeId, String encodeParam) {
            this.width = width;
            this.height = height;
            this.minCodeRate = minCodeRate;
            this.maxCodeRate = maxCodeRate;
            this.minFrameRate = minFrameRate;
            this.maxFrameRate = maxFrameRate;
            this.encodeId = encodeId;
            this.encodeParam = encodeParam;
        }

        public String toString() {
            return "ModifyMeta{width=" + this.width + ", height=" + this.height + ", minCodeRate=" + this.minCodeRate + ", maxCodeRate=" + this.maxCodeRate + ", minFrameRate=" + this.minFrameRate + ", maxFrameRate=" + this.maxFrameRate + ", encodeId=" + this.encodeId + ", encodeParam='" + this.encodeParam + '\'' + '}';
        }
    }

    public static class EncodeMeta {
        public final int isDefault;
        public final int key;
        public final int width;
        public final int height;
        public final int codeRate;
        public final int currate;
        public final int minrate;
        public final int maxrate;
        public final int frameRate;
        public final int pvWidth;
        public final int pvHeight;
        public final int pvFrameRate;
        public int type;
        public String param;
        public final List<ModifyMeta> modifyMetaList;

        public EncodeMeta(int isDefault, int key, int width, int height, int codeRate, int currate, int minrate, int maxrate, int frameRate, int type, String param, int pvWidth, int pvHeight, int pvFrameRate, List<ModifyMeta> modifys) {
            Assert.assertNotNull((Object)param);
            this.isDefault = isDefault;
            this.key = key;
            this.width = width;
            this.height = height;
            this.codeRate = codeRate;
            this.currate = currate == -1 ? codeRate : currate;
            this.minrate = minrate == -1 ? 100 : minrate;
            this.maxrate = maxrate == -1 ? 1200 : maxrate;
            this.frameRate = frameRate;
            this.param = param;
            this.type = type;
            this.pvWidth = pvWidth == -1 ? 720 : pvWidth;
            this.pvHeight = pvHeight == -1 ? 1280 : pvHeight;
            this.pvFrameRate = pvFrameRate <= 0 || pvFrameRate < frameRate ? frameRate : pvFrameRate;
            this.modifyMetaList = modifys;
        }

        public String toString() {
            return "EncodeMeta{isDefault=" + this.isDefault + ", key=" + this.key + ", width=" + this.width + ", height=" + this.height + ", codeRate=" + this.codeRate + ", currate=" + this.currate + ", minrate=" + this.minrate + ", maxrate=" + this.maxrate + ", frameRate=" + this.frameRate + ", pvWidth=" + this.pvWidth + ", pvHeight=" + this.pvHeight + ", pvFrameRate=" + this.pvFrameRate + ", type=" + this.type + ", param='" + this.param + '\'' + ", modifyMetaList=" + this.modifyMetaList + '}';
        }

        public static EncodeMeta toLandscape(EncodeMeta origin) {
            if (origin.width >= origin.height) {
                return origin;
            }
            ArrayList<ModifyMeta> landscapeModifyMetaList = new ArrayList<ModifyMeta>();
            for (ModifyMeta modifyMeta : origin.modifyMetaList) {
                landscapeModifyMetaList.add(new ModifyMeta(modifyMeta.height, modifyMeta.width, modifyMeta.minCodeRate, modifyMeta.maxCodeRate, modifyMeta.minFrameRate, modifyMeta.maxFrameRate, modifyMeta.encodeId, modifyMeta.encodeParam));
            }
            return new EncodeMeta(origin.isDefault, origin.key, origin.height, origin.width, origin.codeRate, origin.currate, origin.minrate, origin.maxrate, origin.frameRate, origin.type, origin.param, origin.pvHeight, origin.pvWidth, origin.pvFrameRate, landscapeModifyMetaList);
        }
    }
}

