/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.model;

import com.yy.yylivekit.BuildConfig;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.AudioInfo;
import com.yy.yylivekit.model.BuzInfo;
import com.yy.yylivekit.model.StreamFilters;
import com.yy.yylivekit.model.StreamInfo;
import com.yy.yylivekit.model.VideoGearInfo;
import com.yy.yylivekit.model.VideoInfo;
import com.yy.yylivekit.utils.DebugException;
import com.yy.yylivekit.utils.JsonUtils;
import com.yyproto.utils.FP;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONException;

public class LiveInfo
implements Serializable {
    private static final String TAG = "LiveInfo";
    public final long uid;
    public CopyOnWriteArrayList<StreamInfo> streamInfoList;
    public final boolean isMix;
    public int micNo;
    public final int source;
    private final boolean isMS;

    public LiveInfo(long uid, int micNo, int source, List<StreamInfo> streamInfoList, boolean isMix) {
        this.uid = uid;
        this.streamInfoList = this.filterStreamInfo(streamInfoList);
        this.isMix = isMix;
        this.micNo = micNo;
        this.source = source;
        this.isMS = this.isMultiSource();
    }

    private CopyOnWriteArrayList<StreamInfo> filterStreamInfo(List<StreamInfo> streamInfoList) {
        if (!FP.empty(streamInfoList)) {
            ArrayList<StreamInfo> hasVideoList = new ArrayList<StreamInfo>();
            ArrayList<StreamInfo> noVideoList = new ArrayList<StreamInfo>();
            for (StreamInfo streamInfo : streamInfoList) {
                if (streamInfo.video != null) {
                    hasVideoList.add(streamInfo);
                    continue;
                }
                noVideoList.add(streamInfo);
            }
            if (!FP.empty(hasVideoList) && !FP.empty(noVideoList)) {
                return new CopyOnWriteArrayList<StreamInfo>(hasVideoList);
            }
        }
        return new CopyOnWriteArrayList<StreamInfo>(streamInfoList);
    }

    public boolean isMultiSource() {
        VideoInfo videoInfo = (VideoInfo)FP.first(this.getVideoSet());
        AudioInfo audioInfo = (AudioInfo)FP.first(this.getAudioSet());
        return videoInfo != null ? videoInfo.isMultSource : (audioInfo != null ? audioInfo.isMultSource : false);
    }

    public List<VideoGearInfo> getVideoQuality() {
        return this.sortQualities(this.streamsForCurrentProperties().keySet());
    }

    public Map<VideoGearInfo, StreamInfo> streamsForCurrentProperties() {
        YLKLog.i(TAG, "streamsForCurrentProperties() called");
        List<StreamInfo> streams = new StreamFilters.EncodePreferenceFilter(true).filter(this.streamInfoList);
        HashMap<VideoGearInfo, StreamInfo> streamsByQuality = new HashMap<VideoGearInfo, StreamInfo>();
        for (StreamInfo si : streams) {
            if (si.video == null || si.video.videoGearInfo == null) continue;
            streamsByQuality.put(si.video.videoGearInfo, si);
        }
        YLKLog.i(TAG, "streamsForCurrentProperties() End " + streamsByQuality);
        return streamsByQuality;
    }

    public BuzInfo getBuzInfo() {
        if (FP.empty(this.streamInfoList) || ((StreamInfo)FP.first(this.streamInfoList)).video == null) {
            return new BuzInfo(-1, -1);
        }
        return ((StreamInfo)FP.first(this.streamInfoList)).video.buzInfo;
    }

    public Set<VideoInfo> getVideoSet() {
        HashSet<VideoInfo> videoInfos = new HashSet<VideoInfo>();
        if (!FP.empty(this.streamInfoList)) {
            for (StreamInfo streamInfo : this.streamInfoList) {
                if (streamInfo.video == null) continue;
                videoInfos.add(streamInfo.video);
            }
        }
        return videoInfos;
    }

    public Set<AudioInfo> getAudioSet() {
        HashSet<AudioInfo> audioInfos = new HashSet<AudioInfo>();
        if (!FP.empty(this.streamInfoList)) {
            for (StreamInfo streamInfo : this.streamInfoList) {
                if (streamInfo.audio == null) continue;
                audioInfos.add(streamInfo.audio);
            }
        }
        return audioInfos;
    }

    public boolean hasVideo() {
        if (FP.empty(this.streamInfoList)) {
            return false;
        }
        StreamInfo firstStreamInfo = (StreamInfo)FP.first(this.streamInfoList);
        return firstStreamInfo != null && firstStreamInfo.video != null;
    }

    private List<VideoGearInfo> sortQualities(Set<VideoGearInfo> qualitesSet) {
        ArrayList<VideoGearInfo> sorted = new ArrayList<VideoGearInfo>();
        sorted.addAll(qualitesSet);
        Collections.sort(sorted, new Comparator<VideoGearInfo>(){

            @Override
            public int compare(VideoGearInfo lhs, VideoGearInfo rhs) {
                int lhsWeight = lhs.seq;
                int rhsWeight = rhs.seq;
                if (lhsWeight >= rhsWeight) {
                    return 1;
                }
                return -1;
            }
        });
        return sorted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveInfo liveInfo = (LiveInfo)o;
        if (this.uid != liveInfo.uid) {
            return false;
        }
        if (this.isMix != liveInfo.isMix) {
            return false;
        }
        if (this.source != liveInfo.source) {
            return false;
        }
        return this.isMS == liveInfo.isMS;
    }

    public int hashCode() {
        int result = (int)(this.uid ^ this.uid >>> 32);
        result = 31 * result + (this.isMix ? 1 : 0);
        result = 31 * result + this.source;
        result = 31 * result + (this.isMS ? 1 : 0);
        return result;
    }

    public String toString() {
        return "LiveInfo{uid=" + this.uid + ", isMix=" + this.isMix + ", micNo=" + this.micNo + ", source=" + this.source + ", isMs=" + this.isMS + ", streamInfoList=" + this.streamInfoList + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveInfo generateByJson(String json) {
        LiveInfo li = null;
        JSONException ex = null;
        try {
            li = JsonUtils.makeLiveInfo(json);
            return li;
        }
        catch (JSONException e) {
            if (BuildConfig.DEBUG) {
                ex = e;
            }
            YLKLog.e(TAG, "generateByJson failed:" + (Object)((Object)e));
        }
        finally {
            if (ex != null) {
                throw new DebugException("generateByJson failed:" + (Object)((Object)ex));
            }
            return li;
        }
    }
}

