/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience.monitor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.medialib.video.MediaVideoMsg;
import com.yy.livekit.protocol.nano.StreamCliMsg2C;
import com.yy.yylivekit.audience.monitor.AcceptanceRulesV2;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.AudioInfo;
import com.yy.yylivekit.model.BuzInfo;
import com.yy.yylivekit.model.GroupInfo;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.MetaData;
import com.yy.yylivekit.model.MixVideoLayout;
import com.yy.yylivekit.model.StreamInfo;
import com.yy.yylivekit.model.TransConfig;
import com.yy.yylivekit.model.VideoGearInfo;
import com.yy.yylivekit.model.VideoInfo;
import com.yy.yylivekit.model.VideoQuality;
import com.yy.yylivekit.services.core.Uint32;
import com.yy.yylivekit.utils.ArrayUtils;
import com.yy.yylivekit.utils.JsonUtils;
import com.yy.yylivekit.utils.Tuple;
import com.yy.yylivekit.utils.VideoQualityCalc;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.json.JSONArray;
import org.json.JSONObject;

public class LiveInfoFactoryV2 {
    private static final String TAG = "LiveInfoFactoryV2";
    public static final String RetAnchorStream = "AnchorStream";
    public static final String RetAudienceStream = "AudienceStream";
    public static final String RetTransConfig = "TransConfig";
    public static final String RetGroupInfo = "GroupInfo";
    public static final String RetSource = "Source";
    public static final String RetMicNum = "MicNum";
    public static final String RetStreamInfo = "StreamInfo";
    private static final Map<String, Integer> conversionRules = new HashMap<String, Integer>(){
        {
            this.put("rate", MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_CODE_RATE);
            this.put("encoderType", MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_ENCODE_TYPE);
            this.put("channel", MediaVideoMsg.LiveStreamCfgKey.STREMA_CONFIG_KEY_AUDIO_CHANNELS);
            this.put("sample_rate", MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_AUDIO_SAMPLERATE);
            this.put("fps", MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_FRAME_RATE);
            this.put("width", MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_RESOLUTION_WIDTH);
            this.put("height", MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_RESOLUTION_HEIGHT);
        }
    };
    private static final String[] requisiteAttrElements = new String[]{"rate", "encoderType", "width", "height", "fps"};

    public static Map<String, Object> make(AcceptanceRulesV2 rules, StreamCliMsg2C.ChannelStreamInfo channelStreamInfo) {
        StreamCliMsg2C.StreamInfo[] streamArray = !FP.empty((Object[])channelStreamInfo.streams) ? channelStreamInfo.streams : StreamCliMsg2C.StreamInfo.emptyArray();
        List<GroupInfo> groupInfoList = LiveInfoFactoryV2.extractLiveGroupInfo(streamArray);
        Map<String, Object> anchorInfo = LiveInfoFactoryV2.makeAnchorBundle(streamArray, rules);
        Set<LiveInfo> viewerSet = LiveInfoFactoryV2.makeViewerBundle(streamArray, rules);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(RetAudienceStream, viewerSet);
        ret.put(RetGroupInfo, groupInfoList);
        ret.put(RetAnchorStream, anchorInfo.get(RetAnchorStream));
        ret.put(RetTransConfig, anchorInfo.get(RetTransConfig));
        return ret;
    }

    private static Set<LiveInfo> makeViewerBundle(StreamCliMsg2C.StreamInfo[] streamArray, AcceptanceRulesV2 rules) {
        Map<Integer, List<StreamInfo>> viewerStreams = LiveInfoFactoryV2.parseViewerStreamInfos(streamArray, rules);
        YLKLog.i(TAG, "makeViewerBundle viewerInfoSize:" + FP.size(viewerStreams));
        YLKLog.i(TAG, "makeViewerBundle viewerInfo:" + viewerStreams);
        HashSet<LiveInfo> targetViewer = new HashSet<LiveInfo>();
        Set<Integer> sourceSet = viewerStreams.keySet();
        for (Integer source : sourceSet) {
            List<StreamInfo> viewerStream = viewerStreams.get(source);
            if (FP.empty(viewerStream)) continue;
            targetViewer.add(new LiveInfo(0L, -1, source, viewerStream, true));
        }
        return LiveInfoFactoryV2.filterLiveInfo(targetViewer);
    }

    private static Set<LiveInfo> filterLiveInfo(Set<LiveInfo> liveInfoSet) {
        if (FP.size(liveInfoSet) > 1) {
            HashSet<LiveInfo> hasVideoSet = new HashSet<LiveInfo>();
            HashSet<LiveInfo> noVideoSet = new HashSet<LiveInfo>();
            for (LiveInfo liveInfo : liveInfoSet) {
                if (liveInfo.hasVideo()) {
                    hasVideoSet.add(liveInfo);
                    continue;
                }
                noVideoSet.add(liveInfo);
            }
            if (!FP.empty(hasVideoSet) && !FP.empty(noVideoSet)) {
                YLKLog.i(TAG, "filterLiveInfo viewerInfo: " + hasVideoSet);
                return new HashSet<LiveInfo>(hasVideoSet);
            }
        }
        return liveInfoSet;
    }

    private static boolean checkFieldRegion(StreamCliMsg2C.FieldRegion fieldRegion, Object object) {
        Object[] values;
        if (fieldRegion == null || object == null) {
            return true;
        }
        boolean isValid = true;
        if (fieldRegion.vtype == 0 && fieldRegion.integer != null) {
            if (fieldRegion.integer.discrete != null && !FP.empty((int[])fieldRegion.integer.discrete.values)) {
                values = fieldRegion.integer.discrete.values;
                isValid = Arrays.asList(ArrayUtils.toObject((int[])values)).contains(object);
            } else if (fieldRegion.integer.range != null) {
                int value = (Integer)object;
                int minValue = fieldRegion.integer.range.minValue;
                int maxValue = fieldRegion.integer.range.maxValue;
                boolean bl = isValid = minValue <= value && value <= maxValue;
            }
        }
        if (fieldRegion.vtype == 1 && fieldRegion.str != null && !FP.empty((Object[])fieldRegion.str.values)) {
            values = fieldRegion.str.values;
            isValid = Arrays.asList(values).contains(object);
        }
        return isValid;
    }

    private static boolean checkObjectRegion(StreamCliMsg2C.ObjectRegion objectRegion, String json) {
        if (objectRegion == null || FP.empty(objectRegion.fields) || FP.empty((CharSequence)json)) {
            return true;
        }
        boolean isValid = true;
        try {
            JSONObject jsonObject = new JSONObject(json);
            Set<Map.Entry<String, StreamCliMsg2C.FieldRegion>> entrySet = objectRegion.fields.entrySet();
            for (Map.Entry<String, StreamCliMsg2C.FieldRegion> entry : entrySet) {
                String key = entry.getKey();
                StreamCliMsg2C.FieldRegion value = entry.getValue();
                if (!jsonObject.has(key) || jsonObject.get(key) == null) continue;
                switch (value.vtype) {
                    case 0: {
                        JSONArray intArray = jsonObject.optJSONArray(key);
                        if (intArray != null) {
                            int valueStr;
                            for (int i = 0; i < intArray.length() && !(isValid = LiveInfoFactoryV2.checkFieldRegion(value, valueStr = intArray.optInt(i))); ++i) {
                            }
                            break;
                        }
                        isValid = LiveInfoFactoryV2.checkFieldRegion(value, jsonObject.optInt(key));
                        break;
                    }
                    case 1: {
                        JSONArray stringArray = jsonObject.optJSONArray(key);
                        if (stringArray != null) {
                            String valueStr;
                            for (int i = 0; i < stringArray.length() && !(isValid = LiveInfoFactoryV2.checkFieldRegion(value, valueStr = stringArray.optString(i))); ++i) {
                            }
                            break;
                        }
                        isValid = LiveInfoFactoryV2.checkFieldRegion(value, jsonObject.optString(key));
                        break;
                    }
                    case 2: {
                        JSONObject attr = jsonObject.getJSONObject(key);
                        isValid = LiveInfoFactoryV2.checkObjectRegion(value.attr, attr != null ? attr.toString() : null);
                        break;
                    }
                }
                if (isValid) continue;
                break;
            }
        }
        catch (Throwable e) {
            YLKLog.e(TAG, "checkObjectRegion Throwable:" + e);
        }
        return isValid;
    }

    private static boolean shouldAccept(StreamCliMsg2C.StreamVisibilityRule rule, StreamCliMsg2C.StreamInfo streamInfo) {
        boolean isValid = true;
        isValid = isValid && LiveInfoFactoryV2.checkFieldRegion(rule.type, streamInfo.type);
        isValid = isValid && LiveInfoFactoryV2.checkFieldRegion(rule.mix, streamInfo.mix);
        isValid = isValid && LiveInfoFactoryV2.checkFieldRegion(rule.gear, streamInfo.gear);
        isValid = isValid && LiveInfoFactoryV2.checkFieldRegion(rule.appid, streamInfo.appid);
        isValid = isValid && LiveInfoFactoryV2.checkObjectRegion(rule.json, streamInfo.json);
        return isValid;
    }

    private static Map<Integer, List<StreamInfo>> parseViewerStreamInfos(StreamCliMsg2C.StreamInfo[] streamArray, AcceptanceRulesV2 rules) {
        HashMap audios = new HashMap();
        HashMap videos = new HashMap();
        for (StreamCliMsg2C.StreamInfo streamInfo : streamArray) {
            Tuple<Long, VideoInfo> videoTuple;
            if (streamInfo.gear == 100 || streamInfo.mix != 3) continue;
            boolean isValid = false;
            if (!FP.empty((Object[])rules.visibilityRules)) {
                StreamCliMsg2C.StreamVisibilityRule rule;
                StreamCliMsg2C.StreamVisibilityRule[] streamVisibilityRuleArray = rules.visibilityRules;
                int n = streamVisibilityRuleArray.length;
                for (int i = 0; i < n && !(isValid = LiveInfoFactoryV2.shouldAccept(rule = streamVisibilityRuleArray[i], streamInfo)); ++i) {
                }
            } else {
                isValid = true;
            }
            if (!isValid) continue;
            int streamType = streamInfo.type;
            if (streamType == 1) {
                Tuple<Long, AudioInfo> audioTuple = LiveInfoFactoryV2.parseAudioInfo(streamInfo, true);
                audios.put(((AudioInfo)audioTuple.b).pair, audioTuple.b);
                continue;
            }
            if (streamType != 2 || (videoTuple = LiveInfoFactoryV2.parseVideoInfo(streamInfo, true)) == null) continue;
            ArrayList videoInfoList = (ArrayList)videos.get(((VideoInfo)videoTuple.b).pair);
            if (videoInfoList == null) {
                videoInfoList = new ArrayList();
                videos.put(((VideoInfo)videoTuple.b).pair, videoInfoList);
            }
            videoInfoList.add(videoTuple.b);
        }
        HashSet allPairs = new HashSet();
        allPairs.addAll(videos.keySet());
        allPairs.addAll(audios.keySet());
        HashMap<Integer, List<StreamInfo>> sourceToStream = new HashMap<Integer, List<StreamInfo>>();
        for (Integer pair : allPairs) {
            AudioInfo audio = (AudioInfo)audios.get(pair);
            List videoInfoList = (List)videos.get(pair);
            Assert.assertFalse((audio == null && FP.empty((Collection)videoInfoList) ? 1 : 0) != 0);
            VideoInfo video = (VideoInfo)FP.first((List)videoInfoList);
            int source = video != null ? video.source : audio.source;
            ArrayList<StreamInfo> streams = (ArrayList<StreamInfo>)sourceToStream.get(source);
            if (streams == null) {
                streams = new ArrayList<StreamInfo>();
            }
            if (!FP.empty((Collection)videoInfoList)) {
                for (VideoInfo videoInfo : videoInfoList) {
                    streams.add(new StreamInfo(videoInfo, audio, 2));
                }
            } else {
                streams.add(new StreamInfo(null, audio, 2));
            }
            sourceToStream.put(source, streams);
        }
        return sourceToStream;
    }

    private static Map<String, Object> makeAnchorBundle(StreamCliMsg2C.StreamInfo[] streamArray, AcceptanceRulesV2 rules) {
        Map<Long, Map<String, Object>> anchorStreams = LiveInfoFactoryV2.parseAnchorStreamInfos(streamArray);
        Map<Long, List<VideoInfo>> transcodedVideos = LiveInfoFactoryV2.parseTranscodedVideoInfos(streamArray);
        final Set<TransConfig> transConfigs = LiveInfoFactoryV2.parseAnchorStreamCompat(streamArray);
        YLKLog.i(TAG, "makeAnchorBundle anchorArraySize: [" + FP.size(anchorStreams) + "]");
        YLKLog.i(TAG, "makeAnchorBundle anchorInfo: " + anchorStreams);
        YLKLog.i(TAG, "makeAnchorBundle transInfo: " + transcodedVideos);
        final ArrayList<LiveInfo> results = new ArrayList<LiveInfo>();
        for (Long uid : anchorStreams.keySet()) {
            if (uid == rules.selfUID) {
                YLKLog.i(TAG, "makeAnchorBundle filter same UID = [" + rules.selfUID + "]");
                continue;
            }
            Map<String, Object> anchorEntry = anchorStreams.get(uid);
            Integer micNo = (Integer)anchorEntry.get(RetMicNum);
            StreamInfo originStream = (StreamInfo)anchorEntry.get(RetStreamInfo);
            Integer source = (Integer)anchorEntry.get(RetSource);
            AudioInfo originAudio = originStream.audio;
            ArrayList<StreamInfo> itsStreams = new ArrayList<StreamInfo>();
            itsStreams.add(originStream);
            List<VideoInfo> shiftedVideos = transcodedVideos.get(uid);
            if (shiftedVideos != null) {
                for (VideoInfo videoInfo : shiftedVideos) {
                    itsStreams.add(new StreamInfo(videoInfo, originAudio, 1));
                }
            }
            results.add(new LiveInfo(uid, micNo, source, itsStreams, false));
        }
        return new HashMap<String, Object>(){
            {
                this.put(LiveInfoFactoryV2.RetAnchorStream, results);
                this.put(LiveInfoFactoryV2.RetTransConfig, transConfigs);
            }
        };
    }

    private static Set<TransConfig> parseAnchorStreamCompat(StreamCliMsg2C.StreamInfo[] streamArray) {
        HashSet<TransConfig> transConfigs = new HashSet<TransConfig>();
        for (StreamCliMsg2C.StreamInfo streamInfo : streamArray) {
            JsonObject compatObject;
            JsonElement transConfig;
            JsonObject attrObject;
            JsonElement compatElement;
            JsonElement attrElement;
            int streamType;
            if (streamInfo.mix != 1 && streamInfo.mix != 2 || (streamType = streamInfo.type) != 2) continue;
            long uid = Uint32.toUInt(streamInfo.uid).longValue();
            if (FP.empty((CharSequence)streamInfo.json) || (attrElement = new JsonParser().parse(streamInfo.json)) == null || (compatElement = (attrObject = attrElement.getAsJsonObject()).get("compat")) == null || compatElement.isJsonNull() || (transConfig = (compatObject = compatElement.getAsJsonObject()).get("trans_config")) == null) continue;
            for (JsonElement configElement : transConfig.getAsJsonArray()) {
                JsonElement channelIdElement = configElement.getAsJsonObject().get("channel_id");
                JsonElement metaDataElement = configElement.getAsJsonObject().get("meta_data");
                if (metaDataElement == null || metaDataElement.isJsonNull()) continue;
                MetaData metaDataKv = new MetaData();
                for (Map.Entry entry : metaDataElement.getAsJsonObject().entrySet()) {
                    String key = (String)entry.getKey();
                    JsonElement valueElement = (JsonElement)entry.getValue();
                    int realValue = 0;
                    realValue = valueElement.getAsJsonPrimitive().isBoolean() ? (valueElement.getAsBoolean() ? 1 : 0) : valueElement.getAsInt();
                    metaDataKv.put(Short.valueOf(key), realValue);
                }
                transConfigs.add(new TransConfig(uid, channelIdElement.getAsInt(), metaDataKv));
            }
        }
        return transConfigs;
    }

    private static Map<Long, Map<String, Object>> parseAnchorStreamInfos(StreamCliMsg2C.StreamInfo[] streamArray) {
        HashMap audioStreams = new HashMap();
        HashMap videoStreams = new HashMap();
        HashMap<Long, Integer> vMicNumbers = new HashMap<Long, Integer>();
        HashMap<Long, Integer> aMicNumbers = new HashMap<Long, Integer>();
        for (StreamCliMsg2C.StreamInfo streamInfo : streamArray) {
            Tuple<Long, Cloneable> tuple;
            if (streamInfo.mix != 1 && streamInfo.mix != 2) continue;
            int streamType = streamInfo.type;
            long uid = Uint32.toUInt(streamInfo.uid).longValue();
            int mic = streamInfo.micNo;
            if (streamType == 1) {
                aMicNumbers.put(uid, mic);
                tuple = LiveInfoFactoryV2.parseAudioInfo(streamInfo, false);
                if (tuple == null) continue;
                audioStreams.put(tuple.a, tuple.b);
                continue;
            }
            if (streamType != 2) continue;
            vMicNumbers.put(uid, mic);
            tuple = LiveInfoFactoryV2.parseVideoInfo(streamInfo, false);
            if (tuple == null) continue;
            videoStreams.put(tuple.a, tuple.b);
        }
        HashSet allUIDs = new HashSet();
        allUIDs.addAll(videoStreams.keySet());
        allUIDs.addAll(audioStreams.keySet());
        HashMap<Long, Map<String, Object>> streams = new HashMap<Long, Map<String, Object>>();
        for (Long uid : allUIDs) {
            final AudioInfo audio = (AudioInfo)audioStreams.get(uid);
            final VideoInfo video = (VideoInfo)videoStreams.get(uid);
            final Integer micNo = vMicNumbers.get(uid) == null ? (Integer)aMicNumbers.get(uid) : (Integer)vMicNumbers.get(uid);
            Assert.assertFalse((audio == null && video == null ? 1 : 0) != 0);
            streams.put(uid, (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put(LiveInfoFactoryV2.RetSource, video != null ? video.source : audio.source);
                    this.put(LiveInfoFactoryV2.RetMicNum, micNo == null ? -1 : micNo);
                    this.put(LiveInfoFactoryV2.RetStreamInfo, new StreamInfo(video, audio, 0));
                }
            });
        }
        return streams;
    }

    private static Map<Long, List<VideoInfo>> parseTranscodedVideoInfos(StreamCliMsg2C.StreamInfo[] streamArray) {
        HashMap<Long, List<VideoInfo>> videoInfos = new HashMap<Long, List<VideoInfo>>();
        for (StreamCliMsg2C.StreamInfo streamInfo : streamArray) {
            Tuple<Long, VideoInfo> tuple;
            int streamType;
            if (streamInfo.mix != 5 || (streamType = streamInfo.type) != 2 || (tuple = LiveInfoFactoryV2.parseVideoInfo(streamInfo, false)) == null) continue;
            ArrayList list = (ArrayList)videoInfos.get(tuple.a);
            if (list == null) {
                list = new ArrayList();
                videoInfos.put((Long)tuple.a, list);
            }
            list.add(tuple.b);
        }
        return videoInfos;
    }

    private static Tuple<Long, VideoInfo> parseVideoInfo(StreamCliMsg2C.StreamInfo streamInfo, boolean isMix) {
        if (streamInfo == null) {
            YLKLog.e(TAG, "\u670d\u52a1\u5668\u8fd4\u56de\u4e86\u9519\u8bef\u7684\u89c6\u9891\u6d41\u4fe1\u606f\uff08\u4e3b\u4fe1\u606f\u9519\u8bef\uff09: " + (Object)((Object)streamInfo));
            return null;
        }
        if (FP.empty((CharSequence)streamInfo.json)) {
            YLKLog.e(TAG, "\u670d\u52a1\u5668\u89c6\u9891\u6570\u636e\u4e3anull");
            return null;
        }
        JsonElement attrElement = new JsonParser().parse(streamInfo.json);
        if (!JsonUtils.validateJsonObject(attrElement, requisiteAttrElements)) {
            YLKLog.e(TAG, "\u670d\u52a1\u5668\u8fd4\u56de\u4e86\u9519\u8bef\u7684\u89c6\u9891\u6d41\u4fe1\u606f\uff08\u5c5e\u6027\u4fe1\u606f\u9519\u8bef\uff09: " + streamInfo.json);
            return null;
        }
        Integer appId = streamInfo.appid;
        String name = streamInfo.streamName;
        long uid = Uint32.toUInt(streamInfo.uid).longValue();
        Integer pair = streamInfo.mixGroupNo > 0 ? streamInfo.mixGroupNo : streamInfo.audioVideoGroup;
        JsonObject attrObject = attrElement.getAsJsonObject();
        int rate = attrObject.get("rate").getAsInt();
        int encode = attrObject.get("encoderType").getAsInt();
        int width = attrObject.get("width").getAsInt();
        int height = attrObject.get("height").getAsInt();
        int fps = attrObject.get("fps").getAsInt();
        JsonElement sourceElement = attrObject.get("source");
        int source = sourceElement != null ? sourceElement.getAsInt() : 0;
        boolean isMs = sourceElement != null;
        HashSet<String> tags = new HashSet<String>();
        JsonElement tagElement = attrObject.get("tag");
        if (tagElement != null) {
            JsonArray tagArray = tagElement.getAsJsonArray();
            for (JsonElement element : tagArray) {
                tags.add(element.getAsString());
            }
        } else {
            tags.add("mob");
        }
        JsonElement buzObject = attrObject.get("businessInfo");
        BuzInfo buzInfo = null;
        if (buzObject != null) {
            List buzKey = FP.toList((Object[])new String[]{"lianmaiType", "seat"});
            JsonElement lianmaiElement = buzObject.getAsJsonObject().get("lianmaiType");
            JsonElement seatElement = buzObject.getAsJsonObject().get("seat");
            int lianmaiType = lianmaiElement != null ? lianmaiElement.getAsInt() : -1;
            int seat = seatElement != null ? seatElement.getAsInt() : -1;
            HashMap<String, String> extend = new HashMap<String, String>();
            Set exKeys = buzObject.getAsJsonObject().keySet();
            for (String exKey : exKeys) {
                JsonElement exKeyValue;
                if (buzKey.contains(exKey) || (exKeyValue = buzObject.getAsJsonObject().get(exKey)) == null) continue;
                extend.put(exKey, exKeyValue.toString());
            }
            buzInfo = new BuzInfo(lianmaiType, seat, extend);
        } else {
            buzInfo = new BuzInfo(-1, -1);
        }
        JsonElement gearObject = attrObject.get("gear_info");
        VideoGearInfo videoGearInfo = null;
        if (gearObject != null) {
            int seq;
            JsonElement gearElement = gearObject.getAsJsonObject().get("gear");
            JsonElement nameElement = gearObject.getAsJsonObject().get("name");
            JsonElement seqElement = gearObject.getAsJsonObject().get("seq");
            int gear = gearElement != null ? gearElement.getAsInt() : -1;
            String gearName = nameElement != null ? nameElement.getAsString() : "";
            int n = seq = seqElement != null ? seqElement.getAsInt() : -1;
            if (gear != -1 || !FP.empty((CharSequence)gearName) || seq != -1) {
                videoGearInfo = new VideoGearInfo(gear, gearName, seq, rate);
            }
        } else {
            VideoQuality quality = VideoQualityCalc.eval(rate, encode != 100 ? 220 : 200);
            videoGearInfo = new VideoGearInfo(quality.ordinal() + 1, VideoQuality.description(quality), (quality.ordinal() + 1) * 100, rate);
            YLKLog.i(TAG, "parseVideoInfo fake video gear=" + videoGearInfo);
        }
        MixVideoLayout mixVideoLayout = attrObject.get("layout") != null ? LiveInfoFactoryV2.parseLayoutParams(attrObject) : LiveInfoFactoryV2.createLayoutParams(uid);
        Map<Integer, Integer> liveStreamInfoCfg = LiveInfoFactoryV2.parseLiveStreamInfoConfig(streamInfo, pair, uid, 2);
        return new Tuple<Long, VideoInfo>(uid, new VideoInfo(appId, name, source, isMs, width, height, rate, encode, fps, pair, buzInfo, mixVideoLayout, isMix, videoGearInfo, liveStreamInfoCfg, tags));
    }

    private static Tuple<Long, AudioInfo> parseAudioInfo(StreamCliMsg2C.StreamInfo streamInfo, boolean isMix) {
        JsonObject attrObj;
        Integer appId = streamInfo.appid;
        String name = streamInfo.streamName;
        long uid = Uint32.toUInt(streamInfo.uid).longValue();
        Integer pair = streamInfo.mixGroupNo > 0 ? streamInfo.mixGroupNo : streamInfo.audioVideoGroup;
        Map<Integer, Integer> liveStreamInfoCfg = LiveInfoFactoryV2.parseLiveStreamInfoConfig(streamInfo, pair, uid, 1);
        int source = 0;
        boolean isMs = false;
        String attr = streamInfo.json;
        if (!FP.empty((CharSequence)attr) && (attrObj = new JsonParser().parse(attr).getAsJsonObject()) != null) {
            JsonElement sourceElement = attrObj.get("source");
            source = sourceElement != null ? sourceElement.getAsInt() : 0;
            isMs = sourceElement != null;
        }
        return new Tuple<Long, AudioInfo>(uid, new AudioInfo(appId, name, source, isMs, pair, isMix, liveStreamInfoCfg));
    }

    private static Map<Integer, Integer> parseLiveStreamInfoConfig(StreamCliMsg2C.StreamInfo streamInfo, final Integer pair, final long uid, final int streamType) {
        HashMap<Integer, Integer> configs = new HashMap<Integer, Integer>(){
            {
                this.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_STREAM_TYPE, LiveInfoFactoryV2.mediaTypeFromStreamType(streamType));
                this.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_SPEAKER_UID, (int)uid);
                this.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_STREAM_A_V_PAIR_ID, pair);
                this.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_ENABLE_FAST_ACCESS, 1);
            }
        };
        String attr = streamInfo.json;
        if (FP.empty((CharSequence)attr)) {
            return configs;
        }
        JsonObject attrObject = new JsonParser().parse(attr).getAsJsonObject();
        if (attrObject != null) {
            Set<String> keySet = conversionRules.keySet();
            for (String key : keySet) {
                if (!attrObject.has(key)) continue;
                Integer configKey = conversionRules.get(key);
                configs.put(configKey, attrObject.get(key).getAsInt());
            }
        }
        return configs;
    }

    private static List<GroupInfo> extractLiveGroupInfo(StreamCliMsg2C.StreamInfo[] streamArray) {
        ArrayList<GroupInfo> groups = new ArrayList<GroupInfo>();
        for (StreamCliMsg2C.StreamInfo streamInfo : streamArray) {
            int streamType = streamInfo.type;
            if (streamType != 3 && streamType != 5) continue;
            Integer appId = streamInfo.appid;
            String name = streamInfo.streamGroup;
            groups.add(new GroupInfo(appId, name, streamType));
        }
        return groups;
    }

    private static MixVideoLayout parseLayoutParams(JsonObject attrObject) {
        JsonElement layoutArrayElement = attrObject.get("layout");
        ArrayList<MixVideoLayout.Params> layoutParams = new ArrayList<MixVideoLayout.Params>();
        for (JsonElement layoutElement : layoutArrayElement.getAsJsonArray()) {
            JsonObject layoutObj = layoutElement.getAsJsonObject();
            int w = layoutObj.get("w").getAsInt();
            int h = layoutObj.get("h").getAsInt();
            int x = layoutObj.get("x").getAsInt();
            int y = layoutObj.get("y").getAsInt();
            int mic = layoutObj.get("mic").getAsInt();
            long uid = layoutObj.get("uid").getAsLong();
            layoutParams.add(new MixVideoLayout.Params(h, w, x, y, mic, uid));
        }
        if (FP.size(layoutParams) > 1) {
            Collections.sort(layoutParams, new Comparator<MixVideoLayout.Params>(){

                @Override
                public int compare(MixVideoLayout.Params o1, MixVideoLayout.Params o2) {
                    return o1.mic - o2.mic;
                }
            });
        }
        return new MixVideoLayout(MixVideoLayout.Style.NA, layoutParams);
    }

    private static MixVideoLayout createLayoutParams(final long uid) {
        ArrayList<MixVideoLayout.Params> layoutParams = new ArrayList<MixVideoLayout.Params>(){
            {
                this.add(new MixVideoLayout.Params(0, 0, 0, 0, 0, uid));
            }
        };
        return new MixVideoLayout(MixVideoLayout.Style.NA, (List<MixVideoLayout.Params>)layoutParams);
    }

    private static int mediaTypeFromStreamType(int streamType) {
        switch (streamType) {
            case 1: {
                return MediaVideoMsg.LiveStreamType.STREAM_TYPE_AUDIO;
            }
            case 2: {
                return MediaVideoMsg.LiveStreamType.STREAM_TYPE_VIDEO;
            }
        }
        return -1;
    }
}

