/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import com.duowan.mobile.mediaproxy.YVideoViewLayout;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.yylivekit.audience.MediaView;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.VideoScale;
import com.yy.yylivekit.observables.ObservableValue;
import com.yy.yylivekit.utils.Tuple;

public class MediaViewProxy {
    private static final String TAG = "MediaViewProxy";
    private ObservableValue<VideoScale> videoScale = new ObservableValue<VideoScale>(VideoScale.ClipToBounds);
    private ObservableValue<Boolean> isMediaOverlay = new ObservableValue<Boolean>(false);
    private ObservableValue<Boolean> isMediaOnTop = new ObservableValue<Boolean>(false);
    private ObservableValue<Tuple<Long, Integer>> st = new ObservableValue<Object>(null);
    private ObservableValue<Boolean> isVrStream = new ObservableValue<Boolean>(false);
    private ObservableValue<Integer> visibility = new ObservableValue<Integer>(0);
    private ObservableValue<IVideoInfoCallback> callback = new ObservableValue<Object>(null);
    private MediaView mediaView;
    private LinkStreamListener linkStreamListener;
    private final LinkStreamListener DEFAULT_LINKSTREAM_CALLBACK = new LinkStreamListener(){

        @Override
        public void onStart() {
        }

        @Override
        public void onEnd() {
        }
    };

    MediaViewProxy() {
        this.setupObserverValue();
        this.setupStObserverValue();
    }

    void resetStValue(long streamId) {
        YLKLog.i(TAG, "resetStValue called with: streamId = [" + streamId + "],st = [" + this.st + "]");
        if (this.st != null && this.st.get() != null && (Long)this.st.get().a == streamId) {
            YLKLog.i(TAG, "resetStValue ReNew st");
            this.st.removeObserver(this);
            this.st = new ObservableValue<Tuple<Long, Integer>>(new Tuple<Long, Integer>(0L, 0));
            this.setupStObserverValue();
            if (this.mediaView != null) {
                this.mediaView.unlink();
            }
        }
    }

    View createMediaView(Context context) {
        YLKLog.i(TAG, "MediaViewProxy createMediaView");
        if (this.mediaView == null) {
            this.mediaView = new MediaView(context);
            if (this.st.get() != null && !this.mediaView.isLinkState() && (Integer)this.st.get().b != -1) {
                this.mediaView.link((Long)this.st.get().a, (Integer)this.st.get().b);
                this.reloadProperty();
            }
        }
        return this.mediaView;
    }

    void destoryMediaView() {
        YLKLog.i(TAG, "MediaViewProxy destoryMediaView");
        if (this.mediaView != null) {
            this.mediaView.unlink();
        }
        this.mediaView = null;
    }

    public void setVideoContainVisibility(int visibility) {
        YLKLog.i(TAG, "MediaViewProxy setVideoContainVisibility:" + visibility);
        this.visibility.set(visibility);
    }

    public void setVrStream(boolean vrStream) {
        YLKLog.i(TAG, "MediaViewProxy setVrStream:" + vrStream);
        this.isVrStream.set(vrStream);
    }

    public void setZOrderOnTop(boolean onTop) {
        YLKLog.i(TAG, "MediaViewProxy setZOrderOnTop:" + onTop);
        this.isMediaOnTop.set(onTop);
    }

    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        YLKLog.i(TAG, "MediaViewProxy setZOrderMediaOverlay:" + isMediaOverlay);
        this.isMediaOverlay.set(isMediaOverlay);
    }

    public void setScale(VideoScale videoScale) {
        YLKLog.i(TAG, "MediaViewProxy setScale:" + (Object)((Object)videoScale));
        this.videoScale.set(videoScale);
    }

    public void setVideoInfoCallback(IVideoInfoCallback callback) {
        YLKLog.i(TAG, "MediaViewProxy setVideoInfoCallback:" + callback);
        this.callback.set(callback);
    }

    void setStObject(Tuple st) {
        YLKLog.i(TAG, "MediaViewProxy setStObject:" + st);
        this.st.set(st);
    }

    boolean isLinkState() {
        if (this.mediaView != null) {
            return this.mediaView.isLinkState();
        }
        return false;
    }

    public View getVideoView() {
        return this.mediaView;
    }

    public Bitmap getVideoScreenShot() {
        return this.mediaView == null ? null : this.mediaView.getVideoScreenShot();
    }

    public YVideoViewLayout getVideoLayout() {
        return this.mediaView == null ? null : this.mediaView.getVideoLayout();
    }

    public long getStreamId() {
        return this.mediaView == null ? 0L : this.mediaView.streamId;
    }

    public void setLinkStreamListener(LinkStreamListener linkStreamListener) {
        this.linkStreamListener = linkStreamListener;
    }

    LinkStreamListener getLinkStreamListener() {
        if (this.linkStreamListener == null) {
            this.linkStreamListener = this.DEFAULT_LINKSTREAM_CALLBACK;
        }
        return this.linkStreamListener;
    }

    boolean isSame(long streamId) {
        return this.st.get() != null ? (Long)this.st.get().a == streamId : false;
    }

    void reloadProperty() {
        if (this.mediaView != null) {
            YLKLog.i(TAG, "MediaViewProxy reloadProperty, isMediaOverlay:" + this.isMediaOverlay.get() + ",isVrStream:" + this.isVrStream.get() + ",isMediaOnTop:" + this.isMediaOnTop.get() + ",visibility:" + this.visibility.get());
            this.mediaView.setZOrderOnTop(this.isMediaOnTop.get());
            this.mediaView.setZOrderMediaOverlay(this.isMediaOverlay.get());
            this.mediaView.setVrStream(this.isVrStream.get());
            this.mediaView.setScale(this.videoScale.get());
            this.mediaView.setVideoInfoCallback(this.callback.get());
            this.mediaView.getVideoLayout().setVisibility(this.visibility.get().intValue());
        }
    }

    void setupObserverValue() {
        this.callback.addObserver(this, false, new ObservableValue.Observer<IVideoInfoCallback>(){

            @Override
            public void updated(boolean isInitial, IVideoInfoCallback from, IVideoInfoCallback to) {
                if (MediaViewProxy.this.mediaView != null) {
                    MediaViewProxy.this.mediaView.setVideoInfoCallback(to);
                }
            }
        });
        this.videoScale.addObserver(this, false, new ObservableValue.Observer<VideoScale>(){

            @Override
            public void updated(boolean isInitial, VideoScale from, VideoScale to) {
                if (MediaViewProxy.this.mediaView != null) {
                    MediaViewProxy.this.mediaView.setScale(to);
                }
            }
        });
        this.isMediaOnTop.addObserver(this, false, new ObservableValue.Observer<Boolean>(){

            @Override
            public void updated(boolean isInitial, Boolean from, Boolean to) {
                if (MediaViewProxy.this.mediaView != null) {
                    MediaViewProxy.this.mediaView.setZOrderOnTop(to);
                }
            }
        });
        this.isMediaOverlay.addObserver(this, false, new ObservableValue.Observer<Boolean>(){

            @Override
            public void updated(boolean isInitial, Boolean from, Boolean to) {
                if (MediaViewProxy.this.mediaView != null) {
                    MediaViewProxy.this.mediaView.setZOrderMediaOverlay(to);
                }
            }
        });
        this.isVrStream.addObserver(this, false, new ObservableValue.Observer<Boolean>(){

            @Override
            public void updated(boolean isInitial, Boolean from, Boolean to) {
                if (MediaViewProxy.this.mediaView != null) {
                    MediaViewProxy.this.mediaView.setVrStream(to);
                }
            }
        });
        this.visibility.addObserver(this, false, new ObservableValue.Observer<Integer>(){

            @Override
            public void updated(boolean isInitial, Integer from, Integer to) {
                if (MediaViewProxy.this.mediaView != null) {
                    MediaViewProxy.this.mediaView.getVideoLayout().setVisibility(to.intValue());
                }
            }
        });
    }

    void setupStObserverValue() {
        this.st.addObserver(this, false, new ObservableValue.Observer<Tuple<Long, Integer>>(){

            @Override
            public void updated(boolean isInitial, Tuple<Long, Integer> from, Tuple<Long, Integer> to) {
                if (to != null) {
                    Tuple<Long, Integer> st = to;
                    if (MediaViewProxy.this.mediaView != null && !MediaViewProxy.this.mediaView.isLinkState()) {
                        MediaViewProxy.this.getLinkStreamListener().onStart();
                        MediaViewProxy.this.mediaView.link((Long)st.a, (Integer)st.b);
                        MediaViewProxy.this.getLinkStreamListener().onEnd();
                        MediaViewProxy.this.reloadProperty();
                    }
                } else if (MediaViewProxy.this.mediaView != null) {
                    MediaViewProxy.this.mediaView.unlink();
                }
            }
        });
    }

    void saveStreamInfo(long sid, int decodeType) {
        this.st.set(new Tuple<Long, Integer>(sid, decodeType));
    }

    public static interface LinkStreamListener {
        public void onStart();

        public void onEnd();
    }
}

