/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.RelativeLayout;
import com.duowan.mobile.mediaproxy.YVideoViewLayout;
import com.yy.IMediaVideo;
import com.yy.IMediaVideoSDK;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.VideoScale;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

class MediaView
extends RelativeLayout {
    private static final String TAG = "MediaView";
    protected boolean isMediaOnTop = false;
    protected boolean isMediaOverLay = false;
    protected final YVideoViewLayout videoLayout;
    protected YSpVideoView videoView;
    protected long streamId = 0L;
    protected AtomicBoolean isLinkState;
    protected final IMediaVideo mediaSDK = IMediaVideoSDK.instance().getMedia();

    public MediaView(Context context) {
        super(context);
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.videoLayout = new YVideoViewLayout(context);
        this.addView((View)this.videoLayout, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.isLinkState = new AtomicBoolean(false);
        this.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                YLKLog.i(MediaView.TAG, "MediaView onViewAttachedToWindow");
            }

            public void onViewDetachedFromWindow(View v) {
                YLKLog.i(MediaView.TAG, "MediaView onViewDetachedFromWindow");
            }
        });
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                YLKLog.i(MediaView.TAG, "MediaView onGlobalLayout visiable=" + MediaView.this.getVisibility());
                if (Build.VERSION.SDK_INT < 16) {
                    MediaView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    MediaView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
    }

    public boolean isLinkState() {
        return this.isLinkState.get();
    }

    public void setScale(VideoScale videoScale) {
        YLKLog.i(TAG, "MediaView setScale:" + (Object)((Object)videoScale));
        HashMap<VideoScale, VideoConstant.ScaleMode> scaleModeMap = new HashMap<VideoScale, VideoConstant.ScaleMode>(){
            {
                this.put(VideoScale.FillParent, VideoConstant.ScaleMode.FillParent);
                this.put(VideoScale.AspectFit, VideoConstant.ScaleMode.AspectFit);
                this.put(VideoScale.ClipToBounds, VideoConstant.ScaleMode.ClipToBounds);
            }
        };
        if (this.videoView != null) {
            this.videoView.setScaleMode((VideoConstant.ScaleMode)scaleModeMap.get((Object)videoScale));
        }
    }

    public Bitmap getVideoScreenShot() {
        if (this.videoView == null) {
            return null;
        }
        return this.videoView.getVideoScreenshot();
    }

    public void setVrStream(boolean vrStream) {
        YLKLog.i(TAG, "MediaView setVrStream:" + vrStream);
        if (this.videoView != null) {
            this.videoView.setVrStream(vrStream);
        }
    }

    public YVideoViewLayout getVideoLayout() {
        return this.videoLayout;
    }

    public void link(long streamId, int decodeType) {
        YLKLog.i(TAG, "MediaView -link- streamId:" + streamId + ",decodeType:" + decodeType);
        if (streamId == 0L) {
            return;
        }
        this.isLinkState.getAndSet(true);
        this.videoView = decodeType == -1 ? this.videoLayout.clearAndCreateNewView() : this.videoLayout.clearAndCreateNewView(decodeType);
        this.mediaSDK.addSpVideoView(this.videoView);
        YLKLog.i(TAG, "MediaView -link- streamId finish:" + streamId + ",decodeType:" + decodeType);
        this.streamId = streamId;
        this.videoView.linkToStream(0L, streamId);
        this.setZOrderMediaOverlay(this.isMediaOverLay);
        this.setZOrderOnTop(this.isMediaOnTop);
    }

    public void unlink() {
        if (this.streamId == 0L) {
            YLKLog.e(TAG, "MediaView =unlink= need streamId>" + this.streamId);
            return;
        }
        if (this.videoView == null) {
            YLKLog.e(TAG, "MediaView =unlink= need videoView not null");
            return;
        }
        YLKLog.i(TAG, "MediaView =unlink= streamId:" + this.streamId + ", view:" + this.videoView + ",removeAllView");
        this.videoView.unLinkFromStream(0L, this.streamId);
        this.mediaSDK.removeSpVideoView(this.videoView);
        this.videoView.release();
        this.videoView = null;
        this.videoLayout.removeAllVideoViews();
        this.streamId = 0L;
        this.isLinkState.getAndSet(false);
    }

    public void setVideoInfoCallback(IVideoInfoCallback callback) {
        if (this.videoView != null) {
            this.videoView.setVideoInfoCallback(callback);
        }
    }

    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        this.isMediaOverLay = isMediaOverlay;
        if (this.videoView != null && this.videoView instanceof SurfaceView) {
            YLKLog.i(TAG, "MediaView setZOrderMediaOverlay:" + isMediaOverlay);
            ((SurfaceView)this.videoView).setZOrderMediaOverlay(isMediaOverlay);
        } else {
            YLKLog.e(TAG, "MediaView setZOrderMediaOverlay failed:" + isMediaOverlay);
        }
    }

    public void setZOrderOnTop(boolean onTop) {
        this.isMediaOnTop = onTop;
        if (this.videoView != null && this.videoView instanceof SurfaceView) {
            YLKLog.i(TAG, "MediaView setZOrderOnTop:" + onTop);
            ((SurfaceView)this.videoView).setZOrderOnTop(onTop);
        } else {
            YLKLog.e(TAG, "MediaView setZOrderOnTop failed:" + onTop);
        }
    }
}

