/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.view.View;
import com.duowan.mobile.mediaproxy.YVideoViewLayout;
import com.medialib.video.MediaVideoMsg;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.yylivekit.Env;
import com.yy.yylivekit.ILivePlayer;
import com.yy.yylivekit.audience.AbsLivePlayer;
import com.yy.yylivekit.audience.MediaViewProxy;
import com.yy.yylivekit.audience.PlayerConfig;
import com.yy.yylivekit.audience.StreamInfoChangeHandler;
import com.yy.yylivekit.audience.StreamLineHandler;
import com.yy.yylivekit.audience.SubscribHandler;
import com.yy.yylivekit.audience.handle.HandleMsg;
import com.yy.yylivekit.audience.handle.Option;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.AudioInfo;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.LiveKitMsg;
import com.yy.yylivekit.model.StreamInfo;
import com.yy.yylivekit.model.VideoGearInfo;
import com.yy.yylivekit.model.VideoInfo;
import com.yy.yylivekit.observables.ObservableValue;
import com.yy.yylivekit.utils.CollectionUtils;
import com.yy.yylivekit.utils.Tuple;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Assert;

public class LivePlayer
extends AbsLivePlayer
implements ILivePlayer {
    protected static final String TAG = "LivePlayer";
    private final boolean isMix;
    private final boolean isMultiSource;
    private boolean isStarted = false;
    private ObservableValue<ILivePlayer.PlayState> playState;
    private Boolean enableAudio;
    private Boolean enableVideo;
    private Set<LiveInfo> sourceLiveInfoSet;
    private LiveInfo currentLiveInfo;
    private StreamInfo streams;
    private PlayerConfig mPlayerConfig;
    private PlayerConfig.Builder mCacheBuilder;
    private MediaViewProxy mediaViewProxy;
    private StreamLineHandler mStreamLineHandler;
    private StreamInfoChangeHandler mStreamInfoChangeHandler;
    private AtomicBoolean needCallback;

    public LivePlayer(Set<LiveInfo> sourceLiveInfoSet) {
        YLKLog.i(TAG, "LivePlayer create: liveInfoSetSize=" + FP.size(sourceLiveInfoSet) + " ,hash:" + this.hashCode() + ", liveInfoSet=" + sourceLiveInfoSet);
        Assert.assertNotNull((String)"Create LivePlayer must not Nil", sourceLiveInfoSet);
        this.needCallback = new AtomicBoolean(true);
        this.sourceLiveInfoSet = new HashSet<LiveInfo>(sourceLiveInfoSet);
        this.currentLiveInfo = (LiveInfo)FP.first(sourceLiveInfoSet);
        this.isMultiSource = this.getCurLiveInfo().isMultiSource();
        this.isMix = this.getCurLiveInfo().isMix;
        this.setupStreamInfoChangeHandler(this.currentLiveInfo);
        this.resetCacheBuilder();
        this.setupPlayerConfig();
        this.enableAudio = true;
        this.enableVideo = true;
        this.mediaViewProxy = new MediaViewProxy();
        this.setupPlayState();
        this.setupStreamLineHandler();
        this.mediaSDK.addMsgHandler((Handler)this.msgHandler);
    }

    private void setupPlayerConfig() {
        int sugguest = Env.instance().defaultVideoLineNum == 0 ? -1 : Env.instance().defaultVideoLineNum;
        VideoGearInfo vgi = !FP.empty(this.getQualities()) ? this.getQualities().iterator().next() : PlayerConfig.DEFAULT_VGI;
        this.mPlayerConfig = new PlayerConfig.Builder().setQuality(vgi).setLineNum(this.isMix ? sugguest : 0).setVideoSource(this.getCurLiveInfo().source).build();
    }

    public View createMediaView(Context context) {
        YLKLog.i(TAG, "createMediaView  hashCode:" + this.hashCode());
        return this.mediaViewProxy.createMediaView(context);
    }

    public void destoryMediaView() {
        YLKLog.i(TAG, "destoryMediaView  hashCode:" + this.hashCode());
        this.mediaViewProxy.destoryMediaView();
    }

    public View getVideoView() {
        YLKLog.i(TAG, "getVideoView hash:" + this.hashCode());
        return this.mediaViewProxy.getVideoView();
    }

    public boolean isContain(LiveInfo liveInfo) {
        return this.sourceLiveInfoSet.contains(liveInfo);
    }

    public int addLiveInfoSet(Set<LiveInfo> freshSourceSet) {
        if (FP.empty(freshSourceSet)) {
            YLKLog.e(TAG, "addLiveInfoSet infoMap must not null");
            return 1002;
        }
        YLKLog.i(TAG, "addLiveInfoSet hashCode:" + this.hashCode() + " freshSourceSet Size =" + FP.size(freshSourceSet));
        YLKLog.i(TAG, "addLiveInfoSet hashCode:" + this.hashCode() + " freshSourceSet = [" + freshSourceSet + "]");
        boolean hasNewAdd = false;
        for (LiveInfo liveInfo : freshSourceSet) {
            if (this.sourceLiveInfoSet.contains(liveInfo) || this.isMultiSource != liveInfo.isMultiSource()) continue;
            hasNewAdd = true;
            this.sourceLiveInfoSet.add(liveInfo);
        }
        if (hasNewAdd && this.isStarted) {
            YLKLog.i(TAG, "addLiveInfoSet hasNewAdd should fetchAllVideoLine!!");
            this.mStreamLineHandler.fetchAllVideoLine();
        }
        return hasNewAdd ? 0 : 4;
    }

    public int removeLiveInfoSet(Set<LiveInfo> salesSourceSet) {
        YLKLog.i(TAG, "removeLiveInfoSet hashCode:" + this.hashCode());
        if (salesSourceSet.contains(this.currentLiveInfo)) {
            SubscribHandler.instance.unRegisterStream(this.streams);
            this.sourceLiveInfoSet.removeAll(salesSourceSet);
            if (this.isStarted) {
                if (FP.empty(this.sourceLiveInfoSet)) {
                    YLKLog.i(TAG, "removeLiveInfoSet videoSourceSet empty");
                    this.mStreamLineHandler.notifyNoVideoLine();
                } else {
                    YLKLog.i(TAG, "removeLiveInfoSet remaining Set = [" + this.sourceLiveInfoSet + "]");
                    this.mStreamLineHandler.fetchAllVideoLine();
                }
            } else {
                YLKLog.i(TAG, "removeLiveInfoSet player not start, no streamline callcack!");
            }
        } else {
            boolean removeSuccess = this.sourceLiveInfoSet.removeAll(salesSourceSet);
            if (removeSuccess && this.isStarted) {
                this.mStreamLineHandler.fetchAllVideoLine();
            }
            YLKLog.i(TAG, "removeLiveInfoSet hashCode:" + this.hashCode() + " salesSourceSet = [" + salesSourceSet + "]");
        }
        return 0;
    }

    public int updateLiveInfoSet(Set<LiveInfo> newSet) {
        YLKLog.e(TAG, "updateLiveInfoSet hashCode = [" + this.hashCode() + "]");
        Assert.assertTrue((String)"updateLiveInfoSet newSet must not null", (newSet != null ? 1 : 0) != 0);
        if (FP.empty(newSet)) {
            return 4;
        }
        HashSet<LiveInfo> nis = new HashSet<LiveInfo>(newSet);
        for (LiveInfo i : nis) {
            if (i.isMultiSource() != this.isMultiSource) {
                YLKLog.e(TAG, "updateLiveInfoSet newSet = [" + newSet + "]");
                continue;
            }
            this.updateLiveInfo(i);
        }
        return 0;
    }

    void updateLiveInfoMember(LiveInfo from, LiveInfo to) {
        if (FP.eq((Object)from, (Object)to)) {
            YLKLog.i(TAG, "updateLiveInfoMember \nfrom = [" + from + "], \nto = [" + to + "]");
            from.micNo = to.micNo;
            from.streamInfoList = new CopyOnWriteArrayList<StreamInfo>(to.streamInfoList);
        } else {
            YLKLog.e(TAG, "updateLiveInfoMember not match: from = [" + from + "], to = [" + to + "]");
        }
    }

    void updateOtherLiveInfo(LiveInfo other) {
        YLKLog.i(TAG, "updateOtherLiveInfo other = [" + other + "]");
        LiveInfo cache = this.findLiveInfo(this.sourceLiveInfoSet, other.source);
        if (cache != null) {
            this.updateLiveInfoMember(cache, other);
        } else {
            YLKLog.e(TAG, "updateOtherLiveInfo not found source = [" + other.source + "]");
        }
    }

    private VideoGearInfo findBestMatch(List<VideoGearInfo> candidates, int preferGear) {
        int idx;
        Assert.assertTrue((String)"\u65e0\u6cd5\u4ece\u4e00\u4e2a\u7a7a\u5217\u8868\u4e2d\u8fdb\u884c\u6863\u4f4d\u9009\u62e9", (candidates.size() > 0 ? 1 : 0) != 0);
        YLKLog.i(TAG, "findBestMatch candidates:" + candidates + ",prefer:" + preferGear);
        ArrayList<VideoGearInfo> vgiTmp = new ArrayList<VideoGearInfo>(candidates);
        Collections.sort(vgiTmp, new Comparator<VideoGearInfo>(){

            @Override
            public int compare(VideoGearInfo o1, VideoGearInfo o2) {
                return o1.gear - o2.gear;
            }
        });
        for (idx = vgiTmp.size() - 1; idx >= 0 && preferGear < ((VideoGearInfo)vgiTmp.get((int)idx)).gear; --idx) {
        }
        if (idx < 0) {
            return (VideoGearInfo)vgiTmp.get(0);
        }
        return (VideoGearInfo)vgiTmp.get(idx);
    }

    int updateLiveInfo(LiveInfo newInfo) {
        if (!this.currentLiveInfo.equals(newInfo)) {
            this.updateOtherLiveInfo(newInfo);
            return 0;
        }
        YLKLog.i(TAG, "updateLiveInfo hashcode:" + this.hashCode() + " newInfo = [" + newInfo + "]");
        this.notifyVideoStatusChange(newInfo);
        if (!this.isStarted) {
            this.updateLiveInfoMember(this.currentLiveInfo, newInfo);
            return 4;
        }
        this.updateAndCheckPlayConfig();
        VideoGearInfo bestMatch = null;
        int interruptCode = 0;
        if (newInfo.hasVideo()) {
            List<VideoGearInfo> qualities = newInfo.getVideoQuality();
            bestMatch = this.findBestMatch(qualities, this.mPlayerConfig.getQuality().gear);
            Map<VideoGearInfo, StreamInfo> qualityStreamInfoMaps = newInfo.streamsForCurrentProperties();
            StreamInfo newStream = qualityStreamInfoMaps.get(bestMatch);
            if (newStream != null) {
                AudioInfo audioInfo = this.enableAudio != false ? newStream.audio : null;
                VideoInfo videoInfo = this.enableVideo != false ? newStream.video : null;
                boolean videoSame = false;
                if (this.streams != null) {
                    videoSame |= videoInfo == this.streams.video;
                    videoSame |= videoInfo != null && this.streams.video != null && videoInfo.equals(this.streams.video);
                }
                if (videoSame) {
                    interruptCode = audioInfo != null && this.streams.audio == null || audioInfo == null && this.streams.audio != null || audioInfo != null && !audioInfo.equals(this.streams.audio) ? 1 : 2;
                } else if (this.streams != null && this.streams.video == null && videoInfo != null) {
                    interruptCode = 4;
                } else {
                    boolean encodeSame = this.streams != null && this.streams.video != null && this.streams.video.encode == videoInfo.encode;
                    interruptCode = encodeSame ? 3 : 5;
                }
            }
        } else {
            interruptCode = this.streams != null && this.streams.video != null ? 6 : 0;
        }
        this.updateLiveInfoMember(this.currentLiveInfo, newInfo);
        this.updateStreamInfoChangeHandler(newInfo);
        YLKLog.i(TAG, "updateLiveInfo interruptCode:" + interruptCode);
        int[] noDelegate = new int[]{0, 1, 2, 6};
        List noDelegateLst = FP.toList((int[])noDelegate);
        if (noDelegateLst.contains(interruptCode)) {
            this.sendVideoCodeRateChange();
            if (bestMatch != null) {
                YLKLog.i(TAG, "updateLiveInfo bestMatch videoQuality:" + bestMatch);
                this.mPlayerConfig.setQuality(bestMatch);
            }
            switch (interruptCode) {
                case 0: 
                case 1: {
                    return this.innerSwitchQuality(this.mPlayerConfig.getQuality().gear, this.mPlayerConfig.getLineNum(), this.mPlayerConfig.getVideoSource(), false, false);
                }
                case 6: {
                    return this.innerSwitchQuality(this.mPlayerConfig.getQuality().gear, this.mPlayerConfig.getLineNum(), this.mPlayerConfig.getVideoSource(), false, true);
                }
            }
            this.updateCurrentStream(newInfo);
            this.mStreamLineHandler.fetchAllVideoLine();
            return 0;
        }
        return this.innerSwitchQuality(this.mPlayerConfig.getQuality().gear, this.mPlayerConfig.getLineNum(), this.mPlayerConfig.getVideoSource(), this.hasVideo(), this.hasVideo() && this.isStarted);
    }

    void updateCurrentStream(LiveInfo newLiveInfo) {
        VideoInfo videoInfo = null;
        if (this.streams != null && this.streams.video != null) {
            Set<VideoInfo> videoInfoSet = newLiveInfo.getVideoSet();
            for (VideoInfo vi : videoInfoSet) {
                if (!vi.equals(this.streams.video)) continue;
                videoInfo = vi;
                break;
            }
        }
        AudioInfo audioInfo = null;
        if (this.streams != null && this.streams.audio != null) {
            Set<AudioInfo> audioInfoSet = newLiveInfo.getAudioSet();
            for (AudioInfo ai : audioInfoSet) {
                if (!ai.equals(this.streams.audio)) continue;
                audioInfo = ai;
                break;
            }
        }
        int type = this.streams.type;
        this.streams = new StreamInfo(videoInfo, audioInfo, type);
        YLKLog.i(TAG, "updateCurrentStream make new StreamInfo: streams = [" + this.streams + "]");
    }

    public void setVideoQuality(VideoGearInfo quality) {
        YLKLog.i(TAG, "setVideoQuality  hashCode: " + this.hashCode() + " quality = [" + quality + "]");
        Assert.assertNotNull((String)"setVideoQuality VideoQuality must not be null", (Object)quality);
        if (!this.getQualities().contains(quality)) {
            YLKLog.e(TAG, "setVideoQuality hashCode:" + this.hashCode() + ", quality not in list!!");
        }
        this.mCacheBuilder.setQuality(quality);
    }

    public void setVideoLine(int lineNum) {
        YLKLog.i(TAG, "setVideoLine hashCode:" + this.hashCode() + " lineNum = [" + lineNum + "]");
        if (!this.isMix && lineNum != 0) {
            YLKLog.i(TAG, "setVideoLine isMix:" + this.isMix + "  changeLineNum to 0");
            lineNum = 0;
        }
        this.mCacheBuilder.setLineNum(lineNum);
    }

    public void setVideoSource(int videoSource) {
        YLKLog.i(TAG, "setVideoSource hashCode:" + this.hashCode() + " videoSource = [" + videoSource + "]");
        this.mCacheBuilder.setVideoSource(videoSource);
    }

    void innerSetVideoLine(int lineNum) {
        YLKLog.i(TAG, "innerSetVideoLine hashCode:" + this.hashCode() + " lineNum = [" + lineNum + "]");
        this.mPlayerConfig.setLineNum(lineNum);
    }

    public VideoGearInfo getCurVideoQuality() {
        return this.mPlayerConfig.getQuality();
    }

    public int startPlay(ILivePlayer.PlayOption playOption) {
        return this.startPlay(playOption, true);
    }

    public synchronized int startPlay(ILivePlayer.PlayOption playOption, boolean needCallback) {
        YLKLog.i(TAG, "startPlay playOption = [" + (Object)((Object)playOption) + "], needCallback = [" + needCallback + "] ,hash:" + this.hashCode());
        if (this.isStarted && !needCallback) {
            YLKLog.i(TAG, " startPlay return RES_ERROR_ALREADY_START");
            return 3001;
        }
        this.needCallback.set(needCallback);
        if (this.updateAndCheckPlayConfig() && this.checkPlayOption(playOption) && this.isStarted) {
            this.alreadyStartHandle(needCallback, needCallback && ILivePlayer.PlayState.Playing.equals((Object)this.playState.get()));
            return 3001;
        }
        this.enableVideo = ILivePlayer.PlayOption.ALL.equals((Object)playOption) || ILivePlayer.PlayOption.Video.equals((Object)playOption);
        this.enableAudio = ILivePlayer.PlayOption.ALL.equals((Object)playOption) || ILivePlayer.PlayOption.Audio.equals((Object)playOption);
        YLKLog.i(TAG, "startPlay isStarted: enableVideo=" + this.enableVideo + " , enableAudio:" + this.enableAudio + " ,hash:" + this.hashCode());
        return this.innerSwitchQuality(this.mPlayerConfig.getQuality().gear, this.mPlayerConfig.getLineNum(), this.mPlayerConfig.getVideoSource(), this.enableVideo != false && this.hasVideo() && !this.isVideoSubscribed() && needCallback, this.enableVideo != false && this.hasVideo() && this.isVideoSubscribed() && needCallback);
    }

    public int stopPlay() {
        YLKLog.i(TAG, "LivePlayer stopPlay hash:" + this.hashCode());
        if (this.streams == null) {
            YLKLog.e(TAG, "LivePlayer stopPlay RES_ERROR hash:" + this.hashCode());
            return 1;
        }
        if (!this.isStarted) {
            YLKLog.e(TAG, "LivePlayer stopPlay RES_ERROR_ALREADY_STOP hash:" + this.hashCode());
            return 3002;
        }
        this.isStarted = false;
        SubscribHandler.instance.unRegisterStream(this.streams).execute();
        this.resetCacheBuilder();
        this.changeState(ILivePlayer.PlayState.Stopped);
        this.mediaViewProxy.setStObject(null);
        return 0;
    }

    public LiveInfo getCurLiveInfo() {
        return this.currentLiveInfo;
    }

    public Set<LiveInfo> getAllLiveInfo() {
        YLKLog.i(TAG, "getAllLiveInfo size:" + FP.size(this.sourceLiveInfoSet) + ",hash:" + this.hashCode());
        return new HashSet<LiveInfo>(this.sourceLiveInfoSet);
    }

    public List<VideoGearInfo> getQualities() {
        return this.getQualities(this.currentLiveInfo);
    }

    List<VideoGearInfo> getQualities(LiveInfo liveInfo) {
        if (!this.hasVideo()) {
            return Collections.EMPTY_LIST;
        }
        return liveInfo.getVideoQuality();
    }

    public int getCurLineNum() {
        Integer lineNum = this.mPlayerConfig.getLineNum();
        YLKLog.i(TAG, "getCurLineNum lineNum=" + lineNum + " hash=" + this.hashCode());
        return lineNum;
    }

    public Map<Integer, Map<Integer, List<VideoGearInfo>>> getAllLines() {
        return this.mStreamLineHandler.getAllLines();
    }

    public Set<Integer> getVideoSources() {
        HashSet<Integer> sourceSet = new HashSet<Integer>();
        for (LiveInfo liveInfo : this.sourceLiveInfoSet) {
            sourceSet.add(liveInfo.source);
        }
        YLKLog.i(TAG, "getVideoSources sourceSet = " + sourceSet);
        return sourceSet;
    }

    public int switchQuality(VideoGearInfo quality, Integer lineNum, Integer videoSource) {
        YLKLog.i(TAG, "switchQuality hashCode:" + this.hashCode() + " ,quality = [" + quality + "], lineNum = [" + lineNum + "], videoSource = [" + videoSource + "]");
        Assert.assertNotNull((String)"switchQuality VideoQuality must not be null", (Object)quality);
        if (!this.hasVideo()) {
            YLKLog.i(TAG, "switchQuality hashCode:" + this.hashCode() + ", noVideo ignore invoke!!");
            return 1;
        }
        if (!this.getQualities().contains(quality)) {
            YLKLog.i(TAG, "switchQuality hashCode:" + this.hashCode() + ", quality not in list!!");
            return 1;
        }
        return this.innerSwitchQuality(quality.gear, lineNum, videoSource, true, this.isStarted);
    }

    private void innerChooseVideoSource(int videoSource) {
        LiveInfo bestLiveInfo;
        if (FP.empty(this.sourceLiveInfoSet)) {
            YLKLog.e(TAG, "innerChooseVideoSource sourceLiveInfoSet empty");
            return;
        }
        YLKLog.i(TAG, "innerChooseVideoSource videoSource = [" + videoSource + "]");
        LiveInfo sourceLiveInfo = this.findLiveInfo(this.sourceLiveInfoSet, videoSource);
        LiveInfo liveInfo = bestLiveInfo = sourceLiveInfo == null ? (LiveInfo)FP.first(this.sourceLiveInfoSet) : sourceLiveInfo;
        if (bestLiveInfo.source != this.currentLiveInfo.source) {
            SubscribHandler.instance.unRegisterStream(this.streams);
        }
        this.changedCurrentLiveInfo(bestLiveInfo);
        this.mPlayerConfig.setVideoSource(bestLiveInfo.source);
    }

    private StreamInfo innerChooseStreamInfo(int wannerQuality, int lineNum) {
        if (this.hasVideo()) {
            YLKLog.i(TAG, "innerChooseStreamInfo wannerQuality = [" + wannerQuality + "], lineNum = [" + lineNum + "]");
            List<VideoGearInfo> qualities = this.getQualities();
            if (FP.empty(qualities)) {
                YLKLog.e(TAG, "innerChooseStreamInfo qualities null");
                return null;
            }
            VideoGearInfo bestMatchVideoQuality = this.findBestMatch(qualities, wannerQuality);
            Map<VideoGearInfo, StreamInfo> streams = this.currentLiveInfo.streamsForCurrentProperties();
            StreamInfo beatStreamInfo = streams.get(bestMatchVideoQuality);
            if (beatStreamInfo != null && beatStreamInfo.video != null) {
                int lineNumber = this.isMix ? lineNum : 0;
                this.mPlayerConfig.setLineNum(lineNumber);
                beatStreamInfo.video.changeStreamLine(lineNumber);
                this.mPlayerConfig.setQuality(bestMatchVideoQuality);
                YLKLog.i(TAG, " innerChooseStreamInfo bestMatchVideoQuality:" + bestMatchVideoQuality + ", lineNum = " + lineNumber);
            }
            return beatStreamInfo;
        }
        YLKLog.i(TAG, "innerChooseStreamInfo noVideo, choose first of streamInfoList");
        return (StreamInfo)FP.first(this.currentLiveInfo.streamInfoList);
    }

    private int innerSwitchQuality(int quality, int lineNum, int videoSource, boolean needStartCallback, boolean needStopCallback) {
        this.isStarted = true;
        this.resetCacheBuilder();
        YLKLog.i(TAG, "innerSwitchQuality quality = [" + quality + "], lineNum = [" + lineNum + "], videoSource = [" + videoSource + "], needStartCallback = [" + needStartCallback + "], needStopCallback = [" + needStopCallback + "]");
        if (FP.empty(this.sourceLiveInfoSet)) {
            YLKLog.e(TAG, "innerSwitchQuality sourceLiveInfoSet empty");
            return 1;
        }
        this.innerChooseVideoSource(videoSource);
        StreamInfo si = this.innerChooseStreamInfo(quality, lineNum);
        if (si == null) {
            YLKLog.e(TAG, "innerSwitchQuality si is nil");
            return 1;
        }
        YLKLog.i(TAG, " innerSwitchQuality wanner to play stream:" + si);
        if (needStopCallback) {
            this.changeState(ILivePlayer.PlayState.Stopped);
        }
        this.subscribe(si);
        if (needStartCallback) {
            this.notifyVideoStatusChange(this.getCurLiveInfo());
            this.changeState(ILivePlayer.PlayState.Connecting);
        }
        this.mStreamLineHandler.fetchAllVideoLine();
        return 0;
    }

    public void addStreamLineEventHandler(ILivePlayer.StreamLineEventHandler handler) {
        Assert.assertNotNull((Object)handler);
        this.mStreamLineHandler.addStreamLineEventHandler(handler);
    }

    public void removeStreamLineEvnetHandler(ILivePlayer.StreamLineEventHandler handler) {
        Assert.assertNotNull((Object)handler);
        this.mStreamLineHandler.removeStreamLineEventHandler(handler);
    }

    public StreamInfo getCurStreamInfo() {
        VideoInfo v = this.streams != null ? this.streams.video : null;
        AudioInfo a = this.streams != null ? this.streams.audio : null;
        int t = this.streams != null ? this.streams.type : -1;
        return new StreamInfo(v, a, t);
    }

    public ILivePlayer.PlayState getCurState() {
        return this.playState.get();
    }

    public Bitmap getVideoScreenShot() {
        return this.mediaViewProxy.getVideoScreenShot();
    }

    public int setAudioEnable(boolean enabled) {
        YLKLog.i(TAG, " setAudioEnable:" + enabled + " ,hash:" + this.hashCode());
        if (this.enableAudio.equals(enabled)) {
            return 1;
        }
        if (!this.isStarted) {
            YLKLog.e(TAG, " enableAudio failed: isStarted=" + this.isStarted);
            return 1;
        }
        this.enableAudio = enabled;
        this.updateAndCheckPlayConfig();
        return this.innerSwitchQuality(this.mPlayerConfig.getQuality().gear, this.mPlayerConfig.getLineNum(), this.mPlayerConfig.getVideoSource(), false, false);
    }

    public boolean isVideoEnable() {
        return this.enableVideo;
    }

    public boolean isAudioEnable() {
        return this.enableAudio;
    }

    public int setVideoEnabled(boolean enabled) {
        YLKLog.i(TAG, " setVideoEnabled:" + enabled + " ,hash:" + this.hashCode());
        if (this.enableVideo.equals(enabled)) {
            return 1;
        }
        if (!this.isStarted) {
            YLKLog.e(TAG, " enableVideo failed: isStarted=" + this.isStarted);
            return 1;
        }
        this.enableVideo = enabled;
        this.updateAndCheckPlayConfig();
        return this.innerSwitchQuality(this.mPlayerConfig.getQuality().gear, this.mPlayerConfig.getLineNum(), this.mPlayerConfig.getVideoSource(), this.hasVideo() && enabled, this.hasVideo() && !enabled);
    }

    public MediaViewProxy getMediaViewProxy() {
        return this.mediaViewProxy;
    }

    public long getStreamId() {
        return this.mediaViewProxy.getStreamId();
    }

    public void release() {
        YLKLog.i(TAG, "LivePlayer release hash: " + this.hashCode());
        SubscribHandler.instance.unRegisterStream(this.streams);
        if (this.mediaViewProxy.isLinkState()) {
            this.mediaViewProxy.setStObject(null);
        }
        this.mediaSDK.removeMsgHandler((Handler)this.msgHandler);
        this.unRegisterHandler();
    }

    public boolean hasVideo() {
        return this.currentLiveInfo.hasVideo();
    }

    public boolean isMultiSourcePlayer() {
        return this.currentLiveInfo.isMultiSource();
    }

    protected LiveInfo findLiveInfo(Set<LiveInfo> sourceSet, int source) {
        for (LiveInfo liveInfo : sourceSet) {
            if (liveInfo.source != source) continue;
            return liveInfo;
        }
        return null;
    }

    protected void setupPlayState() {
        this.playState = new ObservableValue<ILivePlayer.PlayState>(ILivePlayer.PlayState.Stopped);
        this.playState.addObserver(this, false, new ObservableValue.Observer<ILivePlayer.PlayState>(){

            @Override
            public void updated(boolean isInitial, ILivePlayer.PlayState from, ILivePlayer.PlayState to) {
                YLKLog.i(LivePlayer.TAG, "playState change isInitial:" + isInitial + ", needCallback:" + LivePlayer.this.needCallback + ", from:" + (Object)((Object)from) + ", to:" + (Object)((Object)to) + " ,hash:" + LivePlayer.this.hashCode());
                if (!LivePlayer.this.needCallback.get()) {
                    return;
                }
                switch (to) {
                    case Connecting: {
                        LivePlayer.this.iteratePlayerEventHandlers(new CollectionUtils.Visitor<ILivePlayer.PlayerEventHandler>(){

                            @Override
                            public void onVisit(ILivePlayer.PlayerEventHandler handler) {
                                handler.onStart(LivePlayer.this, LivePlayer.this.getCurLiveInfo(), LivePlayer.this.streams);
                            }
                        });
                        break;
                    }
                    case Playing: {
                        LivePlayer.this.iteratePlayerEventHandlers(new CollectionUtils.Visitor<ILivePlayer.PlayerEventHandler>(){

                            @Override
                            public void onVisit(ILivePlayer.PlayerEventHandler handler) {
                                handler.onPlaying(LivePlayer.this, LivePlayer.this.getCurLiveInfo(), LivePlayer.this.streams);
                            }
                        });
                        break;
                    }
                    case Stopped: {
                        LivePlayer.this.iteratePlayerEventHandlers(new CollectionUtils.Visitor<ILivePlayer.PlayerEventHandler>(){

                            @Override
                            public void onVisit(ILivePlayer.PlayerEventHandler handler) {
                                handler.onStop(LivePlayer.this, LivePlayer.this.getCurLiveInfo(), LivePlayer.this.streams);
                            }
                        });
                    }
                }
            }
        });
    }

    protected void setupStreamLineHandler() {
        this.mStreamLineHandler = new StreamLineHandler(this);
    }

    protected void setupStreamInfoChangeHandler(LiveInfo liveinfo) {
        this.mStreamInfoChangeHandler = new StreamInfoChangeHandler(liveinfo, new StreamInfoChangeHandler.VideoCodeRateListener(){

            @Override
            public void onVideoCodeRateList(final LiveInfo li, final Map<VideoGearInfo, Integer> codeRateList) {
                LivePlayer.this.iterateQosEventHandlers(new CollectionUtils.Visitor<ILivePlayer.QosEventHandler>(){

                    @Override
                    public void onVisit(ILivePlayer.QosEventHandler handler) {
                        handler.onVideoCodeRateList(LivePlayer.this, li, new LiveKitMsg.VideoCodeRateInfo(li.uid, codeRateList));
                    }
                });
            }

            @Override
            public void onVideoCodeRateChange(final LiveInfo li, final VideoGearInfo to, final Integer codeRete) {
                LivePlayer.this.iterateQosEventHandlers(new CollectionUtils.Visitor<ILivePlayer.QosEventHandler>(){

                    @Override
                    public void onVisit(ILivePlayer.QosEventHandler handler) {
                        handler.onVideoCodeRateChange(LivePlayer.this, li, new LiveKitMsg.VideoCodeRateChange(li.uid, codeRete, to));
                    }
                });
            }

            @Override
            public void onVideoEncodeInfoChange(final LiveInfo li, final int width, final int height, final int encodeType) {
                LivePlayer.this.iterateQosEventHandlers(new CollectionUtils.Visitor<ILivePlayer.QosEventHandler>(){

                    @Override
                    public void onVisit(ILivePlayer.QosEventHandler handler) {
                        handler.onVideoEncodeInfoChange(LivePlayer.this, li, new LiveKitMsg.VideoEncodeInfoChange(width, height, encodeType));
                    }
                });
            }
        });
    }

    protected void updateStreamInfoChangeHandler(LiveInfo liveinfo) {
        this.setupStreamInfoChangeHandler(liveinfo);
        this.mStreamInfoChangeHandler.sendVideoCodeRateList();
    }

    protected boolean checkPlayOption(ILivePlayer.PlayOption playOption) {
        boolean v = false;
        boolean a = false;
        switch (playOption) {
            case ALL: {
                a = true;
                v = true;
                break;
            }
            case Audio: {
                v = false;
                a = true;
                break;
            }
            case Video: {
                v = true;
                a = false;
            }
        }
        return this.enableAudio.equals(a) && this.enableVideo.equals(v);
    }

    protected boolean updateAndCheckPlayConfig() {
        boolean op1 = false;
        if (this.mCacheBuilder.getLineNum() != -1 && !FP.eq((Object)this.mCacheBuilder.getLineNum(), (Object)this.mPlayerConfig.getLineNum())) {
            this.mPlayerConfig.setLineNum(this.mCacheBuilder.getLineNum());
            op1 = true;
        }
        boolean op2 = false;
        if (this.mCacheBuilder.getQuality() != PlayerConfig.DEFAULT_VGI && !FP.eq((Object)this.mCacheBuilder.getQuality(), (Object)this.mPlayerConfig.getQuality())) {
            this.mPlayerConfig.setQuality(this.mCacheBuilder.getQuality());
            op2 = true;
        }
        boolean op3 = false;
        if (this.mCacheBuilder.getVideoSource() != -1 && !FP.eq((Object)this.mCacheBuilder.getVideoSource(), (Object)this.mPlayerConfig.getVideoSource())) {
            this.mPlayerConfig.setVideoSource(this.mCacheBuilder.getVideoSource());
            op3 = true;
        }
        YLKLog.i(TAG, "updateAndCheckPlayConfig op1 = " + op1 + " , op2 = " + op2 + " , op3 = " + op3 + " ;hash = " + this.hashCode());
        return !op1 && !op2 && !op3;
    }

    protected void sendVideoCodeRateChange() {
        StreamInfo streamInfo = this.getCurStreamInfo();
        if (streamInfo != null && streamInfo.video != null) {
            this.mStreamInfoChangeHandler.sendVideoCodeRateChange(streamInfo.video.streamName);
            this.mStreamInfoChangeHandler.sendVideoEncodeInfoChange(streamInfo.video.streamName);
        }
    }

    @Override
    public boolean isStartState() {
        return this.isStarted;
    }

    private int getDecodeType(VideoInfo videoInfo) {
        int decodeType = -1;
        switch (videoInfo.encode) {
            case 101: {
                decodeType = this.mediaSDK.getConfig(316);
                YLKLog.i(TAG, "getDecodeType H265 , [" + decodeType + "]");
                break;
            }
            case 100: {
                decodeType = this.mediaSDK.getConfig(302);
                YLKLog.i(TAG, "getDecodeType H264 , [" + decodeType + "]");
            }
        }
        return decodeType;
    }

    @Override
    protected void setupMessageHandle() {
        this.registerHandler(501, new HandleMsg(new Option(){

            public boolean preCheck(Object info) {
                YLKLog.i(LivePlayer.TAG, "onLiveSubscibeStatus preCheck: " + info);
                if (info instanceof MediaVideoMsg.LiveSubscribeStatusInfo) {
                    return LivePlayer.this.isContain(((MediaVideoMsg.LiveSubscribeStatusInfo)info).streamName);
                }
                return false;
            }

            public void process(Object obj) {
                MediaVideoMsg.LiveSubscribeStatusInfo info = (MediaVideoMsg.LiveSubscribeStatusInfo)obj;
                YLKLog.i(LivePlayer.TAG, "onLiveSubscibeStatus: " + info.streamName + " status: " + AbsLivePlayer.subscribeStatus(info.status) + ", this:" + LivePlayer.this.hashCode());
            }
        }));
        this.registerHandler(503, new HandleMsg(new Option(){

            public boolean preCheck(Object obj) {
                YLKLog.i(LivePlayer.TAG, "onLiveVideoStreamStatus preCheck: " + obj);
                if (!(obj instanceof MediaVideoMsg.LiveVideoStreamStatusInfo)) {
                    return false;
                }
                MediaVideoMsg.LiveVideoStreamStatusInfo info = (MediaVideoMsg.LiveVideoStreamStatusInfo)obj;
                return LivePlayer.this.isContain(info.streamName);
            }

            public void process(Object obj) {
                MediaVideoMsg.LiveVideoStreamStatusInfo info = (MediaVideoMsg.LiveVideoStreamStatusInfo)obj;
                String streamStatus = AbsLivePlayer.videoStreamStatus(info.status);
                YLKLog.i(LivePlayer.TAG, "onLiveVideoStreamStatus:" + info.streamName + " status:" + streamStatus + ",this:" + LivePlayer.this.hashCode());
                switch (streamStatus) {
                    case "Arrive": {
                        SubscribHandler.instance.setEnableFastAccess(true);
                        LivePlayer.this.mStreamInfoChangeHandler.sendVideoCodeRateChange(info.streamName);
                        LivePlayer.this.mStreamInfoChangeHandler.sendVideoEncodeInfoChange(info.streamName);
                        if (!LivePlayer.this.mediaViewProxy.isSame(info.streamId)) {
                            LivePlayer.this.mediaViewProxy.setStObject(null);
                        }
                        LivePlayer.this.mediaViewProxy.saveStreamInfo(info.streamId, -1);
                        break;
                    }
                    case "Start": {
                        LivePlayer.this.changeState(ILivePlayer.PlayState.Playing);
                        break;
                    }
                    case "Stop": {
                        LivePlayer.this.mediaViewProxy.resetStValue(info.streamId);
                    }
                }
            }
        }));
        this.registerHandler(109, new HandleMsg(new Option(){

            public boolean preCheck(Object obj) {
                if (!(obj instanceof MediaVideoMsg.NoVideoInfo)) {
                    return false;
                }
                MediaVideoMsg.NoVideoInfo noVideoInfo = (MediaVideoMsg.NoVideoInfo)obj;
                return noVideoInfo != null && LivePlayer.this.isSame(noVideoInfo.streamId);
            }

            public void process(final Object obj) {
                LivePlayer.this.iterateQosEventHandlers(new CollectionUtils.Visitor<ILivePlayer.QosEventHandler>(){

                    @Override
                    public void onVisit(ILivePlayer.QosEventHandler handler) {
                        handler.onVideoLostNotify(LivePlayer.this, LivePlayer.this.getCurLiveInfo(), (MediaVideoMsg.NoVideoInfo)obj);
                    }
                });
            }
        }));
        this.registerHandler(108, new HandleMsg(new Option(){

            public boolean preCheck(Object obj) {
                if (!(obj instanceof MediaVideoMsg.FpsInfo)) {
                    return false;
                }
                MediaVideoMsg.FpsInfo fpsInfo = (MediaVideoMsg.FpsInfo)obj;
                return fpsInfo != null && LivePlayer.this.isSame(fpsInfo.streamId);
            }

            public void process(final Object obj) {
                LivePlayer.this.iterateQosEventHandlers(new CollectionUtils.Visitor<ILivePlayer.QosEventHandler>(){

                    @Override
                    public void onVisit(ILivePlayer.QosEventHandler handler) {
                        handler.onUpdateVideoFps(LivePlayer.this, LivePlayer.this.getCurLiveInfo(), (MediaVideoMsg.FpsInfo)obj);
                    }
                });
            }
        }));
        this.registerHandler(111, new HandleMsg(new Option(){

            public boolean preCheck(Object obj) {
                if (!(obj instanceof MediaVideoMsg.VideoFrameLossInfo)) {
                    return false;
                }
                MediaVideoMsg.VideoFrameLossInfo lossInfo = (MediaVideoMsg.VideoFrameLossInfo)obj;
                return lossInfo != null && LivePlayer.this.isSame(lossInfo.streamId);
            }

            public void process(final Object obj) {
                LivePlayer.this.iterateQosEventHandlers(new CollectionUtils.Visitor<ILivePlayer.QosEventHandler>(){

                    @Override
                    public void onVisit(ILivePlayer.QosEventHandler handler) {
                        handler.onLossVideoFrame(LivePlayer.this, LivePlayer.this.getCurLiveInfo(), (MediaVideoMsg.VideoFrameLossInfo)obj);
                    }
                });
            }
        }));
        this.registerHandler(138, new HandleMsg(new Option(){

            public boolean preCheck(Object obj) {
                if (!(obj instanceof MediaVideoMsg.HardwareDecodeErrorInfo)) {
                    return false;
                }
                MediaVideoMsg.HardwareDecodeErrorInfo info = (MediaVideoMsg.HardwareDecodeErrorInfo)obj;
                YLKLog.i(LivePlayer.TAG, "onHardwareDecodeErrorInfo  = [" + info + "]");
                return info != null && LivePlayer.this.isSame(info.streamId);
            }

            public void process(Object obj) {
                MediaVideoMsg.HardwareDecodeErrorInfo info = (MediaVideoMsg.HardwareDecodeErrorInfo)obj;
                LivePlayer.this.mediaSDK.setConfigs(0, (Map)new HashMap<Integer, Integer>(){
                    {
                        this.put(316, 0);
                    }
                });
                LivePlayer.this.mediaSDK.setConfigs(0, (Map)new HashMap<Integer, Integer>(){
                    {
                        this.put(302, 0);
                    }
                });
            }
        }));
        this.registerHandler(126, new HandleMsg(new Option(){

            public boolean preCheck(Object obj) {
                if (!(obj instanceof MediaVideoMsg.FirstFrameRenderNotify)) {
                    return false;
                }
                MediaVideoMsg.FirstFrameRenderNotify firstFrame = (MediaVideoMsg.FirstFrameRenderNotify)obj;
                return firstFrame != null && LivePlayer.this.isSame(firstFrame.streamId);
            }

            public void process(final Object obj) {
                LivePlayer.this.iterateQosEventHandlers(new CollectionUtils.Visitor<ILivePlayer.QosEventHandler>(){

                    @Override
                    public void onVisit(ILivePlayer.QosEventHandler handler) {
                        handler.onFirstFrameNotify(LivePlayer.this, LivePlayer.this.getCurLiveInfo(), (MediaVideoMsg.FirstFrameRenderNotify)obj);
                    }
                });
            }
        }));
        this.registerHandler(136, new HandleMsg(new Option(){

            public boolean preCheck(Object obj) {
                if (!(obj instanceof MediaVideoMsg.FirstFrameSeeInfo)) {
                    return false;
                }
                MediaVideoMsg.FirstFrameSeeInfo firstFrame = (MediaVideoMsg.FirstFrameSeeInfo)obj;
                return firstFrame != null && LivePlayer.this.isSame(firstFrame.streamId);
            }

            public void process(final Object obj) {
                LivePlayer.this.iterateQosEventHandlers(new CollectionUtils.Visitor<ILivePlayer.QosEventHandler>(){

                    @Override
                    public void onVisit(ILivePlayer.QosEventHandler handler) {
                        handler.onFirstFrameRenderNotify(LivePlayer.this, LivePlayer.this.getCurLiveInfo(), (MediaVideoMsg.FirstFrameSeeInfo)obj);
                    }
                });
            }
        }));
        this.registerHandler(123, new HandleMsg(new Option(){

            public boolean preCheck(Object obj) {
                if (!(obj instanceof MediaVideoMsg.VideoViewerStatInfo)) {
                    return false;
                }
                return obj != null;
            }

            public void process(final Object obj) {
                LivePlayer.this.iterateViewerEventHandlers(new CollectionUtils.Visitor<ILivePlayer.ViewerEventHandler>(){

                    @Override
                    public void onVisit(ILivePlayer.ViewerEventHandler handler) {
                        handler.onVideoViewerStatNotify(LivePlayer.this, (MediaVideoMsg.VideoViewerStatInfo)obj);
                    }
                });
            }
        }));
        this.registerHandler(118, new HandleMsg(new Option(){

            public boolean preCheck(Object obj) {
                if (!(obj instanceof MediaVideoMsg.VideoDecoderInfo)) {
                    return false;
                }
                MediaVideoMsg.VideoDecoderInfo vdInfo = (MediaVideoMsg.VideoDecoderInfo)obj;
                YLKLog.i(LivePlayer.TAG, "onVideoDecoderInfo " + vdInfo);
                return vdInfo != null && LivePlayer.this.mediaViewProxy.isSame(vdInfo.streamId);
            }

            public void process(Object obj) {
                final MediaVideoMsg.VideoDecoderInfo vdInfo = (MediaVideoMsg.VideoDecoderInfo)obj;
                if (LivePlayer.this.shouldReCreateVideoView(LivePlayer.this.mediaViewProxy.getVideoLayout(), vdInfo.type)) {
                    YLKLog.i(LivePlayer.TAG, "onVideoDecoderInfo willReCreateVideoView");
                    LivePlayer.this.mediaViewProxy.setStObject(null);
                }
                LivePlayer.this.mediaViewProxy.setStObject(new Tuple<Long, Integer>(vdInfo.streamId, vdInfo.type));
                LivePlayer.this.iterateQosEventHandlers(new CollectionUtils.Visitor<ILivePlayer.QosEventHandler>(){

                    @Override
                    public void onVisit(ILivePlayer.QosEventHandler handler) {
                        handler.onVideoDecoderNotify(LivePlayer.this, LivePlayer.this.getCurLiveInfo(), vdInfo);
                    }
                });
            }
        }));
        this.registerHandler(504, new HandleMsg(new Option(){

            public boolean preCheck(Object obj) {
                if (!(obj instanceof MediaVideoMsg.LiveStreamLineInfo)) {
                    return false;
                }
                return obj != null;
            }

            public void process(Object obj) {
                MediaVideoMsg.LiveStreamLineInfo lineInfo = (MediaVideoMsg.LiveStreamLineInfo)obj;
                YLKLog.i(LivePlayer.TAG, "onLiveStreamLineInfo lineInfo = [" + obj + "]");
                LivePlayer.this.mStreamLineHandler.process(lineInfo);
            }
        }));
        this.registerHandler(125, new HandleMsg(new Option(){

            public boolean preCheck(Object obj) {
                if (!(obj instanceof MediaVideoMsg.VideoSizeInfo)) {
                    return false;
                }
                MediaVideoMsg.VideoSizeInfo info = (MediaVideoMsg.VideoSizeInfo)obj;
                return LivePlayer.this.mediaViewProxy.isSame(info.streamId);
            }

            public void process(final Object obj) {
                YLKLog.i(LivePlayer.TAG, "onDecodingVideoSizeChanged: " + obj);
                LivePlayer.this.iterateQosEventHandlers(new CollectionUtils.Visitor<ILivePlayer.QosEventHandler>(){

                    @Override
                    public void onVisit(ILivePlayer.QosEventHandler handler) {
                        handler.onVideoSizeChanged(LivePlayer.this, LivePlayer.this.getCurLiveInfo(), (MediaVideoMsg.VideoSizeInfo)obj);
                    }
                });
            }
        }));
        this.registerHandler(134, new HandleMsg(new Option(){

            public boolean preCheck(Object obj) {
                if (!(obj instanceof MediaVideoMsg.VideoPlayDelayInfo)) {
                    return false;
                }
                MediaVideoMsg.VideoPlayDelayInfo info = (MediaVideoMsg.VideoPlayDelayInfo)obj;
                return LivePlayer.this.mediaViewProxy.isSame(info.streamId);
            }

            public void process(final Object obj) {
                LivePlayer.this.iterateQosEventHandlers(new CollectionUtils.Visitor<ILivePlayer.QosEventHandler>(){

                    @Override
                    public void onVisit(ILivePlayer.QosEventHandler handler) {
                        MediaVideoMsg.VideoPlayDelayInfo info = (MediaVideoMsg.VideoPlayDelayInfo)obj;
                        if (!LivePlayer.this.getCurLiveInfo().isMix) {
                            handler.onVideoPlayDelayInfoEvent(LivePlayer.this.getCurLiveInfo().uid, info.playDelay);
                        }
                    }
                });
            }
        }));
    }

    protected void notifyVideoStatusChange(final LiveInfo liveInfo) {
        this.iterateQosEventHandlers(new CollectionUtils.Visitor<ILivePlayer.QosEventHandler>(){

            @Override
            public void onVisit(ILivePlayer.QosEventHandler handler) {
                handler.onVideoStatusChange(LivePlayer.this, liveInfo, liveInfo.hasVideo());
            }
        });
    }

    protected boolean isSame(long streamId) {
        return this.mediaViewProxy.isSame(streamId);
    }

    protected void subscribe(StreamInfo streamInfo) {
        if (streamInfo != null) {
            AudioInfo audioInfo = this.enableAudio != false ? streamInfo.audio : null;
            VideoInfo videoInfo = this.enableVideo != false ? streamInfo.video : null;
            StreamInfo targets = new StreamInfo(videoInfo, audioInfo, streamInfo.type);
            SubscribHandler.instance.unRegisterStream(this.streams).registerStream(targets).execute();
            this.streams = targets;
            YLKLog.i(TAG, "LivePlayer subscribe, enableAudio:" + this.enableAudio + ",enableVideo:" + this.enableVideo);
        } else {
            YLKLog.e(TAG, "LivePlayer subscribe streamInfo = null");
        }
    }

    protected boolean isContain(String streamName) {
        if (FP.empty(this.currentLiveInfo.streamInfoList)) {
            return false;
        }
        for (StreamInfo streamInfo : this.currentLiveInfo.streamInfoList) {
            if ((streamInfo.video == null || !streamName.equals(streamInfo.video.streamName)) && (streamInfo.audio == null || !streamName.equals(streamInfo.audio.streamName))) continue;
            return true;
        }
        return false;
    }

    protected VideoInfo findVideoInfo(String streamName) {
        if (FP.empty(this.currentLiveInfo.getVideoSet())) {
            return null;
        }
        for (VideoInfo v : this.currentLiveInfo.getVideoSet()) {
            if (!v.streamName.equals(streamName)) continue;
            return v;
        }
        return null;
    }

    protected void changeState(ILivePlayer.PlayState state) {
        YLKLog.d(TAG, "changeState " + this.playState + " state = [" + (Object)((Object)state) + "]");
        this.playState.set(state);
    }

    protected boolean shouldReCreateVideoView(YVideoViewLayout videoView, int decoderType) {
        YLKLog.i(TAG, "shouldReCreateVideoView: YVideoViewLayout" + videoView + ",decoderType:" + decoderType);
        if (videoView == null || videoView.getExistingView() == null) {
            return true;
        }
        boolean shouldRecreate = false;
        if (decoderType == 1 && videoView.getExistingView().getViewType() != YSpVideoView.ViewType.SFHardView && videoView.getExistingView().getViewType() != YSpVideoView.ViewType.TXHardView) {
            YLKLog.i(TAG, "shouldReCreateVideoView: ANDROID_HARD_DECODER1");
            shouldRecreate = true;
        } else if (decoderType == 0 && (videoView.getExistingView().getViewType() == YSpVideoView.ViewType.SFHardView || videoView.getExistingView().getViewType() == YSpVideoView.ViewType.TXHardView)) {
            YLKLog.i(TAG, "shouldReCreateVideoView: SOFT_DEOCDER");
            shouldRecreate = true;
        } else {
            YLKLog.i(TAG, "shouldReCreateVideoView do not need ReCreate:" + videoView.getExistingView().getViewType());
        }
        return shouldRecreate;
    }

    protected void alreadyStartHandle(boolean needStartCallback, boolean needPlayCallback) {
        if (this.currentLiveInfo.hasVideo()) {
            YLKLog.i(TAG, "alreadyStartHandle invoke curSetQuality:" + this.mPlayerConfig.getQuality());
            List<VideoGearInfo> qualities = this.getQualities();
            if (FP.empty(qualities)) {
                YLKLog.e(TAG, "alreadyStartHandle innerSwitchQuality qualities null");
                return;
            }
            YLKLog.i(TAG, "alreadyStartHandle invoke needStartCallback:" + needStartCallback + ",needPlayCallback:" + needPlayCallback);
            if (needStartCallback) {
                this.notifyVideoStatusChange(this.getCurLiveInfo());
                this.changeState(ILivePlayer.PlayState.Connecting);
                if (needPlayCallback) {
                    this.changeState(ILivePlayer.PlayState.Playing);
                }
            }
            VideoGearInfo bestMatch = this.findBestMatch(qualities, this.mPlayerConfig.getQuality().gear);
            Map<VideoGearInfo, StreamInfo> vqToStream = this.currentLiveInfo.streamsForCurrentProperties();
            StreamInfo si = vqToStream.get(bestMatch);
            if (si != null && si.video != null) {
                this.mStreamInfoChangeHandler.sendVideoEncodeInfoChange(si.video.streamName);
                this.mStreamInfoChangeHandler.sendVideoCodeRateChange(si.video.streamName);
                this.mStreamInfoChangeHandler.sendVideoCodeRateList();
            }
        }
    }

    protected boolean isVideoSubscribed() {
        return this.streams != null && this.streams.video != null;
    }

    protected void changedCurrentLiveInfo(LiveInfo newInfo) {
        if (this.currentLiveInfo != null) {
            Assert.assertTrue((String)"should not update different multisource attribute!!", (this.currentLiveInfo.isMultiSource() == newInfo.isMultiSource() ? 1 : 0) != 0);
        }
        YLKLog.i(TAG, "changedCurrentLiveInfo newInfo = [" + newInfo + "]");
        this.currentLiveInfo = newInfo;
        this.updateStreamInfoChangeHandler(this.currentLiveInfo);
    }

    protected void resetCacheBuilder() {
        this.mCacheBuilder = new PlayerConfig.Builder();
    }
}

