/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.duowan.mobile.YYApp;
import com.medialib.video.MediaVideoMsg;
import com.yy.IMediaVideo;
import com.yy.IMediaVideoSDK;
import com.yy.mobile.YYHandler;
import com.yy.mobile.YYHandlerMgr;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.yylivekit.Env;
import com.yy.yylivekit.YLKEngine;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.AppIDSet;
import com.yy.yylivekit.model.AppNames;
import com.yy.yylivekit.model.Channel;
import com.yy.yylivekit.model.ClientRole;
import com.yy.yylivekit.model.HardwareEncodeBlacklist;
import com.yy.yylivekit.model.HeartbeatIntervalSec;
import com.yy.yylivekit.model.LiveEventHandler;
import com.yy.yylivekit.model.LiveMeta;
import com.yy.yylivekit.model.NewSystemSupports;
import com.yy.yylivekit.model.YLKMediaConfigs;
import com.yy.yylivekit.services.OpGetMediaMeta;
import com.yy.yylivekit.services.Service;
import com.yy.yylivekit.services.retrystrategies.RetryNone;
import com.yy.yylivekit.services.retrystrategies.RetryStrategy;
import com.yy.yylivekit.threading.RunInMain;
import com.yy.yylivekit.utils.ArrayUtils;
import com.yy.yylivekit.utils.Cleanup;
import com.yy.yylivekit.utils.FileStorageUtils;
import com.yy.yylivekit.utils.JsonUtils;
import com.yy.yylivekit.utils.NetworkUtils;
import com.yy.yylivekit.utils.RuntimeKit;
import com.yy.yylivekit.utils.VideoQualityCalc;
import com.yyproto.base.ISessWatcher;
import com.yyproto.base.IWatcher;
import com.yyproto.base.ProtoEvent;
import com.yyproto.base.ProtoReq;
import com.yyproto.outlet.IProtoMgr;
import com.yyproto.outlet.LoginEvent;
import com.yyproto.outlet.SDKParam;
import com.yyproto.outlet.SvcEvent;
import com.yyproto.outlet.SvcRequest;
import com.yyproto.utils.FP;
import com.yyproto.utils.YLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.Assert;
import org.json.JSONObject;

public class YLKLive {
    private static final String TAG = "YLKLive";
    private YYHandler deInitHandler;
    private YLKEngine.DeInitEventHandler deInitEventHandler = new YLKEngine.DeInitEventHandler(){

        @Override
        public void onDeInit() {
        }
    };
    private Map<Env.InitConfig, GetConfigStrategy> configs = new HashMap<Env.InitConfig, GetConfigStrategy>(){
        {
            if ("0".equals("1")) {
                this.put(Env.InitConfig.EncodeMetaUpdate, new GetConfigStrategy(){

                    @Override
                    public void getDefault() {
                        new OpGetMediaMeta.ForPublishEncodeMeta(new OpGetMediaMeta.ForPublishEncodeMeta.Completion(){

                            @Override
                            public void didGetEncodeMeta(Integer modifyInterval, Map<Integer, LiveMeta.EncodeMeta> encodeMetaMap, HardwareEncodeBlacklist blacklist) {
                                YLKLive.this.env.onUpdateEncodeMeta(modifyInterval, encodeMetaMap, blacklist);
                            }
                        }).getDefaultConfig();
                    }

                    @Override
                    public void getFromService() {
                        OpGetMediaMeta.ForPublishEncodeMeta forEncodeMeta = new OpGetMediaMeta.ForPublishEncodeMeta(new OpGetMediaMeta.ForPublishEncodeMeta.Completion(){

                            @Override
                            public void didGetEncodeMeta(Integer modifyInterval, Map<Integer, LiveMeta.EncodeMeta> encodeMetaMap, HardwareEncodeBlacklist blacklist) {
                                YLKLive.this.env.onUpdateEncodeMeta(modifyInterval, encodeMetaMap, blacklist);
                            }
                        });
                        Service.instance().launch(new OpGetMediaMeta(new Channel(0L), forEncodeMeta, new OpGetMediaMeta.Failure(){

                            @Override
                            public void didFailGettingMediaMeta() {
                                this.getDefault();
                            }
                        }), null, (RetryStrategy)new RetryNone(Integer.MAX_VALUE));
                    }
                });
            }
            this.put(Env.InitConfig.SystemParamInit, new GetConfigStrategy(){

                @Override
                public void getDefault() {
                    NewSystemSupports newSystem = new NewSystemSupports(NewSystemSupports.Mode.BlackList, Collections.EMPTY_LIST);
                    HeartbeatIntervalSec heartbeatIntervalSec = new HeartbeatIntervalSec(5L, 30L);
                    YLKLive.this.env.onInitSysParams(newSystem, heartbeatIntervalSec);
                }

                @Override
                public void getFromService() {
                    OpGetMediaMeta.ForSystemParams forSystemParams = new OpGetMediaMeta.ForSystemParams(new OpGetMediaMeta.ForSystemParams.Completion(){

                        @Override
                        public void didGetSystemParams(NewSystemSupports supports, HeartbeatIntervalSec publisherHeartbeatIntervalSec) {
                            YLKLog.i(YLKLive.TAG, "didGetSystemParams: NewSystemSupports: " + supports);
                            YLKLive.this.env.onInitSysParams(supports, publisherHeartbeatIntervalSec);
                            YLKLog.i(YLKLive.TAG, YLKLive.this.env.heartbeatIntervalSec().toString());
                        }
                    });
                    Service.instance().launch(new OpGetMediaMeta(new Channel(0L), forSystemParams, new OpGetMediaMeta.Failure(){

                        @Override
                        public void didFailGettingMediaMeta() {
                            YLKLog.e(YLKLive.TAG, "didFailGettingMediaMeta - ForSystemParams");
                            this.getDefault();
                        }
                    }), null, (RetryStrategy)new RetryNone(Integer.MAX_VALUE));
                }
            });
            this.put(Env.InitConfig.MediaConfigUpdate, new GetConfigStrategy(){

                @Override
                public void getDefault() {
                    String viewerConfig = FileStorageUtils.getCache(Env.instance().context(), "viewerConfig");
                    boolean needUseDefault = false;
                    if (!FP.empty((CharSequence)viewerConfig)) {
                        try {
                            List<Integer> h264Thresholds = Collections.EMPTY_LIST;
                            List<Integer> h265Thresholds = Collections.EMPTY_LIST;
                            JSONObject vcObj = new JSONObject(viewerConfig);
                            JSONObject crldObj = vcObj.optJSONObject("codeRateLevelDefinition");
                            JSONObject h265dsObj = vcObj.optJSONObject("h265DecodeSupport");
                            if (crldObj != null) {
                                JSONObject h264Levels = crldObj.optJSONObject("h264");
                                JSONObject h265Levels = crldObj.optJSONObject("h265");
                                h264Thresholds = JsonUtils.parseCodeRateRange(h264Levels);
                                h265Thresholds = JsonUtils.parseCodeRateRange(h265Levels);
                            }
                            int h265Suport = h265dsObj != null ? h265dsObj.optInt("h265DecodeSupport", 0) : 0;
                            YLKLog.i(YLKLive.TAG, "didGetMediaConfigs cacheMediaConfig = " + viewerConfig);
                            YLKLive.this.env.onUpdateMediaConfig(new YLKMediaConfigs(h264Thresholds, h265Thresholds, h265Suport, Collections.EMPTY_MAP));
                        }
                        catch (Exception e) {
                            needUseDefault = true;
                        }
                    }
                    if (needUseDefault) {
                        YLKMediaConfigs defaultMediaConfig = VideoQualityCalc.getDefaultMediaConfigs();
                        final int h264DecodeType = defaultMediaConfig.isH264HardwareDecodeAvailable() ? 1 : 0;
                        final int h265DecodeType = defaultMediaConfig.isH265HardwareDecodeAvailable() ? 1 : 0;
                        YLKLog.i(YLKLive.TAG, "didGetMediaConfigs defaultMediaConfig = [" + defaultMediaConfig + "]");
                        IMediaVideo media = IMediaVideoSDK.instance().getMedia();
                        media.setConfigs(0, (Map)new HashMap<Integer, Integer>(){
                            {
                                this.put(316, h265DecodeType);
                                this.put(302, h264DecodeType);
                            }
                        });
                        YLKLive.this.env.onUpdateMediaConfig(defaultMediaConfig);
                    }
                }

                @Override
                public void getFromService() {
                    OpGetMediaMeta.ForViewerConfig forViewerConfig = new OpGetMediaMeta.ForViewerConfig(new OpGetMediaMeta.ForViewerConfig.Completion(){

                        @Override
                        public void didGetMediaConfigs(String orginal, YLKMediaConfigs liveRoomParams) {
                            if (!FP.empty((CharSequence)orginal)) {
                                FileStorageUtils.setCache(orginal, Env.instance().context(), "viewerConfig", 0);
                            }
                            YLKLog.i(YLKLive.TAG, "didGetMediaConfigs liveRoomParams = [" + liveRoomParams + "]");
                            final int h264DecodeType = liveRoomParams.isH264HardwareDecodeAvailable() ? 1 : 0;
                            final int h265DecodeType = liveRoomParams.isH265HardwareDecodeAvailable() ? 1 : 0;
                            YLKLive.this.media.setConfigs(0, (Map)new HashMap<Integer, Integer>(){
                                {
                                    if (!Env.instance().isCustomerSetH265HwEnable()) {
                                        this.put(316, h265DecodeType);
                                    }
                                    if (!Env.instance().isCustomerSetH264HwEnable()) {
                                        this.put(302, h264DecodeType);
                                    }
                                }
                            });
                            YLKLive.this.env.onUpdateMediaConfig(liveRoomParams);
                        }
                    });
                    Service.instance().launch(new OpGetMediaMeta(new Channel(0L), forViewerConfig, new OpGetMediaMeta.Failure(){

                        @Override
                        public void didFailGettingMediaMeta() {
                            this.getDefault();
                        }
                    }), null, (RetryStrategy)new RetryNone(Integer.MAX_VALUE));
                }
            });
        }
    };
    private Env env;
    private long uid = 0L;
    private Channel channel;
    private String channelSource;
    private State state = State.Idle;
    private List<LiveChangeEventHandler> liveChangeEventHandlers = null;
    private AtomicReference<Context> contextRef = new AtomicReference();
    private final IMediaVideo media = IMediaVideoSDK.instance().getMedia();
    private final Cleanup cleanups = new Cleanup(this.getClass().getSimpleName());
    private final Set<LiveEventHandler> handlers;
    private final AtomicInteger joinCount = new AtomicInteger(0);
    private static volatile YLKLive sharedInstance;
    private Handler joinHandler = new Handler(Looper.getMainLooper());
    private Runnable joinTask;
    private YLKLog.Logger logger;
    private String sdkLogPath;
    private Map<Integer, Integer> mediaConfigCache = new HashMap<Integer, Integer>();
    private List<MediaMsgEventHandler> msgEventHandlers = new CopyOnWriteArrayList<MediaMsgEventHandler>();
    private volatile boolean isLogined = false;
    private volatile int svcState = 0;
    private Map<String, String> abtest = new HashMap<String, String>();

    public void registerMediaEventHandler(MediaMsgEventHandler handler) {
        this.msgEventHandlers.add(handler);
    }

    public void unRegisterMediaEventHandler(MediaMsgEventHandler handler) {
        this.msgEventHandlers.remove(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addEventHandler(LiveEventHandler handler) {
        Assert.assertNotNull((Object)handler);
        Set<LiveEventHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeEventHandler(LiveEventHandler handler) {
        Set<LiveEventHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(handler);
        }
        return 0;
    }

    public String getVersion() {
        return "1.11.4_vv-SNAPSHOT";
    }

    public State getState() {
        return this.state;
    }

    public int getSvcState() {
        return this.svcState;
    }

    public int join(long uid, long top, long sub, String json) {
        YLKLog.i(TAG, "joinWithJson uid = [" + uid + "], top = [" + top + "], sub = [" + sub + "], json = [" + json + "]");
        Assert.assertNotNull((String)"Params json must not nil", (Object)json);
        if (this.state != State.Idle) {
            return 1;
        }
        this.uid = uid;
        this.channelSource = json;
        this.channel = new Channel(top, sub, true);
        this.cleanups.push("reset (uid, channel)", new Runnable(){

            @Override
            public void run() {
                YLKLive.this.channel = null;
                YLKLive.this.uid = 0L;
                YLKLive.this.channelSource = null;
            }
        });
        this.start();
        return 0;
    }

    public int join(final long uid, final long topCid, final long subCid) {
        if (!Env.isReady()) {
            YLKLog.e(TAG, "join failed service not ready!");
            YLKLog.e(TAG, "join failed uid:" + uid + ",topCid:" + topCid + ",subCid:" + subCid);
            if (this.joinCount.getAndIncrement() > 3) {
                this.iterateEventHandlers(new EventHandlerVisitor(){

                    @Override
                    public void visit(LiveEventHandler handler) {
                        handler.onJoinFailed(3, "service not ready");
                    }
                });
            } else {
                this.joinTask = new Runnable(){

                    @Override
                    public void run() {
                        YLKLog.e(YLKLive.TAG, "YLKLive join retry!");
                        YLKLive.this.join(uid, topCid, subCid);
                    }
                };
                this.joinHandler.postDelayed(this.joinTask, 500L);
                this.cleanups.push("CleanJoin", new Runnable(){

                    @Override
                    public void run() {
                        YLKLive.this.joinHandler.removeCallbacks(YLKLive.this.joinTask);
                    }
                });
            }
            return 3;
        }
        this.joinCount.set(0);
        this.uid = uid;
        this.channel = subCid == 0L ? new Channel(topCid) : new Channel(topCid, subCid);
        this.cleanups.push("reset (uid, channel)", new Runnable(){

            @Override
            public void run() {
                YLKLive.this.channel = null;
                YLKLive.this.uid = 0L;
                YLKLive.this.channelSource = null;
            }
        });
        this.start();
        return 0;
    }

    private void start() {
        YLKLog.i(TAG, "YLKLive joinStart sdk version: 1.11.4_vv-SNAPSHOT");
        this.changeState(State.Pending);
        this.media.switchToLiveSystem(true);
        this.joinMedia();
    }

    private void joinMedia() {
        YLKLog.i(TAG, "YLKLive joinMedia channel:" + this.channel);
        this.media.join(this.channel.top, this.channel.sub);
        this.cleanups.push("leaveMedia", new Runnable(){

            @Override
            public void run() {
                YLKLive.this.media.leave();
            }
        });
        this.iterateEventHandlers(new EventHandlerVisitor(){

            @Override
            public void visit(LiveEventHandler handler) {
                handler.onJoinSuccess(YLKLive.this.channel);
            }
        });
        this.cleanups.push("onLeave", new Runnable(){

            @Override
            public void run() {
                YLKLive.this.iterateEventHandlers(new EventHandlerVisitor(){

                    @Override
                    public void visit(LiveEventHandler handler) {
                        handler.onLeave();
                    }
                });
                YLKLive.this.uid = 0L;
                YLKLive.this.channel = null;
                YLKLive.this.channelSource = null;
            }
        });
        this.changeState(State.Joined);
    }

    public int setClientRole(ClientRole role) {
        return this.setClientRole(role, true);
    }

    public int setClientRole(ClientRole role, boolean updateImmediate) {
        YLKLog.i(TAG, "YLKLive setClientRole role: " + (Object)((Object)role) + ",updateImmediate:" + updateImmediate);
        Env.instance().setRole(role);
        if (this.liveChangeEventHandlers != null) {
            for (LiveChangeEventHandler handler : this.liveChangeEventHandlers) {
                handler.roleChanged(role, updateImmediate);
            }
        }
        return 0;
    }

    public int leave() {
        YLKLog.i(TAG, "YLKLive leave");
        this.performCleaning(null);
        return 0;
    }

    public int forbiddenTalking(long uid, boolean isForbidden) {
        if (uid == 0L) {
            return 1;
        }
        YLKLog.i(TAG, "YLKLive forbiddenTalking:" + uid + ",isForbidden:" + isForbidden);
        int enable = isForbidden ? 0 : 1;
        this.media.muteAudioByUid(uid, enable);
        return 0;
    }

    public int setMute(boolean enable) {
        YLKLog.i(TAG, "YLKLive setMute:" + enable);
        this.media.switchVoice(enable);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YLKLive instance() {
        if (sharedInstance != null) return sharedInstance;
        Class<YLKLive> clazz = YLKLive.class;
        synchronized (YLKLive.class) {
            if (sharedInstance != null) return sharedInstance;
            sharedInstance = new YLKLive();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sharedInstance;
        }
    }

    public void addLiveChangeEventHandler(LiveChangeEventHandler liveChangeEventHandler) {
        if (FP.empty(this.liveChangeEventHandlers)) {
            this.liveChangeEventHandlers = new ArrayList<LiveChangeEventHandler>();
        }
        this.liveChangeEventHandlers.add(liveChangeEventHandler);
    }

    public void removeLiveChangeEventHandler(LiveChangeEventHandler liveChangeEventHandler) {
        if (!FP.empty(this.liveChangeEventHandlers)) {
            this.liveChangeEventHandlers.remove(liveChangeEventHandler);
        }
    }

    public void setConfigs(int appId, Map<Integer, Integer> configs) {
        this.media.setConfigs(appId, configs);
    }

    public int getConfig(int configKey) {
        return this.media.getConfig(configKey);
    }

    public void setAbtest(String abtestKey, String abtestValue) {
        YLKLog.i(TAG, "setAbtest abtestKey : " + abtestKey + "," + abtestValue);
        this.abtest.put(abtestKey, abtestValue);
    }

    public String getAbtestVideoQuality() {
        String abtestValue = this.abtest.get("videoQuality");
        return FP.empty((CharSequence)abtestValue) ? "" : abtestValue;
    }

    public int init(Context context, AppNames names, String configsVersion, AppIDSet appIDs, String libPath, String logPath) {
        YLKLog.d(TAG, "YLKLive init begin>>>>");
        if (this.contextRef.get() != null) {
            return 1;
        }
        if (!NetworkUtils.isNetworkAvailable(context)) {
            YLKLog.e(TAG, "network is unAvailable");
        }
        this.contextRef.set(context.getApplicationContext());
        this.env = Env.instance();
        this.env.init(context, names, configsVersion, appIDs);
        this.sdkLogPath = YLKLive.getSdkLogPath(context, logPath);
        YLKLog.i(TAG, "YLKLive initSdk version: 1.11.4_vv-SNAPSHOT");
        this.initYYMobileFramework();
        this.setupLoginWatcher();
        this.initProtoSDK(libPath);
        this.initMediaTrans();
        this.deInitHandler = new YYHandler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                for (MediaMsgEventHandler handler : YLKLive.this.msgEventHandlers) {
                    handler.handleMessage(msg);
                }
                if (msg.what == 135) {
                    YLKLog.i(YLKLive.TAG, "onUninstallSDK onDeInit");
                    MediaVideoMsg.UninstallSDK uninstallSDK = (MediaVideoMsg.UninstallSDK)msg.obj;
                    if (uninstallSDK != null) {
                        YLKLive.this.mediaConfigCache = uninstallSDK.appConfigs;
                        YLKLog.i(YLKLive.TAG, "onUninstallSDK() onDeInit mediaConfigCache = [" + YLKLive.this.mediaConfigCache + "]");
                    }
                    YLKLive.this.deInitEventHandler.onDeInit();
                }
            }
        };
        this.media.addMsgHandler((Handler)this.deInitHandler);
        YYHandlerMgr.instance().add(new YYHandler(Looper.getMainLooper()){

            @YYHandler.MessageHandler(message=3)
            public void onChannelState(SvcEvent.ETSvcChannelState evt) {
                YLKLive.this.svcState = evt.state;
                if (evt.state == 2) {
                    YLKLive.this.registerServiceAppIDs();
                    if (YLKLive.this.isLogined) {
                        YLKLive.this.initConfig(false);
                    }
                    if (!FP.empty((Collection)YLKLive.this.liveChangeEventHandlers)) {
                        for (LiveChangeEventHandler handler : YLKLive.this.liveChangeEventHandlers) {
                            handler.svcStateReady();
                        }
                    }
                    YLKLog.i(YLKLive.TAG, "Env onChannelState \u5b8c\u6210\u521d\u59cb\u5316");
                }
            }
        });
        this.initConfig(true);
        YLKLog.d(TAG, "YLKLive init finish!!!!!!");
        return 0;
    }

    public void setExtraExcutor(ExecutorService extraExcutor) {
        Service.instance().setExtraExecutor(extraExcutor);
    }

    void setAppIds(AppIDSet appIds) {
        YLKLog.i(TAG, "setAppIds appIds = [" + appIds + "]");
        this.unRegisterServiceAppIDs();
        this.env.setAppIDs(appIds);
        this.registerServiceAppIDs();
        this.media.liveSetAppInfo(appIds.ent, appIds.sceneId);
    }

    AppIDSet getAppIDSet() {
        return this.env.appIDs();
    }

    AppNames getAppNames() {
        return this.env.names();
    }

    private void initConfig(boolean isDefault) {
        for (Map.Entry<Env.InitConfig, GetConfigStrategy> entry : this.configs.entrySet()) {
            GetConfigStrategy configStrategy = entry.getValue();
            if (isDefault) {
                configStrategy.getDefault();
                continue;
            }
            configStrategy.getFromService();
        }
    }

    private void initYYMobileFramework() {
        if (YYApp.getInstance() == null) {
            new YYApp(this.contextRef.get(), null, Boolean.valueOf(true)).start();
        }
        YLKLog.d(TAG, "initYYMobileFramework() called");
    }

    private void initMediaTrans() {
        YLKLog.d(TAG, "initMediaTrans init begin");
        IMediaVideo media = IMediaVideoSDK.instance().getMedia();
        media.init(this.contextRef.get(), new SDKParam.AppInfo(){
            {
                this.appname = ((YLKLive)YLKLive.this).env.names().business.getBytes();
                this.appVer = RuntimeKit.appVersion((Context)YLKLive.this.contextRef.get()).getBytes();
                this.logLevel = 1;
                this.logPath = YLKLive.this.sdkLogPath.getBytes();
                this.libPath = null;
            }
        });
        media.setConfigs(0, (Map)new HashMap<Integer, Integer>(){
            {
                this.put(305, ((YLKLive)YLKLive.this).env.appIDs().ent);
                this.put(334, 1);
                this.put(309, 0);
                this.put(101, 1500);
                this.put(201, 1500);
                this.put(208, 1);
                this.put(320, 1);
                this.put(316, 0);
                this.put(333, 1);
            }
        });
        media.liveSetAppInfo(this.env.appIDs().ent, this.env.appIDs().sceneId);
        YLKLog.i(TAG, "YLKLive init switchToLiveSystem");
        media.switchToLiveSystem(true);
        YLKLog.d(TAG, "initMediaTrans init finish");
    }

    void reInitMediaTrans() {
        this.initMediaTrans();
        YLKLog.i(TAG, "reInitMediaTrans mediaConfigCache=" + this.mediaConfigCache);
        if (!FP.empty(this.mediaConfigCache)) {
            this.media.setConfigs(0, this.mediaConfigCache);
        }
        this.media.addMsgHandler((Handler)this.deInitHandler);
    }

    void deInitMediaTrans() {
        this.media.removeMsgHandler((Handler)this.deInitHandler);
        this.performCleaning(null);
        this.media.deInit();
    }

    void enterBackground() {
        this.media.onAppBackground(true);
    }

    void enterForeground() {
        this.media.onAppBackground(false);
    }

    void setDeInitEventHandler(YLKEngine.DeInitEventHandler handler) {
        this.deInitEventHandler = handler;
    }

    private void setupLoginWatcher() {
        IProtoMgr.instance().getLogin().watch(new IWatcher(){

            public void onEvent(ProtoEvent evt) {
                if (evt.modType() == 0 && evt.eventType() == 40) {
                    LoginEvent.LoginResNGEvent rsp = (LoginEvent.LoginResNGEvent)evt;
                    YLKLog.i(YLKLive.TAG, "setupLoginWatcher login uSrvResCode = [" + rsp.uSrvResCode + "]");
                    if (rsp.uSrvResCode == 200) {
                        YLKLive.this.isLogined = true;
                        YLKLive.this.initConfig(false);
                    }
                }
            }
        });
    }

    private void initProtoSDK(String libPath) {
        YLKLog.d(TAG, "initProtoSDK init begin");
        SDKParam.AppInfo appInfo = new SDKParam.AppInfo();
        appInfo.appname = this.env.names().business.getBytes();
        appInfo.appVer = RuntimeKit.appVersion(this.contextRef.get()).getBytes();
        appInfo.logPath = this.sdkLogPath.getBytes();
        appInfo.libPath = libPath.getBytes();
        appInfo.type2Icon.put(1, (Object)"4095".getBytes());
        appInfo.type2Icon.put(2, (Object)"4092".getBytes());
        IProtoMgr.instance().init(this.contextRef.get(), appInfo);
        IProtoMgr.instance().getLogin().watch((IWatcher)YYHandlerMgr.instance());
        IProtoMgr.instance().getSess().watch((ISessWatcher)YYHandlerMgr.instance());
        IProtoMgr.instance().getSvc().watch((IWatcher)YYHandlerMgr.instance());
        IProtoMgr.instance().getReport().watch((IWatcher)YYHandlerMgr.instance());
        Service.instance();
        YLKLog.d(TAG, "initProtoSDK init finish");
    }

    private void registerServiceAppIDs() {
        HashSet<Integer> IDSet = new HashSet<Integer>(){
            {
                this.add(10588);
            }
        };
        int[] IDs = ArrayUtils.toPrimitive(IDSet.toArray(new Integer[0]));
        YLKLog.i(TAG, "registerServiceAppIDs called:" + FP.toList((Collection)IDSet));
        try {
            SvcRequest.SvcSubscribeReq request = new SvcRequest.SvcSubscribeReq(IDs);
            IProtoMgr.instance().getSvc().sendRequest((ProtoReq)request);
        }
        catch (Exception e) {
            YLKLog.e(TAG, "Service Subscribe RES_ERROR " + e);
        }
    }

    private void unRegisterServiceAppIDs() {
        HashSet<Integer> IDSet = new HashSet<Integer>(){
            {
                this.add(10588);
            }
        };
        int[] IDs = ArrayUtils.toPrimitive(IDSet.toArray(new Integer[0]));
        YLKLog.i(TAG, "unRegisterServiceAppIDs IDSet:" + FP.toList((Collection)IDSet));
        try {
            SvcRequest.SvcCancelSubscribeReq request = new SvcRequest.SvcCancelSubscribeReq(IDs);
            IProtoMgr.instance().getSvc().sendRequest((ProtoReq)request);
        }
        catch (Throwable e) {
            YLKLog.e(TAG, "Service unSubscribe Throwable:" + e);
        }
    }

    private static String getSdkLogPath(Context context, String path) {
        if (FP.empty((CharSequence)path)) {
            return context.getCacheDir().getPath() + File.separator + "yysdklog";
        }
        return path;
    }

    public String getChannelSource() {
        return FP.empty((CharSequence)this.channelSource) ? null : new String(this.channelSource);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public long getUid() {
        return this.uid;
    }

    private void performCleaning(Cleanup.FlushCallback flushCallback) {
        this.cleanups.flush(flushCallback);
        this.changeState(State.Idle);
        this.joinCount.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateEventHandlers(final EventHandlerVisitor visitor) {
        YLKLog.i(TAG, "iterateEventHandlers handlers = [" + FP.size(this.handlers) + "]");
        Set<LiveEventHandler> set = this.handlers;
        synchronized (set) {
            for (final LiveEventHandler handler : this.handlers) {
                RunInMain.dispatch(new Runnable(){

                    @Override
                    public void run() {
                        visitor.visit(handler);
                    }
                });
            }
        }
    }

    private void changeState(State next) {
        if (this.state == next) {
            return;
        }
        YLKLog.i(TAG, "YLKLive changeState:" + (Object)((Object)this.state) + " -> " + (Object)((Object)next));
        this.state = next;
    }

    public YLKLog.Logger getLogger() {
        if (this.logger == null) {
            this.logger = new YLKLog.Logger();
        }
        return this.logger;
    }

    private void initMediaLogger() {
        com.duowan.mobile.utils.YLog.registerLogger((Object)this.getLogger());
        YLog.registerLogger((Object)this.getLogger());
        YMFLog.registerLogger((Object)this.getLogger());
    }

    private YLKLive() {
        this.setClientRole(ClientRole.Audience);
        this.handlers = new HashSet<LiveEventHandler>();
        this.initMediaLogger();
    }

    private static interface GetConfigStrategy {
        public void getDefault();

        public void getFromService();
    }

    private static interface EventHandlerVisitor {
        public void visit(LiveEventHandler var1);
    }

    public static interface LiveChangeEventHandler {
        public void roleChanged(ClientRole var1, boolean var2);

        public void svcStateReady();
    }

    public static enum State {
        Idle,
        Pending,
        Joined;

    }

    public static interface MediaMsgEventHandler {
        public void handleMessage(Message var1);
    }

    public static interface AbTestKey {
        public static final String VideoQuality = "videoQuality";
    }
}

