/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience;

import com.duowan.mobile.mediaproxy.MediaInvoke;
import com.medialib.video.MediaVideoMsg;
import com.yy.yylivekit.audience.Transfers;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.Aliases;
import com.yy.yylivekit.model.AudioInfo;
import com.yy.yylivekit.model.GroupInfo;
import com.yy.yylivekit.model.StreamInfo;
import com.yy.yylivekit.model.VideoInfo;
import com.yy.yylivekit.trigger.PeriodicJob;
import com.yy.yylivekit.trigger.PeriodicTrigger;
import com.yy.yylivekit.trigger.TimerPulse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

enum SubscribHandler {
    instance;

    private static final String TAG = "SubscribHandler";
    private final PeriodicTrigger trigger = new PeriodicTrigger(new TimerPulse("SubscribHandler", 1000L));
    private Set<VideoInfo> videoCache = new CopyOnWriteArraySet<VideoInfo>();
    private Set<AudioInfo> audioCache = new CopyOnWriteArraySet<AudioInfo>();
    private Set<GroupInfo> groupCache = new CopyOnWriteArraySet<GroupInfo>();
    private Transfers trans = new Transfers.RapidTransfers();
    private boolean enableFastAccess = true;

    private <E> boolean didRemove(Set<E> cache, RemoveOption opt) {
        HashSet<E> wannerRemove = new HashSet<E>();
        for (E e : cache) {
            if (!opt.isNeedRemove(e)) continue;
            wannerRemove.add(e);
        }
        return cache.removeAll(wannerRemove);
    }

    public void switchTransmitters(Transfers newTrans) {
        Transfers oldTrans = SubscribHandler.instance.trans;
        if (oldTrans != null) {
            oldTrans.close();
        }
        SubscribHandler.instance.trans = newTrans;
        if (newTrans != null) {
            newTrans.open();
        }
        this.execute();
    }

    public SubscribHandler registerStream(final StreamInfo streamInfo) {
        YLKLog.i(TAG, "registerStream() called with: streamInfo = [" + streamInfo + "]");
        if (streamInfo != null && streamInfo.audio != null) {
            this.trigger.removeWithCondition(new PeriodicTrigger.Condition(){

                public boolean satisfy(PeriodicJob source) {
                    boolean isSataisfy = false;
                    if (source.parmas != null && source.parmas instanceof AudioInfo) {
                        isSataisfy = ((AudioInfo)source.parmas).isMix || ((AudioInfo)source.parmas).equals(streamInfo.audio);
                    }
                    return isSataisfy;
                }
            });
            this.didRemove(this.audioCache, new RemoveOption(){

                public boolean isNeedRemove(Object item) {
                    AudioInfo ai = (AudioInfo)item;
                    return ai.isMix;
                }
            });
        }
        if (streamInfo != null && streamInfo.video != null) {
            final VideoInfo videoInfo = streamInfo.video;
            this.didRemove(this.videoCache, new RemoveOption(){

                public boolean isNeedRemove(Object item) {
                    VideoInfo vi = (VideoInfo)item;
                    return vi.equals(videoInfo);
                }
            });
            this.videoCache.add(videoInfo);
        }
        if (streamInfo != null && streamInfo.audio != null) {
            final AudioInfo audioInfo = streamInfo.audio;
            this.didRemove(this.audioCache, new RemoveOption(){

                public boolean isNeedRemove(Object item) {
                    AudioInfo ai = (AudioInfo)item;
                    return ai.equals(audioInfo);
                }
            });
            this.audioCache.add(audioInfo);
        }
        return this;
    }

    public SubscribHandler unRegisterStream(StreamInfo streamInfo) {
        YLKLog.i(TAG, "unRegisterStream streamInfo = [" + streamInfo + "]");
        if (streamInfo != null && streamInfo.video != null) {
            final VideoInfo videoInfo = streamInfo.video;
            this.didRemove(this.videoCache, new RemoveOption(){

                public boolean isNeedRemove(Object item) {
                    VideoInfo vi = (VideoInfo)item;
                    return vi.equals(videoInfo);
                }
            });
        }
        if (streamInfo != null && streamInfo.audio != null) {
            if (this.audioCache.contains(streamInfo.audio)) {
                this.delayUnRegisterAudio(streamInfo.audio);
            } else {
                YLKLog.i(TAG, "unRegisterStream ignore delay option!!");
            }
        }
        return this;
    }

    private void delayUnRegisterAudio(AudioInfo audioInfo) {
        YLKLog.i(TAG, "delayUnRegisterAudio AudioInfo = [" + audioInfo + "]");
        int timeInterval = audioInfo.isMix ? 9000 : 2000;
        this.trigger.addJob(new PeriodicJob<AudioInfo>(timeInterval, audioInfo, new PeriodicJob.Action(){

            @Override
            public void onTrigger(final PeriodicJob job, PeriodicJob.Completion completion) {
                SubscribHandler.this.didRemove(SubscribHandler.this.audioCache, new RemoveOption(){

                    public boolean isNeedRemove(Object item) {
                        AudioInfo ai = (AudioInfo)item;
                        return ai.equals(job.parmas);
                    }
                });
                completion.onComplete(job, true);
                YLKLog.i(SubscribHandler.TAG, "onTrigger() execute with: job = [" + job + "]");
                SubscribHandler.this.execute();
            }
        }));
    }

    public SubscribHandler registerGroup(GroupInfo group) {
        YLKLog.i(TAG, "registerGroup | GroupInfo:" + group);
        if (group.type == 3) {
            this.trigger.removeWithCondition(new PeriodicTrigger.Condition(){

                public boolean satisfy(PeriodicJob source) {
                    boolean isSataisfy = false;
                    if (source.parmas != null && source.parmas instanceof AudioInfo) {
                        isSataisfy = ((AudioInfo)source.parmas).isMix;
                    }
                    return isSataisfy;
                }
            });
            this.didRemove(this.audioCache, new RemoveOption(){

                public boolean isNeedRemove(Object item) {
                    AudioInfo ai = (AudioInfo)item;
                    return ai.isMix;
                }
            });
        }
        this.groupCache.add(group);
        YLKLog.i(TAG, "registerGroup | groupCache:" + this.groupCache);
        return this;
    }

    public SubscribHandler unRegisterGroup(GroupInfo group) {
        YLKLog.i(TAG, "unRegisterGroup | GroupInfo:" + group);
        this.groupCache.remove(group);
        YLKLog.i(TAG, "unRegisterGroup | groupCache:" + this.groupCache);
        return this;
    }

    public SubscribHandler cleanStreams(final boolean needMix) {
        YLKLog.i(TAG, "cleanStreams() called with: neednMix = [" + needMix + "]");
        this.didRemove(this.videoCache, new RemoveOption(){

            public boolean isNeedRemove(Object item) {
                VideoInfo vi = (VideoInfo)item;
                return vi.isMix != needMix;
            }
        });
        this.didRemove(this.audioCache, new RemoveOption(){

            public boolean isNeedRemove(Object item) {
                AudioInfo ai = (AudioInfo)item;
                return ai.isMix != needMix;
            }
        });
        return this;
    }

    public SubscribHandler cleanStreams() {
        YLKLog.i(TAG, "cleanStreams clean All StreamInfo:");
        this.videoCache.clear();
        this.audioCache.clear();
        return this;
    }

    public SubscribHandler cleanGroups() {
        YLKLog.i(TAG, "cleanGroups clean All GroupInfo:");
        this.groupCache.clear();
        return this;
    }

    public void execute() {
        if (this.videoCache != null || this.audioCache != null || this.groupCache != null) {
            this.trans.getSubscriber().subscribe(this.playerStreams(), this.groupStreams());
        }
    }

    private Aliases.GroupInfoMap groupStreams() {
        Aliases.GroupInfoMap groupMap = new Aliases.GroupInfoMap();
        for (GroupInfo gi : this.groupCache) {
            ArrayList<MediaInvoke.LiveGroupInfo> infoList = (ArrayList<MediaInvoke.LiveGroupInfo>)groupMap.get(gi.appId);
            if (infoList == null) {
                infoList = new ArrayList<MediaInvoke.LiveGroupInfo>();
                groupMap.put(gi.appId, infoList);
            }
            final int type = gi.type;
            MediaInvoke.LiveGroupInfo lgi = new MediaInvoke.LiveGroupInfo(gi.name, (Map)new HashMap<Integer, Integer>(){
                {
                    if (type == 5) {
                        this.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_SID_BROADCAST_AUDIO, 1);
                    }
                }
            });
            infoList.add(lgi);
        }
        YLKLog.i(TAG, "SubscribHandler | groupStreams:" + groupMap);
        return groupMap;
    }

    private Aliases.StreamInfoMap playerStreams() {
        ArrayList<MediaInvoke.LiveStreamInfo> infoList;
        HashMap<String, AudioInfo> audios = new HashMap<String, AudioInfo>();
        HashMap<String, VideoInfo> videos = new HashMap<String, VideoInfo>();
        for (VideoInfo vi : this.videoCache) {
            if (vi == null) continue;
            vi.enableFastAccess(this.enableFastAccess);
            videos.put(vi.streamName, vi);
        }
        for (AudioInfo ai : this.audioCache) {
            if (ai == null) continue;
            ai.enableFastAccess(this.enableFastAccess);
            audios.put(ai.streamName, ai);
        }
        Aliases.StreamInfoMap streamsMap = new Aliases.StreamInfoMap();
        for (AudioInfo audio : audios.values()) {
            infoList = (ArrayList<MediaInvoke.LiveStreamInfo>)streamsMap.get(audio.appId);
            if (infoList == null) {
                infoList = new ArrayList<MediaInvoke.LiveStreamInfo>();
                streamsMap.put(audio.appId, infoList);
            }
            infoList.add(audio.liveStreamInfo());
        }
        for (VideoInfo video : videos.values()) {
            infoList = (ArrayList<MediaInvoke.LiveStreamInfo>)streamsMap.get(video.appId);
            if (infoList == null) {
                infoList = new ArrayList<MediaInvoke.LiveStreamInfo>();
                streamsMap.put(video.appId, infoList);
            }
            infoList.add(video.liveStreamInfo());
        }
        YLKLog.i(TAG, "SubscribHandler | playerStreams: (audio:" + audios + ", video:" + videos + ")");
        return streamsMap;
    }

    public void setEnableFastAccess(boolean enable) {
        YLKLog.i(TAG, "setEnableFastAccess() called with: enable = [" + enable + "]");
        this.enableFastAccess = enable;
    }

    public void startTrigger() {
        YLKLog.i(TAG, "startTrigger() called");
        this.trigger.start();
    }

    public void stopTrigger() {
        YLKLog.i(TAG, "stopTrigger() called");
        this.trigger.stop();
    }

    static interface RemoveOption<E> {
        public boolean isNeedRemove(E var1);
    }
}

