/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience;

import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.StreamInfo;
import com.yy.yylivekit.model.VideoGearInfo;
import com.yy.yylivekit.model.VideoInfo;
import com.yyproto.utils.FP;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class StreamInfoChangeHandler {
    private static final String TAG = "StreamInfoChangeHandler";
    private LiveInfo liveInfo;
    private VideoCodeRateListener mVideoCodeRateListener;

    public StreamInfoChangeHandler(LiveInfo liveInfo, VideoCodeRateListener videoCodeRateListener) {
        this.liveInfo = liveInfo;
        this.mVideoCodeRateListener = videoCodeRateListener;
    }

    public LiveInfo getLiveInfo() {
        return this.liveInfo;
    }

    public void sendVideoEncodeInfoChange(String streamName) {
        if (this.liveInfo != null && !FP.empty(this.liveInfo.streamInfoList)) {
            VideoInfo videoInfo = null;
            for (StreamInfo stream : this.liveInfo.streamInfoList) {
                if (stream.video == null || !stream.video.streamName.equals(streamName)) continue;
                videoInfo = stream.video;
                break;
            }
            YLKLog.i(TAG, "StreamInfoChangeHandler sendVideoEncodeSizeChange: videoInfo=" + videoInfo);
            if (videoInfo != null && this.mVideoCodeRateListener != null) {
                this.mVideoCodeRateListener.onVideoEncodeInfoChange(this.liveInfo, videoInfo.width, videoInfo.height, videoInfo.encode);
            } else {
                YLKLog.e(TAG, "StreamInfoChangeHandler sendVideoEncodeSizeChange videoCodeRateListener / videoInfo is nil!");
            }
        }
    }

    public void sendVideoCodeRateList() {
        if (this.liveInfo != null && !FP.empty(this.liveInfo.streamInfoList)) {
            HashMap<VideoGearInfo, Integer> codeRateList = new HashMap<VideoGearInfo, Integer>();
            Set<Map.Entry<VideoGearInfo, StreamInfo>> entrySet = this.liveInfo.streamsForCurrentProperties().entrySet();
            for (Map.Entry<VideoGearInfo, StreamInfo> entry : entrySet) {
                VideoGearInfo videoQuality = entry.getKey();
                StreamInfo streamInfo = entry.getValue();
                if (streamInfo.video == null) continue;
                codeRateList.put(videoQuality, streamInfo.video.codeRate);
            }
            YLKLog.i(TAG, "StreamInfoChangeHandler sendVideoCodeRateList:" + codeRateList);
            if (this.mVideoCodeRateListener != null) {
                TreeMap<VideoGearInfo, Integer> sortCodeRateList = new TreeMap<VideoGearInfo, Integer>(new Comparator<VideoGearInfo>(){

                    @Override
                    public int compare(VideoGearInfo obj1, VideoGearInfo obj2) {
                        return obj1.seq - obj2.seq;
                    }
                });
                this.mVideoCodeRateListener.onVideoCodeRateList(this.liveInfo, sortCodeRateList);
            } else {
                YLKLog.e(TAG, "StreamInfoChangeHandler sendVideoCodeRateList videoCodeRateListener is nil!");
            }
        }
    }

    public void sendVideoCodeRateChange(String streamName) {
        if (this.liveInfo != null && !FP.empty(this.liveInfo.streamInfoList)) {
            VideoInfo videoInfo = null;
            for (StreamInfo stream : this.liveInfo.streamInfoList) {
                if (stream.video == null || !stream.video.streamName.equals(streamName)) continue;
                videoInfo = stream.video;
                break;
            }
            YLKLog.i(TAG, "StreamInfoChangeHandler sendVideoCodeRateChange: videoInfo=" + videoInfo);
            if (videoInfo != null && this.mVideoCodeRateListener != null) {
                this.mVideoCodeRateListener.onVideoCodeRateChange(this.liveInfo, videoInfo.videoGearInfo, videoInfo.codeRate);
            } else {
                YLKLog.e(TAG, "StreamInfoChangeHandler sendVideoCodeRateChange videoCodeRateListener / videoInfo is nil!");
            }
        }
    }

    static interface VideoCodeRateListener {
        public void onVideoCodeRateList(LiveInfo var1, Map<VideoGearInfo, Integer> var2);

        public void onVideoCodeRateChange(LiveInfo var1, VideoGearInfo var2, Integer var3);

        public void onVideoEncodeInfoChange(LiveInfo var1, int var2, int var3, int var4);
    }
}

