/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience.services;

import android.os.Build;
import android.util.DisplayMetrics;
import com.duowan.mobile.utils.FP;
import com.google.protobuf.nano.MessageNano;
import com.yy.IMediaVideoSDK;
import com.yy.livekit.protocol.nano.StreamCliMsg2C;
import com.yy.videoplayer.decoder.GLVersionUtils;
import com.yy.yylivekit.Env;
import com.yy.yylivekit.YLKLive;
import com.yy.yylivekit.audience.monitor.AcceptanceRulesV2;
import com.yy.yylivekit.audience.monitor.LiveInfoFactoryV2;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.Channel;
import com.yy.yylivekit.model.GroupInfo;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.TransConfig;
import com.yy.yylivekit.services.Service;
import com.yy.yylivekit.services.core.Pack;
import com.yy.yylivekit.services.core.Unpack;
import com.yy.yylivekit.utils.MessageUtils;
import com.yy.yylivekit.utils.MetaDataFactoryV2;
import com.yy.yylivekit.utils.RuntimeKit;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpQueryStreamInfoV2
implements Service.Operation {
    private final long uid;
    private final Channel channel;
    private final boolean wantsH265Streams;
    private final Completion completion;
    private final boolean needReqAvp;

    public OpQueryStreamInfoV2(long uid, Channel channel, boolean needReqAvp, boolean wantsH265Streams, Completion completion) {
        this.wantsH265Streams = wantsH265Streams;
        this.uid = uid;
        this.channel = channel;
        this.needReqAvp = needReqAvp;
        this.completion = completion;
    }

    @Override
    public int serviceType() {
        return 10588;
    }

    @Override
    public int serviceNumber() {
        return 9701;
    }

    @Override
    public int jobNumber() {
        return 3;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public Service.Operation.PackType type() {
        return Service.Operation.PackType.Normal;
    }

    @Override
    public void packRequest(Pack pack) {
        long seq = System.currentTimeMillis();
        YLKLog.i("YLK", "OpQueryStreamInfoV2 uid:" + this.uid + ",needReqAvp:" + this.needReqAvp + ",seq:" + seq + ",channel:" + this.channel + ",hash:" + this.hashCode());
        StreamCliMsg2C.ChannelStreamsQueryRequest streamsQueryRequest = new StreamCliMsg2C.ChannelStreamsQueryRequest();
        streamsQueryRequest.appid = Env.instance().appIDs().ent;
        streamsQueryRequest.uid = (int)this.uid;
        streamsQueryRequest.cid = (int)(this.channel != null ? this.channel.top : 0L);
        streamsQueryRequest.sid = (int)(this.channel != null ? this.channel.sub : 0L);
        streamsQueryRequest.businessid = Env.instance().appIDs().sceneId;
        streamsQueryRequest.sequence = seq;
        StreamCliMsg2C.ClientAttribute clientAttribute = new StreamCliMsg2C.ClientAttribute();
        DisplayMetrics dm = Env.instance().context().getResources().getDisplayMetrics();
        String width = "" + Math.min(dm.widthPixels, dm.heightPixels);
        String height = "" + Math.max(dm.widthPixels, dm.heightPixels);
        String appVersion = RuntimeKit.appVersion(Env.instance().context());
        String vsdkVersion = "" + IMediaVideoSDK.instance().getMedia().liveGetSdkVersion();
        clientAttribute.client = "mobile";
        clientAttribute.model = Build.MODEL;
        clientAttribute.os = "android";
        clientAttribute.osversion = Build.VERSION.SDK;
        clientAttribute.vsdkVersion = vsdkVersion;
        clientAttribute.appIdentify = Env.instance().names().business;
        clientAttribute.appVersion = appVersion;
        clientAttribute.business = "" + Env.instance().appIDs().sceneId;
        clientAttribute.width = width;
        clientAttribute.height = height;
        clientAttribute.clientType = 2;
        clientAttribute.h265 = this.wantsH265Streams ? 1 : 0;
        clientAttribute.cpu = Build.HARDWARE;
        clientAttribute.graphicsCard = "" + GLVersionUtils.getGlVersion();
        clientAttribute.cpuFrequency = "" + RuntimeKit.getCurCPU();
        clientAttribute.deviceMemory = "" + RuntimeKit.getTotalRam(Env.instance().context()) + "B";
        clientAttribute.abtest = "" + YLKLive.instance().getAbtestVideoQuality();
        if (this.needReqAvp) {
            StreamCliMsg2C.AvpParameter avpParameter = new StreamCliMsg2C.AvpParameter();
            int sendTime = (int)System.currentTimeMillis() / 1000;
            int sdkVersion = (int)IMediaVideoSDK.instance().getMedia().liveGetSdkVersion();
            int transVersion = (int)IMediaVideoSDK.instance().getMedia().liveGetTransVersion();
            int roomId = (int)(this.channel != null ? this.channel.sub : 0L);
            avpParameter.version = 1;
            avpParameter.uid = (int)this.uid;
            avpParameter.roomId = roomId;
            avpParameter.clientType = 2;
            avpParameter.sendTime = sendTime;
            avpParameter.clientAppid = Env.instance().appIDs().ent;
            avpParameter.sdkVersion = sdkVersion;
            avpParameter.transVersion = transVersion;
            avpParameter.lineSeq = -1;
            avpParameter.gear = -1;
            streamsQueryRequest.avpParameter = avpParameter;
        } else {
            streamsQueryRequest.avpParameter = null;
        }
        streamsQueryRequest.clientAttribute = clientAttribute;
        byte[] bytes = MessageNano.toByteArray((MessageNano)streamsQueryRequest);
        pack.pushNoTag(bytes);
        YLKLog.i("YLK", "OpQueryStreamInfoV2 did pack request hash:" + this.hashCode() + "\uff0cclientAttribute=" + MessageUtils.printClientAttribute(clientAttribute));
    }

    @Override
    public void processResponse(int responseNumber, Unpack unpack) {
        long version;
        YLKLog.i("YLK", "OpQueryStreamInfoV2 will process response hash:" + this.hashCode());
        StreamCliMsg2C.ChannelStreamsQueryResponse streamsQueryResponse = new StreamCliMsg2C.ChannelStreamsQueryResponse();
        byte[] bytes = unpack.toArray();
        try {
            MessageNano.mergeFrom((MessageNano)streamsQueryResponse, (byte[])bytes);
        }
        catch (Throwable e) {
            YLKLog.e("YLK", "OpQueryStreamInfoV2 Throwable:" + e);
        }
        if (streamsQueryResponse == null) {
            YLKLog.e("YLK", "OpQueryStreamInfoV2 streamsQueryResponse null");
            return;
        }
        if (streamsQueryResponse.channelStreamInfo == null) {
            streamsQueryResponse.channelStreamInfo = new StreamCliMsg2C.ChannelStreamInfo();
        }
        Env.instance().currentStreamVersion = version = streamsQueryResponse.channelStreamInfo.version;
        String info = MessageUtils.printStreams(streamsQueryResponse.channelStreamInfo.streams);
        YLKLog.i("YLK", "OpQueryStreamInfoV2 seq:" + streamsQueryResponse.sequence + ",version:" + version + ",hash:" + this.hashCode() + ",info:" + info);
        AcceptanceRulesV2 acceptanceRules = this.makeAcceptanceRules(streamsQueryResponse.clientCapacity);
        byte[] avpInfo = null;
        if (streamsQueryResponse.avpPayload != null) {
            avpInfo = streamsQueryResponse.avpPayload.data;
            YLKLog.i("YLK", "OpQueryStreamInfoV2 avpPayload data=" + avpInfo);
        } else {
            YLKLog.i("YLK", "OpQueryStreamInfoV2 avpPayload is nil");
        }
        Map<String, Object> retDataMap = LiveInfoFactoryV2.make(acceptanceRules, streamsQueryResponse.channelStreamInfo);
        Map<Long, Map<Short, Long>> metaDataMap = MetaDataFactoryV2.make(streamsQueryResponse.channelStreamInfo);
        YLKLog.i("YLK", "OpQueryStreamInfoV2 LiveInfoFactoryV2 make end hash:" + this.hashCode());
        this.completion.didQueryStreamInfo(avpInfo, ((Object)((Object)streamsQueryResponse)).hashCode(), this.channel, acceptanceRules, (List)retDataMap.get("AnchorStream"), (Set)retDataMap.get("AudienceStream"), (List)retDataMap.get("GroupInfo"), metaDataMap, (Set)retDataMap.get("TransConfig"));
    }

    private AcceptanceRulesV2 makeAcceptanceRules(StreamCliMsg2C.ClientCapacity clientCapacity) {
        if (clientCapacity == null || FP.empty((Object[])clientCapacity.streamVisibilityRules)) {
            return AcceptanceRulesV2.bypassingRules(this.uid);
        }
        AcceptanceRulesV2 rules = new AcceptanceRulesV2(clientCapacity.streamVisibilityRules, this.uid);
        YLKLog.i("YLK", "OpQueryStreamInfoV2 AcceptanceRules rulesObj:" + rules);
        return rules;
    }

    public static interface Completion {
        public void didQueryStreamInfo(byte[] var1, long var2, Channel var4, AcceptanceRulesV2 var5, List<LiveInfo> var6, Set<LiveInfo> var7, List<GroupInfo> var8, Map<Long, Map<Short, Long>> var9, Set<TransConfig> var10);
    }
}

