/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience.services;

import com.google.protobuf.nano.MessageNano;
import com.yy.livekit.protocol.nano.StreamCliMsg2C;
import com.yy.yylivekit.Env;
import com.yy.yylivekit.YLKLive;
import com.yy.yylivekit.audience.monitor.AcceptanceRulesV2;
import com.yy.yylivekit.audience.monitor.LiveInfoFactoryV2;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.Channel;
import com.yy.yylivekit.model.GroupInfo;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.TransConfig;
import com.yy.yylivekit.services.Service;
import com.yy.yylivekit.services.core.Uint32;
import com.yy.yylivekit.services.core.Unpack;
import com.yy.yylivekit.threading.RunInMain;
import com.yy.yylivekit.utils.MessageUtils;
import com.yy.yylivekit.utils.MetaDataFactoryV2;
import com.yyproto.utils.FP;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;

public class OnStreamsBroadcastingV2
implements Service.Broadcast {
    private static final String TAG = "OnStreamsBroadcastingV2";
    private final AcceptanceRulesV2 acceptanceRules;
    private final Callback callback;

    public OnStreamsBroadcastingV2(AcceptanceRulesV2 rules, Callback callback) {
        Assert.assertNotNull((String)"Generate OnStreamsChanged callback should not null", (Object)callback);
        this.acceptanceRules = rules;
        this.callback = callback;
    }

    @Override
    public int serviceType() {
        return 10588;
    }

    @Override
    public int serviceNumber() {
        return 9701;
    }

    @Override
    public int jobNumber() {
        return 1;
    }

    @Override
    public void process(Unpack unpack) {
        final StreamCliMsg2C.StreamManagerNotifyMessage notifyMessage = new StreamCliMsg2C.StreamManagerNotifyMessage();
        byte[] bytes = unpack.toArray();
        try {
            MessageNano.mergeFrom((MessageNano)notifyMessage, (byte[])bytes);
        }
        catch (Throwable e) {
            YLKLog.e(TAG, "OnStreamsBroadcastingV2 Throwable:" + e);
        }
        if (notifyMessage == null) {
            YLKLog.e(TAG, "OnStreamsBroadcastingV2 notifyMessage null");
            return;
        }
        if (notifyMessage.messageType == 801) {
            if (notifyMessage.streamNotifyLongMessage == null || notifyMessage.streamNotifyLongMessage.channelStreamInfo == null) {
                YLKLog.e(TAG, "OnStreamsBroadcastingV2 streamNotifyLongMessage null");
                return;
            }
            long bcVersion = notifyMessage.streamNotifyLongMessage.channelStreamInfo.version;
            long cid = Uint32.toUInt(notifyMessage.streamNotifyLongMessage.cid).longValue();
            long sid = Uint32.toUInt(notifyMessage.streamNotifyLongMessage.sid).longValue();
            Channel bcChannel = new Channel(cid, sid);
            YLKLog.i(TAG, "LongMsg seq:" + notifyMessage.sequence + ",bcVer:" + bcVersion + ",curVer:" + Env.instance().currentStreamVersion + ",bcChannel:" + bcChannel + ",hash:" + this.hashCode());
            Channel channel = YLKLive.instance().getChannel();
            if (!bcChannel.equals(channel)) {
                YLKLog.e(TAG, "LongMsg checkChannel seq:" + notifyMessage.sequence + ",bcChannel:" + bcChannel + ",channel:" + channel);
                return;
            }
            if (bcVersion == 0L) {
                this.processStopLive();
                return;
            }
            if (Env.instance().currentStreamVersion >= bcVersion && bcVersion != 0L) {
                return;
            }
            if (FP.empty((Object[])this.acceptanceRules.visibilityRules) && bcVersion != 0L) {
                this.callback.onUpdateStreamInfo(Env.instance().currentStreamVersion, bcVersion);
                return;
            }
            String infoStr = MessageUtils.printStreams(notifyMessage.streamNotifyLongMessage.channelStreamInfo.streams);
            YLKLog.i(TAG, "OnStreamsBroadcastingV2 LongMsg seq:" + notifyMessage.sequence + ",infoStr:" + infoStr);
            Env.instance().currentStreamVersion = bcVersion;
            final Map<String, Object> retDataMap = LiveInfoFactoryV2.make(this.acceptanceRules, notifyMessage.streamNotifyLongMessage.channelStreamInfo);
            final Map<Long, Map<Short, Long>> metaDataMap = MetaDataFactoryV2.make(notifyMessage.streamNotifyLongMessage.channelStreamInfo);
            RunInMain.dispatch(new Runnable(){

                @Override
                public void run() {
                    if (OnStreamsBroadcastingV2.this.callback != null) {
                        OnStreamsBroadcastingV2.this.callback.onStreamsBroadcasting(((Object)((Object)notifyMessage)).hashCode(), (List)retDataMap.get("AnchorStream"), (Set)retDataMap.get("AudienceStream"), (List)retDataMap.get("GroupInfo"), metaDataMap, (Set)retDataMap.get("TransConfig"));
                    }
                }
            });
        } else if (notifyMessage.messageType == 800) {
            if (notifyMessage.streamNotifyShortMessage == null) {
                YLKLog.e(TAG, "OnStreamsBroadcastingV2 streamNotifyShortMessage null");
                return;
            }
            long bcVersion = notifyMessage.streamNotifyShortMessage.version;
            long cid = Uint32.toUInt(notifyMessage.streamNotifyShortMessage.cid).longValue();
            long sid = Uint32.toUInt(notifyMessage.streamNotifyShortMessage.sid).longValue();
            Channel bcChannel = new Channel(cid, sid);
            YLKLog.i(TAG, "ShortMsg seq:" + notifyMessage.sequence + ",bcVer:" + bcVersion + ",curVer:" + Env.instance().currentStreamVersion + ",bcChannel:" + bcChannel + ",hash:" + this.hashCode());
            Channel channel = YLKLive.instance().getChannel();
            if (!bcChannel.equals(channel)) {
                YLKLog.e(TAG, "ShortMsg checkChannel seq:" + notifyMessage.sequence + ",bcChannel:" + bcChannel + ",channel:" + channel);
                return;
            }
            if (bcVersion == 0L) {
                this.processStopLive();
                return;
            }
            if (Env.instance().currentStreamVersion >= bcVersion && bcVersion != 0L) {
                return;
            }
            this.callback.onUpdateStreamInfo(Env.instance().currentStreamVersion, bcVersion);
        }
    }

    private void processStopLive() {
        YLKLog.i(TAG, "OnStreamsBroadcastingV2 processStopLive hash:" + this.hashCode());
        if (Env.instance().currentStreamVersion == 0L) {
            YLKLog.i(TAG, "OnStreamsBroadcastingV2 processStopLive already stop hash:" + this.hashCode());
            return;
        }
        Env.instance().currentStreamVersion = 0L;
        final StreamCliMsg2C.ChannelStreamInfo channelStreamInfo = new StreamCliMsg2C.ChannelStreamInfo();
        final Map<String, Object> retDataMap = LiveInfoFactoryV2.make(this.acceptanceRules, channelStreamInfo);
        final Map<Long, Map<Short, Long>> metaDataMap = MetaDataFactoryV2.make(channelStreamInfo);
        RunInMain.dispatch(new Runnable(){

            @Override
            public void run() {
                if (OnStreamsBroadcastingV2.this.callback != null) {
                    OnStreamsBroadcastingV2.this.callback.onStreamsBroadcasting(((Object)((Object)channelStreamInfo)).hashCode(), (List)retDataMap.get("AnchorStream"), (Set)retDataMap.get("AudienceStream"), (List)retDataMap.get("GroupInfo"), metaDataMap, (Set)retDataMap.get("TransConfig"));
                }
            }
        });
    }

    public static interface Callback {
        public void onStreamsBroadcasting(long var1, List<LiveInfo> var3, Set<LiveInfo> var4, List<GroupInfo> var5, Map<Long, Map<Short, Long>> var6, Set<TransConfig> var7);

        public void onUpdateStreamInfo(long var1, long var3);
    }
}

