/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.services;

import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.Channel;
import com.yy.yylivekit.services.core.Pack;
import com.yy.yylivekit.services.core.Unpack;
import com.yy.yylivekit.services.core.UnpackException;
import com.yy.yylivekit.services.retrystrategies.RetryFixedCounts;
import com.yy.yylivekit.services.retrystrategies.RetryNone;
import com.yy.yylivekit.services.retrystrategies.RetryStrategy;
import com.yy.yylivekit.threading.Dispatcher;
import com.yy.yylivekit.threading.RunInMain;
import com.yy.yylivekit.utils.Cleanup;
import com.yy.yylivekit.utils.Mob;
import com.yy.yylivekit.utils.Triple;
import com.yyproto.base.IWatcher;
import com.yyproto.base.ProtoEvent;
import com.yyproto.base.ProtoReq;
import com.yyproto.outlet.IProtoMgr;
import com.yyproto.outlet.SvcEvent;
import com.yyproto.outlet.SvcRequest;
import com.yyproto.utils.FP;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;

public class Service {
    private static final String TAG = "Service";
    private static final LaunchCompletion entryCompletion = new LaunchCompletion(){};
    private static AtomicInteger nextOpId = new AtomicInteger((int)(System.currentTimeMillis() & 0xFFFFL));
    private static Semaphore serviceState = new Semaphore(0);
    private static volatile int channelState = 0;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private final Cleanup closures = new Cleanup(this.getClass().getSimpleName());
    private final OperationTriples operations = new OperationTriples();
    private final Map<String, List<Broadcast>> broadcasts = new HashMap<String, List<Broadcast>>();
    private final SparseArray<Integer> opIdToUri = new SparseArray();
    private final int mThreadsSize = 3;
    private final int mCapacity = 3;
    private Dispatcher dispatcher = new Dispatcher(){

        @Override
        public void dispatch(Runnable runnable) {
            RunInMain.dispatch(runnable);
        }
    };
    private int timeoutInterval = 5000;
    private ExecutorService executor;

    private Service() {
        this.setupWatcher();
    }

    public static Service instance() {
        return Holder.instance;
    }

    private static boolean shouldRunInWork(Operation op) {
        return op != null && op.serviceNumber() == 9701 && op.jobNumber() == 3;
    }

    private static int nextOpId() {
        return nextOpId.getAndAdd(1);
    }

    public static boolean isReady() {
        return channelState == 2;
    }

    public void setExtraExecutor(ExecutorService extraExecutor) {
        YLKLog.i(TAG, "setExtraExecutor() called with: extraExecutor = [" + extraExecutor + "]");
        this.executor = extraExecutor;
    }

    ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(3, 3, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(3), new YlkDefaultThreadFactory("Ylk"), new ThreadPoolExecutor.DiscardOldestPolicy());
        }
        return this.executor;
    }

    public Service setDispatcher(Dispatcher dispatcher) {
        Assert.assertNotNull((String)"dispatcher\u800c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object)dispatcher);
        this.dispatcher = dispatcher;
        return this;
    }

    public Service setTimeoutInterval(int timeoutInterval) {
        Assert.assertTrue((String)"\u8bf7\u6c42\u8d85\u65f6\u5c0f\u4e8e1\u79d2\u51e0\u4e4e\u662f\u65e0\u610f\u4e49\u7684", (timeoutInterval >= 1000 ? 1 : 0) != 0);
        this.timeoutInterval = timeoutInterval;
        return this;
    }

    public void launch(Operation op) {
        this.launch(op, null);
    }

    public void launch(Operation op, LaunchCompletion completion) {
        this.launch(op, completion, (RetryStrategy)new RetryFixedCounts(3, this.timeoutInterval));
    }

    public void launch(Operation op, LaunchCompletion completion, RetryStrategy retry) {
        int opId = Service.nextOpId();
        Runnable runnable = this.generateOperationTask(opId, op, completion, retry);
        this.getExecutor().submit(runnable);
    }

    public void launch(UriOperation op) {
        this.launch(op, null, (RetryStrategy)new RetryFixedCounts(3, this.timeoutInterval));
    }

    public void launch(UriOperation op, LaunchCompletion completion, RetryStrategy retry) {
        int opId = Service.nextOpId();
        this.opIdToUri.put(opId, (Object)op.uriOpId());
        Runnable runnable = this.generateOperationTask(opId, op, completion, retry);
        this.getExecutor().submit(runnable);
    }

    public void execute(Runnable runnable) {
        this.getExecutor().submit(runnable);
    }

    private Runnable generateOperationTask(final int opId, final Operation op, final LaunchCompletion completion, final RetryStrategy retry) {
        return new Runnable(){

            @Override
            public void run() {
                LaunchCompletion wrappedCompletion = completion == null ? entryCompletion : completion;
                RetryStrategy wrappedRetry = retry == null ? new RetryNone(Service.this.timeoutInterval) : retry;
                try {
                    YLKLog.i(Service.TAG, "Service launch op: type=" + (Object)((Object)op.type()) + ",max=" + op.serviceNumber() + ",min=" + op.jobNumber());
                    if (!Service.isReady()) {
                        AtomicInteger tryCount = new AtomicInteger(0);
                        boolean permission = false;
                        while (tryCount.getAndIncrement() < 3 && !permission) {
                            permission = serviceState.tryAcquire(2000L, TimeUnit.MILLISECONDS);
                        }
                        if (!permission && !Service.isReady()) {
                            throw new Exception("Launch service State permission false!! type=" + (Object)((Object)op.type()) + ",max=" + op.serviceNumber() + ",min=" + op.jobNumber());
                        }
                    }
                }
                catch (Throwable e) {
                    YLKLog.e("YLK", "Launch Throwable:" + e);
                    Service.this.popOperation(opId);
                    LaunchFailure failure = LaunchFailure.SvcUnReady;
                    String msg = "SvcUnReady Exception, Request be cancel";
                    wrappedCompletion.onLaunchFailed(failure, msg);
                    return;
                }
                Service.this.pushOperation(opId, op, wrappedRetry, wrappedCompletion);
                Service.this.handleRetry(opId, op, wrappedCompletion, wrappedRetry);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Broadcast broadcast) {
        Map<String, List<Broadcast>> map = this.broadcasts;
        synchronized (map) {
            String broadcastID = this.broadcastID(broadcast);
            YLKLog.i("YLK", "register broadcastID:" + broadcastID + "," + this.broadcasts.get(broadcastID));
            List<Broadcast> broadcastList = this.broadcasts.get(broadcastID);
            if (broadcastList == null) {
                broadcastList = new ArrayList<Broadcast>();
                this.broadcasts.put(broadcastID, broadcastList);
            }
            broadcastList.add(broadcast);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Broadcast broadcast) {
        Map<String, List<Broadcast>> map = this.broadcasts;
        synchronized (map) {
            String broadcastID = this.broadcastID(broadcast);
            List<Broadcast> broadcastList = this.broadcasts.get(this.broadcastID(broadcast));
            Assert.assertTrue((String)"\u6ca1\u6709\u5bf9\u5e94\u7684NotificationHandle", (broadcastList != null ? 1 : 0) != 0);
            broadcastList.remove(broadcast);
            if (FP.empty(broadcastList)) {
                this.broadcasts.remove(broadcastID);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.teardown();
    }

    private void teardown() {
        this.closures.flush(null);
    }

    private void handleRetry(final int opId, final Operation op, final LaunchCompletion launchCompletion, final RetryStrategy retryStrategy) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                OperationTriple triple = Service.this.popOperation(opId);
                if (triple != null) {
                    RetryStrategy retry = (RetryStrategy)triple.b;
                    if (retry.consumeOnce()) {
                        YLKLog.i("YLK", "Service Timeout! Operation will retry: " + op.getClass().getSimpleName());
                        Service.this.launch(op, launchCompletion, retryStrategy);
                    } else {
                        YLKLog.e("YLK", "Service Timeout! Operation discard: " + op.getClass().getSimpleName());
                        LaunchFailure failure = LaunchFailure.RequestTimeout;
                        String message = "Service Timeout: " + op.getClass().getSimpleName();
                        launchCompletion.onLaunchFailed(failure, message);
                    }
                }
            }
        };
        this.mainHandler.postDelayed(runnable, retryStrategy.intervalMillis());
    }

    private String broadcastID(Broadcast bc) {
        return String.format(Locale.getDefault(), "%s|%s|%s", bc.serviceType(), bc.serviceNumber(), bc.jobNumber());
    }

    private String broadcastID(int svcAppID, int majorType, int minorType) {
        return String.format(Locale.getDefault(), "%s|%s|%s", svcAppID, majorType, minorType);
    }

    private void setupWatcher() {
        final IWatcher watcher = new IWatcher(){

            public void onEvent(ProtoEvent event) {
                Assert.assertEquals((String)"\u901a\u8fc7svc.watch\u89c2\u5bdf\u7684\u8bf7\u6c42\uff0c\u8fd4\u56de\u53ea\u80fd\u662fSVC\u54cd\u5e94", (int)4, (int)event.modType());
                this.processSvcState(event);
                if (this.isServiceDataResponse(event)) {
                    this.processSvcData((SvcEvent.ETSvcData)event);
                }
            }

            private void processSvcState(ProtoEvent evt) {
                if (evt.modType() == 4 && evt.eventType() == 4) {
                    SvcEvent.ETSvcChannelState event = (SvcEvent.ETSvcChannelState)evt;
                    int oldState = channelState;
                    int newState = event.state;
                    channelState = newState;
                    String[] stateNames = new String[]{"Init", "Connecting", "Ready", "Reconnecting", "Error", "Connected"};
                    YLKLog.i("YLK", "Service processSvcState changed: " + stateNames[oldState] + " -> " + stateNames[newState]);
                    if (channelState == 2) {
                        serviceState.release();
                        YLKLog.i("YLK", "Service processSvcState STATE_READY");
                    }
                }
            }

            private void processSvcData(final SvcEvent.ETSvcData svcData) {
                if (svcData.mSvcType == 10557) {
                    Mob.decodeResponseUri(svcData.mData, new Mob.ResponseUriHandler(){

                        @Override
                        public void onDecodeSuccess(int uri, byte[] payload) {
                            int opId = Service.this.opIdFromUri(uri);
                            if (opId > 0) {
                                Service.this.handleJobResponse(opId, -1, payload);
                            } else {
                                YLKLog.i(Service.TAG, "[decodeResponseUri] onDecodeSuccess() opId invalid");
                            }
                        }

                        @Override
                        public void onDecodeFailed() {
                            YLKLog.i(Service.TAG, "[decodeResponseUri] onDecodeFailed() called");
                        }
                    });
                } else {
                    Mob.decodeResponse(svcData.mData, new Mob.ResponseHandler(){

                        @Override
                        public void onDecodeSuccess(int majorType, int minorType, String appData, byte[] payload) {
                            YLKLog.i(Service.TAG, "launch onDecodeSuccess() max:" + majorType + ",min:" + minorType);
                            if (appData != null) {
                                if (this.canHandleResponse(appData)) {
                                    Service.this.handleJobResponse(Service.this.opIdFromAppData(appData), minorType, payload);
                                }
                            } else {
                                Service.this.handleBroadcast(svcData.mSvcType, majorType, minorType, payload);
                            }
                        }

                        @Override
                        public void onDecodeFailed() {
                            YLKLog.i(Service.TAG, "onDecodeFailed() called");
                        }
                    });
                }
            }

            private boolean isServiceDataResponse(ProtoEvent event) {
                return event.modType() == 4 && event.eventType() == 1;
            }

            private boolean canHandleResponse(String eigenvalue) {
                return eigenvalue.startsWith("YLK");
            }
        };
        YLKLog.i(TAG, "Service setupWatcher");
        IProtoMgr.instance().getSvc().watch(watcher);
        this.closures.push("revoke watcher", new Runnable(){

            @Override
            public void run() {
                IProtoMgr.instance().getSvc().revoke(watcher);
            }
        });
    }

    private void handleBroadcast(int svcAppID, int majorType, int minorType, byte[] payload) {
        List<Broadcast> bcList = this.broadcasts.get(this.broadcastID(svcAppID, majorType, minorType));
        if (bcList == null) {
            return;
        }
        for (Broadcast bc : bcList) {
            bc.process(new Unpack(payload));
        }
    }

    private void handleJobResponse(int opId, final int minorType, byte[] payload) {
        OperationTriple triple = this.popOperation(opId);
        if (triple == null) {
            YLKLog.e(TAG, "handleJobResponse() triple is nil: minorType=" + minorType);
            return;
        }
        final Operation op = (Operation)triple.a;
        final LaunchCompletion completion = (LaunchCompletion)triple.c;
        final Unpack up = Operation.PackType.Jsonp.equals((Object)op.type()) ? new JsonUnpack(payload) : new Unpack(payload);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    op.processResponse(minorType, up);
                    completion.onLaunchSuccess();
                }
                catch (Throwable e) {
                    YLKLog.e(Service.TAG, "Service processResponse exception: " + e);
                    LaunchFailure failure = LaunchFailure.ResponseError;
                    String msg = "\u5904\u7406Service\u8bf7\u6c42\u65f6\u53d1\u751f\u4e86\u5f02\u5e38";
                    completion.onLaunchFailed(failure, msg);
                }
            }
        };
        if (Service.shouldRunInWork(op)) {
            YLKLog.i(TAG, "Service shouldRunInWork max:" + op.serviceNumber() + ",min:" + op.jobNumber());
            runnable.run();
        } else {
            this.dispatcher.dispatch(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushOperation(int opId, Operation op, RetryStrategy retry, LaunchCompletion completion) {
        byte[] yypBytes;
        OperationTriples operationTriples = this.operations;
        synchronized (operationTriples) {
            this.operations.put(opId, new OperationTriple(op, retry, completion));
        }
        Channel ch = op.channel();
        long topCID = ch == null ? 0L : ch.top;
        long subCID = ch == null ? 0L : ch.sub;
        Pack pack = new Pack();
        op.packRequest(pack);
        if (op.serviceType() == 10557) {
            yypBytes = pack.toBytes();
        } else {
            String appData = this.appDataFromOpId(opId);
            yypBytes = Mob.encodeRequest(op.serviceNumber(), op.jobNumber(), subCID, appData, pack.toBytes());
        }
        SvcRequest.SvcDataReq svcDataReq = new SvcRequest.SvcDataReq(op.serviceType(), topCID, subCID, yypBytes);
        IProtoMgr.instance().getSvc().sendRequest((ProtoReq)svcDataReq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationTriple popOperation(int opId) {
        OperationTriples operationTriples = this.operations;
        synchronized (operationTriples) {
            if (this.operations.get(opId) == null) {
                return null;
            }
            OperationTriple triple = (OperationTriple)this.operations.get(opId);
            this.operations.remove(opId);
            return triple;
        }
    }

    private String appDataFromOpId(int opId) {
        return "YLK" + opId;
    }

    private int opIdFromAppData(String appData) {
        return Integer.parseInt(appData.substring("YLK".length()));
    }

    private int opIdFromUri(int uri) {
        int opId = -1;
        int size = this.opIdToUri.size();
        for (int i = 0; i < size; ++i) {
            if (uri != (Integer)this.opIdToUri.valueAt(i)) continue;
            opId = this.opIdToUri.keyAt(i);
            break;
        }
        if (opId > 0) {
            this.opIdToUri.remove(opId);
        }
        return opId;
    }

    static class YlkDefaultThreadFactory
    implements ThreadFactory {
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        YlkDefaultThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.namePrefix + "-thread-" + this.threadNumber.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static final class OperationTriples
    extends SparseArray<OperationTriple> {
        private OperationTriples() {
        }
    }

    private static final class OperationTriple
    extends Triple<Operation, RetryStrategy, LaunchCompletion> {
        OperationTriple(Operation operation, RetryStrategy retryStrategy, LaunchCompletion completion) {
            super(operation, retryStrategy, completion);
        }
    }

    private static class Holder {
        private static final Service instance = new Service();

        private Holder() {
        }
    }

    public static abstract class LaunchCompletion {
        public void onLaunchSuccess() {
        }

        public void onLaunchFailed(LaunchFailure failure, String msg) {
        }
    }

    public static class JsonUnpack
    extends Unpack {
        public JsonUnpack(byte[] bytes) {
            super(bytes, 0, bytes.length);
        }

        @Override
        public String popString() {
            try {
                byte[] dst = new byte[this.buffer.remaining()];
                this.buffer.get(dst);
                return new String(dst, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new UnpackException();
            }
        }
    }

    public static interface Broadcast
    extends Job {
        public void process(Unpack var1);
    }

    public static interface UriOperation
    extends Operation {
        public int uriOpId();
    }

    public static interface Operation
    extends Job {
        public Channel channel();

        public PackType type();

        public void packRequest(Pack var1);

        public void processResponse(int var1, Unpack var2);

        public static enum PackType {
            Normal,
            Jsonp;

        }
    }

    static interface Job {
        public int serviceType();

        public int serviceNumber();

        public int jobNumber();
    }

    public static enum LaunchFailure {
        RequestTimeout,
        ResponseError,
        SvcUnReady;

    }
}

