/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit;

import android.content.Context;
import com.yy.yylivekit.YLKLive;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.AppIDSet;
import com.yy.yylivekit.model.AppNames;
import com.yy.yylivekit.utils.RuntimeKit;

public final class YLKEngine {
    private static final String TAG = "YLKEngine";
    private static YLKLive liveInstance;

    public static int init(Context context, String appName, String buzName, int appId, int sceneId, String libPath) {
        return YLKEngine.init(context, appName, buzName, appId, sceneId, libPath, null);
    }

    public static int init(Context context, String appName, String buzName, int appId, int sceneId, String libPath, String logPath) {
        if (liveInstance != null) {
            return 1;
        }
        YLKLog.i(TAG, "YLKEngine init appName:" + appName + ",buzName:" + buzName + ",appId:" + appId + ",sceneId:" + sceneId + ",libPath:" + libPath);
        int resCode = 1;
        liveInstance = YLKLive.instance();
        if (liveInstance != null) {
            String version = RuntimeKit.appVersion(context);
            resCode = liveInstance.init(context, new AppNames(appName, buzName), version, new AppIDSet(appId, sceneId), libPath, logPath);
        }
        return resCode;
    }

    public static void setDeInitEventHandler(DeInitEventHandler handler) {
        YLKLog.i(TAG, "setDeInitEventHandler");
        if (liveInstance != null) {
            liveInstance.setDeInitEventHandler(handler);
        }
    }

    public static void deInitMediaTrans() {
        YLKLog.i(TAG, "deInitMediaTrans");
        if (liveInstance != null) {
            liveInstance.deInitMediaTrans();
        }
    }

    public static void reInitMediaTrans() {
        YLKLog.i(TAG, "reInitMediaTrans");
        if (liveInstance != null) {
            liveInstance.reInitMediaTrans();
        }
    }

    public static void enterBackground() {
        YLKLog.i(TAG, "enterBackground");
        if (liveInstance != null) {
            liveInstance.enterBackground();
        }
    }

    public static void enterForeground() {
        YLKLog.i(TAG, "enterForeground");
        if (liveInstance != null) {
            liveInstance.enterForeground();
        }
    }

    public static YLKLive getLive() {
        return liveInstance;
    }

    public static int setAppIds(int appId, int sceneId) {
        if (liveInstance != null) {
            YLKLog.i(TAG, "setAppIds appId:" + appId + ",sceneId:" + sceneId);
            liveInstance.setAppIds(new AppIDSet(appId, sceneId));
            return 0;
        }
        YLKLog.i(TAG, "setAppIds liveInstance nil");
        return 1;
    }

    public static int getSceneId() {
        if (liveInstance != null && liveInstance.getAppIDSet() != null) {
            return YLKEngine.liveInstance.getAppIDSet().sceneId;
        }
        return 0;
    }

    public static int getCurAppId() {
        if (liveInstance != null && liveInstance.getAppIDSet() != null) {
            return YLKEngine.liveInstance.getAppIDSet().ent;
        }
        return 0;
    }

    public static String getBusiness() {
        if (liveInstance != null && liveInstance.getAppNames() != null) {
            return YLKEngine.liveInstance.getAppNames().business;
        }
        return "";
    }

    public static interface DeInitEventHandler {
        public void onDeInit();
    }
}

