/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.services.core;

import com.yy.yylivekit.services.core.Marshallable;
import com.yy.yylivekit.services.core.Uint16;
import com.yy.yylivekit.services.core.Uint32;
import com.yy.yylivekit.services.core.Uint64;
import com.yy.yylivekit.services.core.Uint8;
import com.yy.yylivekit.services.core.Unpack;
import com.yy.yylivekit.services.core.UnpackException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UnmarshalContainer {
    public static void unmarshalColUint8(Unpack up, Collection<Uint8> col) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            col.add(up.popUint8());
        }
    }

    public static void unmarshalColUint16(Unpack up, Collection<Uint16> col) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            col.add(up.popUint16());
        }
    }

    public static void unmarshalColUint32(Unpack up, Collection<Uint32> col) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            col.add(up.popUint32());
        }
    }

    public static void unmarshalColUint64(Unpack up, Collection<Uint64> col) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            col.add(up.popUint64());
        }
    }

    public static void unmarshalColString(Unpack up, Collection<String> col) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            col.add(up.popString());
        }
    }

    public static void unmarshalColBytes(Unpack up, Collection<byte[]> col) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            col.add(up.popBytes());
        }
    }

    public static void unmarshalColMarshallable(Unpack up, Collection col, Class<? extends Marshallable> type) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            try {
                Marshallable m = type.newInstance();
                m.unmarshall(up);
                col.add(m);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new UnpackException(e);
            }
            catch (InstantiationException e) {
                throw new UnpackException(e);
            }
        }
    }

    public static void unmarshalColMapStringString(Unpack up, Collection<Map<String, String>> col) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            UnmarshalContainer.unmarshalMapStringString(up, map);
            col.add(map);
        }
    }

    public static void unmarshalColMapStringBytes(Unpack up, Collection<Map<String, byte[]>> col) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            UnmarshalContainer.unmarshalMapStringBytes(up, map);
            col.add(map);
        }
    }

    public static void unmarshalColMapUint32String(Unpack up, Collection<Map<Uint32, String>> col) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            HashMap<Uint32, String> map = new HashMap<Uint32, String>();
            UnmarshalContainer.unmarshalMapUint32String(up, map);
            col.add(map);
        }
    }

    public static void unmarshalColMapUint32Uint32(Unpack up, Collection<Map<Uint32, Uint32>> col) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            HashMap<Uint32, Uint32> map = new HashMap<Uint32, Uint32>();
            UnmarshalContainer.unmarshalMapUint32Uint32(up, map);
            col.add(map);
        }
    }

    public static void unmarshalColMapUint32MapStringString(Unpack up, Collection<Map<Uint32, Map<String, String>>> col) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            HashMap<Uint32, Map<String, String>> map = new HashMap<Uint32, Map<String, String>>();
            UnmarshalContainer.unmarshalMapUint32MapStringString(up, map);
            col.add(map);
        }
    }

    public static void unmarshalMapUint8Uint32(Unpack up, Map<Uint8, Uint32> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            map.put(up.popUint8(), up.popUint32());
        }
    }

    public static void unmarshalMapUint16Uint32(Unpack up, Map<Uint16, Uint32> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            map.put(up.popUint16(), up.popUint32());
        }
    }

    public static void unmarshalMapUint16Bytes(Unpack up, Map<Uint16, byte[]> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            map.put(up.popUint16(), up.popBytes());
        }
    }

    public static void unmarshalMapUint16String(Unpack up, Map<Uint16, String> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            map.put(up.popUint16(), up.popString());
        }
    }

    public static void unmarshalMapUint32Uint32(Unpack up, Map<Uint32, Uint32> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            map.put(up.popUint32(), up.popUint32());
        }
    }

    public static void unmarshalMapUint32String(Unpack up, Map<Uint32, String> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            map.put(up.popUint32(), up.popString());
        }
    }

    public static void unmarshalMapUint32Boolean(Unpack up, Map<Uint32, Boolean> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            map.put(up.popUint32(), up.popBoolean());
        }
    }

    public static void unmarshalMapUint32Bytes(Unpack up, Map<Uint32, byte[]> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            map.put(up.popUint32(), up.popBytes());
        }
    }

    public static void unmarshalMapStringString(Unpack up, Map<String, String> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            map.put(up.popString(), up.popString());
        }
    }

    public static void unmarshalMapBytesBytes(Unpack up, Map<byte[], byte[]> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            map.put(up.popBytes(), up.popBytes());
        }
    }

    public static void unmarshalMapStringBytes(Unpack up, Map<String, byte[]> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            map.put(up.popString(), up.popBytes());
        }
    }

    public static void unmarshalMapStringUint32(Unpack up, Map<String, Uint32> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            map.put(up.popString(), up.popUint32());
        }
    }

    public static void unmarshalMapBytesUint32(Unpack up, Map<byte[], Uint32> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            map.put(up.popBytes(), up.popUint32());
        }
    }

    public static void unmarshalMapUint32MapUint32Uint32(Unpack up, Map<Uint32, Map<Uint32, Uint32>> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            Uint32 key = up.popUint32();
            HashMap<Uint32, Uint32> innerMap = new HashMap<Uint32, Uint32>();
            UnmarshalContainer.unmarshalMapUint32Uint32(up, innerMap);
            map.put(key, innerMap);
        }
    }

    public static void unmarshalMapUint32ListUint32(Unpack up, Map<Uint32, List<Uint32>> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            Uint32 key = up.popUint32();
            ArrayList<Uint32> innerList = new ArrayList<Uint32>();
            UnmarshalContainer.unmarshalColUint32(up, innerList);
            map.put(key, innerList);
        }
    }

    public static void unmarshalMapUint32Marshallable(Unpack up, Map map, Class<? extends Marshallable> type) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            Uint32 key = up.popUint32();
            try {
                Marshallable m = type.newInstance();
                m.unmarshall(up);
                map.put(key, m);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new UnpackException(e);
            }
            catch (InstantiationException e) {
                throw new UnpackException(e);
            }
        }
    }

    public static void unmarshalMapStringMarshallable(Unpack up, Map map, Class<? extends Marshallable> type) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            String key = up.popString();
            try {
                Marshallable m = type.newInstance();
                m.unmarshall(up);
                map.put(key, m);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new UnpackException(e);
            }
            catch (InstantiationException e) {
                throw new UnpackException(e);
            }
        }
    }

    public static void unmarshalMapUint32MapStringString(Unpack up, Map<Uint32, Map<String, String>> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            Uint32 key = up.popUint32();
            HashMap<String, String> innerMap = new HashMap<String, String>();
            UnmarshalContainer.unmarshalMapStringString(up, innerMap);
            map.put(key, innerMap);
        }
    }

    public static void unmarshalMapStringMapStringString(Unpack up, Map<String, Map<String, String>> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); ++i) {
            String key = up.popString();
            HashMap<String, String> innerMap = new HashMap<String, String>();
            UnmarshalContainer.unmarshalMapStringString(up, innerMap);
            map.put(key, innerMap);
        }
    }
}

