/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.model;

import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.yylivekit.Env;
import com.yy.yylivekit.model.LiveMeta;
import com.yy.yylivekit.utils.CodecAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VideoParams {
    public final int key;
    public final int isDefault;
    public final int width;
    public final int height;
    public final int codeRate;
    public final int currate;
    public final int frameRate;
    public final int minrate;
    public final int maxrate;
    public final VideoEncoderType encodeType;
    public final String encodeParam;
    public final int intervalSeconds;
    public final int preViewWidth;
    public final int preViewHeight;
    public final int preViewFrameRate;
    public final List<ResolutionModifyConfig> modifyConfigs;
    final int[] h264Default = new int[]{800, 1800, 3999};
    final int[] h265Default = new int[]{700, 1500, 3000};
    public boolean lowDelay = false;

    public VideoParams(int width, int height, int currate, int frameRate, VideoEncoderType encodeType, String encodeParam) {
        this(width, height, currate, currate, 100, 1200, frameRate, encodeType, encodeParam, 720, 1280, frameRate, false);
    }

    public VideoParams(int width, int height, int codeRate, int currate, int minrate, int maxrate, int frameRate, VideoEncoderType encodeType, String encodeParam, int pvWidth, int pvHeight, int pvFrameRate, boolean lowDelay) {
        this.key = this.videoQualityCalc(encodeType, currate);
        this.isDefault = 0;
        this.width = width;
        this.height = height;
        this.currate = currate * 1000;
        this.codeRate = codeRate * 1000;
        this.minrate = minrate * 1000;
        this.maxrate = maxrate * 1000;
        this.frameRate = frameRate;
        this.encodeType = encodeType;
        this.encodeParam = encodeParam == null ? "" : encodeParam;
        this.intervalSeconds = 0;
        this.preViewWidth = pvWidth;
        this.preViewHeight = pvHeight;
        this.preViewFrameRate = pvFrameRate;
        this.lowDelay = lowDelay;
        this.modifyConfigs = null;
    }

    public VideoParams(LiveMeta.EncodeMeta encodeMeta) {
        this.key = encodeMeta.key;
        this.isDefault = encodeMeta.isDefault;
        this.width = encodeMeta.width;
        this.height = encodeMeta.height;
        this.codeRate = encodeMeta.codeRate * 1000;
        this.currate = encodeMeta.currate * 1000;
        this.minrate = encodeMeta.minrate * 1000;
        this.maxrate = encodeMeta.maxrate * 1000;
        this.frameRate = encodeMeta.frameRate;
        this.encodeType = CodecAdapter.toPreviewCodec(encodeMeta.type);
        this.encodeParam = encodeMeta.param;
        this.intervalSeconds = Env.instance().modifyInterval();
        this.preViewWidth = encodeMeta.pvWidth;
        this.preViewHeight = encodeMeta.pvHeight;
        this.preViewFrameRate = encodeMeta.pvFrameRate;
        this.modifyConfigs = new ArrayList<ResolutionModifyConfig>();
        for (LiveMeta.ModifyMeta modifyMeta : encodeMeta.modifyMetaList) {
            this.modifyConfigs.add(new ResolutionModifyConfig(modifyMeta.width, modifyMeta.height, modifyMeta.minCodeRate * 1000, modifyMeta.maxCodeRate * 1000, modifyMeta.minFrameRate, modifyMeta.maxFrameRate, CodecAdapter.toPreviewCodec(modifyMeta.encodeId), modifyMeta.encodeParam));
        }
    }

    public String toString() {
        return "VideoParams{key=" + this.key + ", isDefault=" + this.isDefault + ", width=" + this.width + ", height=" + this.height + ", codeRate=" + this.codeRate + ", currate=" + this.currate + ", lowDelay=" + this.lowDelay + ", frameRate=" + this.frameRate + ", minrate=" + this.minrate + ", maxrate=" + this.maxrate + ", encodeType=" + this.encodeType + ", encodeParam='" + this.encodeParam + '\'' + ", intervalSeconds=" + this.intervalSeconds + ", preViewWidth=" + this.preViewWidth + ", preViewHeight=" + this.preViewHeight + ", preViewFrameRate=" + this.preViewFrameRate + ", modifyConfigs=" + this.modifyConfigs + ", h264Default=" + Arrays.toString(this.h264Default) + ", h265Default=" + Arrays.toString(this.h265Default) + '}';
    }

    int videoQualityCalc(VideoEncoderType type, int rate) {
        int[] tmp = type.equals((Object)VideoEncoderType.SOFT_ENCODER_H265) || type.equals((Object)VideoEncoderType.HARD_ENCODER_H265) ? this.h265Default : this.h264Default;
        int realLevel = tmp.length;
        for (int i = 0; i < tmp.length; ++i) {
            if (rate > tmp[i]) continue;
            realLevel = i;
            break;
        }
        return realLevel + 1;
    }
}

