/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience.streamline;

import com.medialib.video.MediaVideoMsg;
import com.yy.yylivekit.audience.LivePlayer;
import com.yy.yylivekit.audience.streamline.AbsHandler;
import com.yy.yylivekit.audience.streamline.IComplete;
import com.yy.yylivekit.audience.streamline.IHandler;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.StreamInfo;
import com.yy.yylivekit.model.VideoGearInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LineFrom9Handler
extends AbsHandler
implements IHandler {
    private static final String TAG = "LineFrom9Handler";

    @Override
    public void handle(LivePlayer player, MediaVideoMsg.LiveStreamLineInfo liveStreamLineInfo, IComplete complete) {
        Set<LiveInfo> liveInfoSet = player.getAllLiveInfo();
        if (!this.checkAccept(liveInfoSet, new AbsHandler.AcceptOption(){

            @Override
            public boolean accept(LiveInfo info) {
                return !info.isMix && info.micNo == 0;
            }
        })) {
            YLKLog.e(TAG, " handle forbidden !");
            return;
        }
        LiveInfo liveInfo = player.getCurLiveInfo();
        StreamInfo streamInfo = player.getCurStreamInfo();
        YLKLog.i(TAG, "handle() called with: liveInfo = [" + liveInfo + "], \nstreamInfo = [" + streamInfo + "], \nliveStreamLineInfo = [" + liveStreamLineInfo + "]");
        if (liveInfo.hasVideo()) {
            complete.onLiveStreamLineInfo(liveInfo.source, 0, streamInfo.video.videoGearInfo, this.generateFullMap(liveInfoSet));
        }
    }

    public MediaVideoMsg.LiveStreamLineInfo generateLineInfo(final LiveInfo liveInfo, final int lineNum) {
        return new MediaVideoMsg.LiveStreamLineInfo(){
            {
                this.curLineSeq = lineNum;
                this.lineFrom = liveInfo.isMix ? -1 : 9;
            }
        };
    }

    private Map<Integer, Map<Integer, List<VideoGearInfo>>> generateFullMap(Set<LiveInfo> liveInfoSet) {
        HashMap<Integer, Map<Integer, List<VideoGearInfo>>> fm = new HashMap<Integer, Map<Integer, List<VideoGearInfo>>>();
        for (LiveInfo info : liveInfoSet) {
            if (!info.hasVideo()) continue;
            final List<VideoGearInfo> qualities = info.getVideoQuality();
            HashMap<Integer, List<VideoGearInfo>> lineQualityMap = new HashMap<Integer, List<VideoGearInfo>>(){
                {
                    this.put(0, qualities);
                }
            };
            fm.put(info.source, (Map<Integer, List<VideoGearInfo>>)lineQualityMap);
        }
        return fm;
    }
}

