/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience.services;

import android.os.Build;
import android.util.DisplayMetrics;
import com.google.protobuf.nano.MessageNano;
import com.yy.IMediaVideoSDK;
import com.yy.livekit.protocol.nano.StreamCliMsg2C;
import com.yy.yylivekit.Env;
import com.yy.yylivekit.YLKLive;
import com.yy.yylivekit.audience.monitor.AcceptanceRulesV2;
import com.yy.yylivekit.audience.monitor.LiveInfoFactoryV2;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.Channel;
import com.yy.yylivekit.model.GroupInfo;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.TransConfig;
import com.yy.yylivekit.services.Service;
import com.yy.yylivekit.services.core.Pack;
import com.yy.yylivekit.services.core.Unpack;
import com.yy.yylivekit.utils.MessageUtils;
import com.yy.yylivekit.utils.MetaDataFactoryV2;
import com.yy.yylivekit.utils.RuntimeKit;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpUpdateStreamInfoV2
implements Service.Operation {
    private final long uid;
    private final Channel channel;
    private final boolean wantsH265Streams;
    private final long currentVersion;
    private final long requestVersion;
    private final Completion completion;

    public OpUpdateStreamInfoV2(long uid, Channel channel, boolean wantsH265Streams, long currentVersion, long requestVersion, Completion completion) {
        this.uid = uid;
        this.channel = channel;
        this.wantsH265Streams = wantsH265Streams;
        this.currentVersion = currentVersion;
        this.requestVersion = requestVersion;
        this.completion = completion;
    }

    @Override
    public int serviceType() {
        return 10599;
    }

    @Override
    public int serviceNumber() {
        return 9701;
    }

    @Override
    public int jobNumber() {
        return 5;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public Service.Operation.PackType type() {
        return Service.Operation.PackType.Normal;
    }

    @Override
    public void packRequest(Pack pack) {
        long seq = System.currentTimeMillis();
        YLKLog.i("YLK", "OpUpdateStreamInfoV2 uid:" + this.uid + ",seq:" + seq + ",channel:" + this.channel + ",hash:" + this.hashCode());
        StreamCliMsg2C.ChannelStreamsUpdateRequest streamsUpdateRequest = new StreamCliMsg2C.ChannelStreamsUpdateRequest();
        streamsUpdateRequest.appid = Env.instance().appIDs().ent;
        streamsUpdateRequest.uid = (int)this.uid;
        streamsUpdateRequest.cid = (int)(this.channel != null ? this.channel.top : 0L);
        streamsUpdateRequest.sid = (int)(this.channel != null ? this.channel.sub : 0L);
        streamsUpdateRequest.businessid = Env.instance().appIDs().sceneId;
        streamsUpdateRequest.sequence = seq;
        streamsUpdateRequest.currentVersion = this.currentVersion;
        streamsUpdateRequest.requestVersion = this.requestVersion;
        DisplayMetrics dm = Env.instance().context().getResources().getDisplayMetrics();
        String width = "" + Math.min(dm.widthPixels, dm.heightPixels);
        String height = "" + Math.max(dm.widthPixels, dm.heightPixels);
        String appVersion = RuntimeKit.appVersion(Env.instance().context());
        StreamCliMsg2C.ClientAttribute clientAttribute = new StreamCliMsg2C.ClientAttribute();
        String vsdkVersion = "" + IMediaVideoSDK.instance().getMedia().liveGetSdkVersion();
        clientAttribute.client = "mobile";
        clientAttribute.model = Build.MODEL;
        clientAttribute.os = "android";
        clientAttribute.osversion = Build.VERSION.SDK;
        clientAttribute.vsdkVersion = vsdkVersion;
        clientAttribute.appIdentify = Env.instance().names().business;
        clientAttribute.appVersion = appVersion;
        clientAttribute.business = "" + Env.instance().appIDs().sceneId;
        clientAttribute.width = width;
        clientAttribute.height = height;
        clientAttribute.clientType = 2;
        clientAttribute.h265 = this.wantsH265Streams ? 1 : 0;
        clientAttribute.abtest = "" + YLKLive.instance().getAbtestVideoQuality();
        streamsUpdateRequest.clientAttribute = clientAttribute;
        byte[] bytes = MessageNano.toByteArray((MessageNano)streamsUpdateRequest);
        pack.pushNoTag(bytes);
        YLKLog.i("YLK", "OpUpdateStreamInfoV2 did pack request hash:" + this.hashCode());
    }

    @Override
    public void processResponse(int responseNumber, Unpack unpack) {
        YLKLog.i("YLK", "OpUpdateStreamInfoV2 will process response hash:" + this.hashCode());
        StreamCliMsg2C.ChannelStreamsUpdateResponse streamsUpdateResponse = new StreamCliMsg2C.ChannelStreamsUpdateResponse();
        byte[] bytes = unpack.toArray();
        try {
            MessageNano.mergeFrom((MessageNano)streamsUpdateResponse, (byte[])bytes);
        }
        catch (Throwable e) {
            YLKLog.e("YLK", "OpUpdateStreamInfoV2 Throwable:" + e);
        }
        if (streamsUpdateResponse == null || streamsUpdateResponse.channelStreamInfo == null) {
            YLKLog.e("YLK", "OpUpdateStreamInfoV2 streamsUpdateResponse null");
            return;
        }
        long version = streamsUpdateResponse.channelStreamInfo.version;
        if (Env.instance().currentStreamVersion >= version && version != 0L) {
            return;
        }
        Env.instance().currentStreamVersion = version;
        String info = MessageUtils.printStreams(streamsUpdateResponse.channelStreamInfo.streams);
        YLKLog.i("YLK", "OpUpdateStreamInfoV2 seq:" + streamsUpdateResponse.sequence + ",version:" + version + ",hash:" + this.hashCode() + ",info:" + info);
        AcceptanceRulesV2 acceptanceRules = AcceptanceRulesV2.bypassingRules(this.uid);
        Map<String, Object> retDataMap = LiveInfoFactoryV2.make(acceptanceRules, streamsUpdateResponse.channelStreamInfo);
        Map<Long, Map<Short, Long>> metaDataMap = MetaDataFactoryV2.make(streamsUpdateResponse.channelStreamInfo);
        YLKLog.i("YLK", "OpUpdateStreamInfoV2 LiveInfoFactoryV2 make end hash:" + this.hashCode());
        this.completion.didUpdateStreamInfo(((Object)((Object)streamsUpdateResponse)).hashCode(), this.channel, (List)retDataMap.get("AnchorStream"), (Set)retDataMap.get("AudienceStream"), (List)retDataMap.get("GroupInfo"), metaDataMap, (Set)retDataMap.get("TransConfig"));
    }

    public static interface Completion {
        public void didUpdateStreamInfo(long var1, Channel var3, List<LiveInfo> var4, Set<LiveInfo> var5, List<GroupInfo> var6, Map<Long, Map<Short, Long>> var7, Set<TransConfig> var8);
    }
}

