/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.model;

import android.os.Build;
import com.medialib.video.HwCodecConfig;
import com.yy.videoplayer.decoder.H264DecRender;
import com.yy.yylivekit.YLKLive;
import com.yy.yylivekit.model.Channel;
import com.yyproto.utils.FP;
import java.util.List;
import java.util.Map;

public class YLKMediaConfigs {
    public static final String H264 = "h264";
    public static final String H265 = "h265";
    private final List<Integer> h264Thresholds;
    private final List<Integer> h265Thresholds;
    private final int h265DecodeEnable;
    private final Map<Channel, Map<String, List<Integer>>> specialConfig;

    public YLKMediaConfigs(List<Integer> h264thresholds, List<Integer> h265thresholds, Integer h265DecodeEnable, Map specialConfig) {
        this.h264Thresholds = h264thresholds;
        this.h265Thresholds = h265thresholds;
        this.h265DecodeEnable = h265DecodeEnable;
        this.specialConfig = specialConfig;
    }

    public int getH265DecodeEnable() {
        return this.h265DecodeEnable;
    }

    public boolean isSupportH265Decode() {
        return this.h265DecodeEnable > 0;
    }

    public boolean isHwDecodeEnable() {
        return this.isH265HardwareDecodeAvailable() || this.isH264HardwareDecodeAvailable();
    }

    public boolean isH265HardwareDecodeAvailable() {
        return this.h265DecodeEnable == 2;
    }

    public Integer[] getH264Thresholds() {
        List<Integer> h264;
        Channel channel;
        Map<String, List<Integer>> spcialCodeRateMap;
        if (!(FP.empty(this.specialConfig) || FP.empty(spcialCodeRateMap = this.specialConfig.get(channel = YLKLive.instance().getChannel())) || FP.empty(h264 = spcialCodeRateMap.get(H264)))) {
            return h264.toArray(new Integer[0]);
        }
        return this.h264Thresholds.toArray(new Integer[0]);
    }

    public Integer[] getH265Thresholds() {
        List<Integer> h265;
        Channel channel;
        Map<String, List<Integer>> spcialCodeRateMap;
        if (!(FP.empty(this.specialConfig) || FP.empty(spcialCodeRateMap = this.specialConfig.get(channel = YLKLive.instance().getChannel())) || FP.empty(h265 = spcialCodeRateMap.get(H265)))) {
            return h265.toArray(new Integer[0]);
        }
        return this.h265Thresholds.toArray(new Integer[0]);
    }

    public boolean isH264HardwareDecodeAvailable() {
        return Build.VERSION.SDK_INT >= 16 && HwCodecConfig.getH264DecoderSupport() != HwCodecConfig.Support.UNSUPPORTED && H264DecRender.IsAvailable();
    }

    public String toString() {
        return "YLKMediaConfigs{h264Thresholds=" + this.h264Thresholds + ", h265Thresholds=" + this.h265Thresholds + ", h265DecodeEnable=" + this.h265DecodeEnable + ", specialConfig=" + this.specialConfig + '}';
    }
}

