/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.model;

import com.duowan.mobile.mediaproxy.MediaInvoke;
import com.medialib.video.MediaVideoMsg;
import com.yy.yylivekit.model.BuzInfo;
import com.yy.yylivekit.model.MixVideoLayout;
import com.yy.yylivekit.model.VideoGearInfo;
import com.yyproto.utils.FP;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class VideoInfo
implements Serializable,
Cloneable {
    public final int appId;
    public final String streamName;
    public final int codeRate;
    public final int encode;
    public final int fps;
    public final int width;
    public final int height;
    public final int pair;
    public final BuzInfo buzInfo;
    public final MixVideoLayout mixLayout;
    public final boolean isMix;
    public final Set<String> tags;
    public final int source;
    public final boolean isMultSource;
    public final VideoGearInfo videoGearInfo;
    private final ConcurrentHashMap<Integer, Integer> config;

    public VideoInfo(int appId, String streamName, int source, boolean isMs, int width, int height, int codeRate, int encode, int fps, int pair, BuzInfo buzInfo, MixVideoLayout mixLayout, boolean isMix, VideoGearInfo videoGearInfo, Map<Integer, Integer> config, Set<String> tags) {
        this.appId = appId;
        this.streamName = streamName;
        this.source = source;
        this.codeRate = codeRate;
        this.encode = encode;
        this.fps = fps;
        this.width = width;
        this.height = height;
        this.pair = pair;
        this.buzInfo = buzInfo;
        this.mixLayout = mixLayout;
        this.isMix = isMix;
        this.videoGearInfo = videoGearInfo;
        this.config = new ConcurrentHashMap<Integer, Integer>(config);
        this.tags = tags;
        this.isMultSource = isMs;
    }

    public static int fromStreamManagementCodec(int smCodec) {
        switch (smCodec) {
            case 100: {
                return 200;
            }
            case 101: {
                return 220;
            }
        }
        throw new RuntimeException("Unsupported streamManagement codec value: " + smCodec);
    }

    public MediaInvoke.LiveStreamInfo liveStreamInfo() {
        return new MediaInvoke.LiveStreamInfo(this.streamName, this.config);
    }

    public MediaInvoke.LiveStreamInfo liveStreamInfo(Map<Integer, Integer> extraConfig) {
        ConcurrentHashMap<Integer, Integer> newCfg = new ConcurrentHashMap<Integer, Integer>(this.config);
        for (Map.Entry<Integer, Integer> entry : extraConfig.entrySet()) {
            newCfg.put(entry.getKey(), entry.getValue());
        }
        return new MediaInvoke.LiveStreamInfo(this.streamName, newCfg);
    }

    public void enableFastAccess(boolean enable) {
        this.config.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_ENABLE_FAST_ACCESS, enable ? 1 : 0);
    }

    public int changeStreamLine(int line) {
        if (this.mixLayout == null) {
            return 4;
        }
        this.config.put(MediaVideoMsg.LiveStreamCfgKey.STREAM_CONFIG_KEY_STREAM_LINE, line);
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoInfo videoInfo = (VideoInfo)o;
        if (this.appId != videoInfo.appId) {
            return false;
        }
        return this.streamName != null ? this.streamName.equals(videoInfo.streamName) : videoInfo.streamName == null;
    }

    public int hashCode() {
        int result = this.appId;
        result = 31 * result + (this.streamName != null ? this.streamName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "VideoInfo{appId=" + this.appId + ", streamName='" + this.streamName + '\'' + ", codeRate=" + this.codeRate + ", encode=" + this.encode + ", fps=" + this.fps + ", width=" + this.width + ", height=" + this.height + ", pair=" + this.pair + ", buzInfo=" + this.buzInfo + ", mixLayout=" + this.mixLayout + ", isMix=" + this.isMix + ", gear=" + this.videoGearInfo + ", tags=" + this.tags + ", source=" + this.source + ", isMultSource=" + this.isMultSource + ", config=" + this.config + '}';
    }

    public VideoInfo clone() throws CloneNotSupportedException {
        ConcurrentHashMap<Integer, Integer> targetConfig = new ConcurrentHashMap<Integer, Integer>();
        if (!FP.empty(this.config)) {
            targetConfig.putAll(this.config);
        }
        HashSet<String> targetTags = new HashSet<String>();
        if (!FP.empty(this.tags)) {
            targetTags.addAll(this.tags);
        }
        return new VideoInfo(this.appId, this.streamName, this.source, this.isMultSource, this.width, this.height, this.codeRate, this.encode, this.fps, this.pair, this.buzInfo.clone(), this.mixLayout.clone(), this.isMix, this.videoGearInfo, targetConfig, targetTags);
    }
}

