/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.services.core;

import android.annotation.SuppressLint;
import com.yy.yylivekit.services.core.Int64;
import com.yy.yylivekit.services.core.PackException;
import com.yy.yylivekit.services.core.Uint16;
import com.yy.yylivekit.services.core.Uint32;
import com.yy.yylivekit.services.core.Uint64;
import com.yy.yylivekit.services.core.Uint8;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Pack {
    private static final String TAG = "Pack";
    protected ByteBuffer buffer = ByteBuffer.allocateDirect(512);

    public Pack() {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    protected static int normalizeCapacity(int requestedCapacity) {
        int newCapacity;
        if (requestedCapacity < 0) {
            return Integer.MAX_VALUE;
        }
        return (newCapacity <<= (newCapacity = Integer.highestOneBit(requestedCapacity)) < requestedCapacity ? 1 : 0) < 0 ? Integer.MAX_VALUE : newCapacity;
    }

    protected void autoExpand(int expectedRemaining) {
        this.expand(expectedRemaining, true);
    }

    protected void expand(int expectedRemaining, boolean autoExpand) {
        this.expand(this.buffer.position(), expectedRemaining, autoExpand);
    }

    private void expand(int pos, int expectedRemaining, boolean autoExpand) {
        int end = pos + expectedRemaining;
        int newCapacity = autoExpand ? Pack.normalizeCapacity(end) : end;
        if (newCapacity > this.buffer.capacity()) {
            this.capacity(newCapacity);
        }
        if (end > this.buffer.limit()) {
            this.buffer.limit(end);
        }
    }

    public void capacity(int newCapacity) {
        if (newCapacity > this.buffer.capacity()) {
            int pos = this.buffer.position();
            int limit = this.buffer.limit();
            ByteOrder bo = this.buffer.order();
            ByteBuffer oldBuf = this.buffer;
            ByteBuffer newBuf = ByteBuffer.allocate(newCapacity);
            oldBuf.clear();
            newBuf.put(oldBuf);
            this.buffer = newBuf;
            this.buffer.limit(limit);
            this.buffer.position(pos);
            this.buffer.order(bo);
        }
    }

    public void replaceUint32(int pos, Uint32 val) {
        int now = this.buffer.position();
        this.buffer.position(pos);
        this.buffer.putInt(val.intValue()).position(now);
    }

    public void replaceUint16(int pos, Uint16 val) {
        int now = this.buffer.position();
        this.buffer.position(pos);
        this.buffer.putShort(val.shortValue()).position(now);
    }

    public int size() {
        return this.buffer.position();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public byte[] toBytes() {
        this.buffer.flip();
        byte[] bytes = new byte[this.buffer.limit()];
        this.buffer.get(bytes, 0, bytes.length);
        return bytes;
    }

    public Pack push(Uint32 val) {
        if (val == null) {
            throw new PackException("Uint32 is null");
        }
        this.autoExpand(4);
        this.buffer.putInt(val.intValue());
        return this;
    }

    public Pack push(Integer val) {
        if (val == null) {
            throw new PackException("Integer is null");
        }
        this.autoExpand(4);
        this.buffer.putInt(val);
        return this;
    }

    public Pack push(Uint16 val) {
        if (val == null) {
            throw new PackException("Uint16 is null");
        }
        this.autoExpand(2);
        this.buffer.putShort(val.shortValue());
        return this;
    }

    public Pack push(Long val) {
        if (val == null) {
            throw new PackException("Long is null");
        }
        this.autoExpand(8);
        this.buffer.putLong(val);
        return this;
    }

    public Pack push(Int64 val) {
        if (val == null) {
            throw new PackException("Int64 is null");
        }
        this.autoExpand(8);
        this.buffer.putLong(val.longValue());
        return this;
    }

    public Pack push(Uint64 val) {
        if (val == null) {
            throw new PackException("Uint64 is null");
        }
        this.autoExpand(8);
        this.buffer.putLong(val.longValue());
        return this;
    }

    public Pack push(Uint8 val) {
        this.autoExpand(1);
        this.buffer.put(val.byteValue());
        return this;
    }

    public Pack push(byte b) {
        this.autoExpand(1);
        this.buffer.put(b);
        return this;
    }

    public Pack push(boolean val) {
        this.autoExpand(1);
        this.buffer.put((byte)(val ? 1 : 0));
        return this;
    }

    public Pack push(byte[] bytes) {
        this.autoExpand(2 + bytes.length);
        this.push(new Uint16(bytes.length));
        this.buffer.put(bytes);
        return this;
    }

    public Pack pushNoTag(byte[] bytes) {
        this.autoExpand(bytes.length);
        this.buffer.put(bytes);
        return this;
    }

    public Pack pushString32(byte[] bytes) {
        this.autoExpand(4 + bytes.length);
        this.push(new Uint32(bytes.length));
        this.buffer.put(bytes);
        return this;
    }

    public Pack push(String str) {
        try {
            byte[] dst;
            if (str == null) {
                str = "";
            }
            if ((dst = str.getBytes("utf-8")).length > 65535) {
                throw new PackException("String too big");
            }
            return this.push(dst);
        }
        catch (UnsupportedEncodingException codeEx) {
            throw new PackException(codeEx);
        }
    }

    public Pack pushFromByteString(String str) {
        try {
            byte[] dst;
            if (str == null) {
                str = "";
            }
            if ((dst = str.getBytes("ISO-8859-1")).length > 65535) {
                throw new PackException("String too big");
            }
            return this.push(dst);
        }
        catch (UnsupportedEncodingException codeEx) {
            throw new PackException(codeEx);
        }
    }

    public Pack push(String str, String encoding) {
        try {
            byte[] dst;
            if (str == null) {
                str = "";
            }
            if ((dst = str.getBytes(encoding)).length > 65535) {
                throw new PackException("String too big");
            }
            return this.push(dst);
        }
        catch (UnsupportedEncodingException codeEx) {
            throw new PackException(codeEx);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Pack [buffer=");
        builder.append(this.bufferString());
        builder.append("]");
        return builder.toString();
    }

    @SuppressLint(value={"DefaultLocale"})
    private String bufferString() {
        byte[] b = new byte[this.buffer.limit()];
        this.buffer.get(b);
        this.buffer.flip();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            sb.append(Integer.toHexString(b[i] & 0xFF).toUpperCase()).append(" ");
        }
        return sb.toString();
    }
}

