/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.trigger;

import android.os.Handler;
import android.os.HandlerThread;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.trigger.Pulse;

public final class TimerPulse
implements Pulse {
    private static final String TAG = "TimerPulse";
    private final long intervalMillis;
    private final String name;
    private HandlerThread thread;
    private Handler handler;
    private Runnable runnable;

    public TimerPulse(String name) {
        this(name, 1000L);
    }

    public TimerPulse(String name, long intervalMillis) {
        YLKLog.i(TAG, "TimerPulse start " + name + "-Timer");
        this.intervalMillis = intervalMillis;
        this.name = name;
    }

    @Override
    public boolean isAlive() {
        return this.thread == null ? false : this.thread.isAlive();
    }

    @Override
    public void start(final Runnable stimulus) {
        if (this.runnable != null) {
            this.handler.removeCallbacks(this.runnable);
        }
        YLKLog.i(TAG, "TimerPulse start runnable = [" + stimulus + "], " + this.name + "-Timer");
        this.thread = new HandlerThread(this.name + "-Timer");
        this.thread.start();
        this.handler = new Handler(this.thread.getLooper());
        this.runnable = new Runnable(){

            @Override
            public void run() {
                stimulus.run();
                TimerPulse.this.sendMsg(this, TimerPulse.this.intervalMillis);
            }
        };
        this.sendMsg(this.runnable, 0L);
    }

    private void sendMsg(Runnable runnable, long delayMillis) {
        if (this.isAlive()) {
            this.handler.postDelayed(runnable, delayMillis);
        }
    }

    @Override
    public void stop() {
        try {
            YLKLog.i(TAG, "TimerPulse remove runnable:" + this.runnable + ", " + this.name + "-Timer");
            if (this.handler != null) {
                this.handler.removeCallbacks(this.runnable);
                this.runnable = null;
            }
            if (this.thread != null && this.thread.quit()) {
                YLKLog.i(TAG, "TimerPulse close " + this.name + "-Timer");
                this.thread = null;
            }
        }
        catch (Exception e) {
            YLKLog.i(TAG, "stop timePulse exception:" + e);
        }
    }
}

