/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.model;

import com.yy.yylivekit.model.Channel;
import com.yy.yylivekit.utils.DontProguardClass;
import junit.framework.Assert;

@DontProguardClass
public class TransferInfo {
    public final long uid;
    public final long cid;
    public final long sid;
    public final long mMicNo;
    public final FilterType filterType;

    public TransferInfo(long uid, Channel channel, long micNo) {
        this(uid, channel, micNo, FilterType.Nil);
    }

    public TransferInfo(long uid, Channel channel, long micNo, FilterType filterType) {
        Assert.assertNotNull((Object)channel);
        this.uid = uid;
        this.cid = channel.top;
        this.sid = channel.sub;
        this.mMicNo = micNo;
        this.filterType = filterType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferInfo that = (TransferInfo)o;
        if (this.uid != that.uid) {
            return false;
        }
        if (this.cid != that.cid) {
            return false;
        }
        return this.sid == that.sid;
    }

    public int hashCode() {
        int result = (int)(this.uid ^ this.uid >>> 32);
        result = 31 * result + (int)(this.cid ^ this.cid >>> 32);
        result = 31 * result + (int)(this.sid ^ this.sid >>> 32);
        return result;
    }

    public String toString() {
        return "TransferInfo{uid=" + this.uid + ", cid=" + this.cid + ", sid=" + this.sid + ", mic_no=" + this.mMicNo + ", filterType=" + (Object)((Object)this.filterType) + '}';
    }

    public static enum FilterType {
        Nil,
        Video,
        Audio;

    }
}

