/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.utils;

import com.yy.yylivekit.Env;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.VideoQuality;
import com.yy.yylivekit.model.YLKMediaConfigs;
import com.yyproto.utils.FP;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.Assert;

public class VideoQualityCalc {
    private static final String TAG = "VideoQualityCalc";
    private static final Integer[] h264thresholds = new Integer[]{800, 1800, 3999};
    private static final Integer[] h265thresholds = new Integer[]{700, 1500, 3000};

    public static YLKMediaConfigs getDefaultMediaConfigs() {
        return new YLKMediaConfigs(Arrays.asList(h264thresholds), Arrays.asList(h265thresholds), 0, null);
    }

    public static VideoQuality eval(int bitrate, int codec) {
        int idx;
        boolean is265 = codec == 220 || codec == 221;
        Object[] thresholds = VideoQualityCalc.evalThresholds(is265);
        if (FP.empty((Object[])thresholds)) {
            thresholds = is265 ? h265thresholds : h264thresholds;
        }
        YLKLog.i(TAG, "eval thresholds:" + Arrays.toString(thresholds));
        VideoQuality[] qualities = VideoQuality.values();
        for (idx = 0; idx < thresholds.length && bitrate > (Integer)thresholds[idx]; ++idx) {
        }
        if (idx >= qualities.length) {
            return qualities[qualities.length - 1];
        }
        return qualities[idx];
    }

    private static Integer[] evalThresholds(boolean is265) {
        YLKMediaConfigs configs = Env.instance().getYlkMediaConfigs();
        if (configs != null) {
            return is265 ? configs.getH265Thresholds() : configs.getH264Thresholds();
        }
        return null;
    }

    public static VideoQuality findBestMatch(List<VideoQuality> candidates, VideoQuality prefer) {
        int idx;
        Assert.assertTrue((String)"\u65e0\u6cd5\u4ece\u4e00\u4e2a\u7a7a\u5217\u8868\u4e2d\u8fdb\u884c\u6863\u4f4d\u9009\u62e9", (candidates.size() > 0 ? 1 : 0) != 0);
        YLKLog.i(TAG, "findBestMatch candidates:" + candidates + ",prefer:" + (Object)((Object)prefer));
        Collections.sort(candidates, new Comparator<VideoQuality>(){

            @Override
            public int compare(VideoQuality o1, VideoQuality o2) {
                return o1.ordinal() - o2.ordinal();
            }
        });
        for (idx = candidates.size() - 1; idx >= 0 && prefer.ordinal() < candidates.get(idx).ordinal(); --idx) {
        }
        if (idx < 0) {
            return candidates.get(0);
        }
        return candidates.get(idx);
    }
}

