/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience;

import com.yy.IMediaVideo;
import com.yy.IMediaVideoSDK;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.Aliases;
import java.util.Map;

public interface Transfers {
    public Publisher getPublisher();

    public Subscriber getSubscriber();

    public void open();

    public void close();

    public static final class CDNTransfers
    implements Transfers {
        private final IMediaVideo media = IMediaVideoSDK.instance().getMedia();
        private final Subscriber subscriber = new Subscriber(){

            @Override
            public void subscribe(Aliases.StreamInfoMap streams, Aliases.GroupInfoMap groups) {
                YLKLog.i("YLK", "Transfers cdn, streams:" + streams);
                CDNTransfers.this.media.liveSetSubscribeInfo((Map)new Aliases.StreamInfoMap(), (Map)new Aliases.GroupInfoMap(), (Map)streams, (Map)groups);
            }
        };

        @Override
        public Publisher getPublisher() {
            return null;
        }

        @Override
        public Subscriber getSubscriber() {
            return this.subscriber;
        }

        @Override
        public void open() {
            this.media.liveSwitchAnchorSys(false);
        }

        @Override
        public void close() {
        }
    }

    public static final class RapidTransfers
    implements Transfers {
        private final IMediaVideo media = IMediaVideoSDK.instance().getMedia();
        private final Subscriber subscriber = new Subscriber(){

            @Override
            public void subscribe(Aliases.StreamInfoMap streams, Aliases.GroupInfoMap groups) {
                YLKLog.i("YLK", "Transfers rapid, streams:" + streams);
                RapidTransfers.this.media.liveSetSubscribeInfo((Map)streams, (Map)groups, (Map)new Aliases.StreamInfoMap(), (Map)new Aliases.GroupInfoMap());
            }
        };

        @Override
        public Publisher getPublisher() {
            return null;
        }

        @Override
        public Subscriber getSubscriber() {
            return this.subscriber;
        }

        @Override
        public void open() {
            this.media.liveSwitchAnchorSys(true);
        }

        @Override
        public void close() {
        }
    }

    public static interface Subscriber {
        public void subscribe(Aliases.StreamInfoMap var1, Aliases.GroupInfoMap var2);
    }

    public static interface Publisher {
    }
}

