/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit.audience;

import android.os.HandlerThread;
import android.os.Message;
import com.medialib.video.MediaVideoMsg;
import com.yy.IMediaVideo;
import com.yy.IMediaVideoSDK;
import com.yy.mobile.YYHandler;
import com.yy.yylivekit.ILivePlayer;
import com.yy.yylivekit.audience.handle.IHandleMsg;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.threading.RunInMain;
import com.yy.yylivekit.utils.CollectionUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import junit.framework.Assert;

public abstract class AbsLivePlayer
implements ILivePlayer {
    private static final String TAG = "AbsLivePlayer";
    private static final Executor SERIAL_EXECUTOR = new SerialExecutor();
    protected final List<ILivePlayer.PlayerEventHandler> playerEventHandlers = new ArrayList<ILivePlayer.PlayerEventHandler>();
    protected final List<ILivePlayer.QosEventHandler> qosEventHandlers = new ArrayList<ILivePlayer.QosEventHandler>();
    protected final List<ILivePlayer.ViewerEventHandler> viewerEventHandlers = new ArrayList<ILivePlayer.ViewerEventHandler>();
    protected final List<ILivePlayer.StreamEventHandler> streamEventHandlers = new ArrayList<ILivePlayer.StreamEventHandler>();
    protected Map<Integer, IHandleMsg> handleCache = new HashMap<Integer, IHandleMsg>();
    protected IMediaVideo mediaSDK;
    private MsgHandlerThread msgHandlerThread = new MsgHandlerThread("ylk_msg_thread_" + this.hashCode());
    protected YYHandler msgHandler = new YYHandler(this.msgHandlerThread.getLooper()){

        public void handleMessage(Message msg) {
            AbsLivePlayer.this.processMessage(msg.what, msg.obj);
        }
    };

    public AbsLivePlayer() {
        this.mediaSDK = IMediaVideoSDK.instance().getMedia();
        this.setupMessageHandle();
    }

    protected static String subscribeStatus(int code) {
        if (code == MediaVideoMsg.LiveSubcribeStatus.LIVE_SUBCRIBE_SUCCESS) {
            return "Success";
        }
        if (code == MediaVideoMsg.LiveSubcribeStatus.LIVE_SUBCRIBE_PARAM_ERROR) {
            return "Error";
        }
        if (code == MediaVideoMsg.LiveSubcribeStatus.LIVE_SUBCRIBE_FAILED) {
            return "Failed";
        }
        if (code == MediaVideoMsg.LiveSubcribeStatus.LIVE_SUBCRIBE_CANCEL) {
            return "Cancel";
        }
        return "" + code;
    }

    protected static String videoStreamStatus(int code) {
        if (code == MediaVideoMsg.LiveVideoStreamStatus.LIVE_VIDEOSTREAM_STATUS_ARRIVE) {
            return "Arrive";
        }
        if (code == MediaVideoMsg.LiveVideoStreamStatus.LIVE_VIDEOSTREAM_STATUS_START) {
            return "Start";
        }
        if (code == MediaVideoMsg.LiveVideoStreamStatus.LIVE_VIDEOSTREAM_STATUS_STOP) {
            return "Stop";
        }
        return "" + code;
    }

    protected static String audioStreamStatus(int code) {
        if (code == MediaVideoMsg.LiveAudioStreamStatus.LIVE_AUDIOSTREAM_STATUS_UID_CHANGE) {
            return "UID_CHANGE";
        }
        if (code == MediaVideoMsg.LiveAudioStreamStatus.LIVE_AUDIOSTREAM_STATUS_START) {
            return "START";
        }
        if (code == MediaVideoMsg.LiveAudioStreamStatus.LIVE_AUDIOSTREAM_STATUS_STOP) {
            return "STOP";
        }
        return "" + code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addViewerEventHandler(ILivePlayer.ViewerEventHandler handler) {
        Assert.assertNotNull((Object)handler);
        List<ILivePlayer.ViewerEventHandler> list = this.viewerEventHandlers;
        synchronized (list) {
            this.viewerEventHandlers.add(handler);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeViewerEventHandler(ILivePlayer.ViewerEventHandler eventHandler) {
        Assert.assertNotNull((Object)eventHandler);
        List<ILivePlayer.ViewerEventHandler> list = this.viewerEventHandlers;
        synchronized (list) {
            this.viewerEventHandlers.remove(eventHandler);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addPlayerEventHandler(ILivePlayer.PlayerEventHandler handler) {
        Assert.assertNotNull((Object)handler);
        List<ILivePlayer.PlayerEventHandler> list = this.playerEventHandlers;
        synchronized (list) {
            this.playerEventHandlers.add(handler);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removePlayerEventHandler(ILivePlayer.PlayerEventHandler eventHandler) {
        Assert.assertNotNull((Object)eventHandler);
        List<ILivePlayer.PlayerEventHandler> list = this.playerEventHandlers;
        synchronized (list) {
            this.playerEventHandlers.remove(eventHandler);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQosEventHandler(ILivePlayer.QosEventHandler handler) {
        Assert.assertNotNull((Object)handler);
        List<ILivePlayer.QosEventHandler> list = this.qosEventHandlers;
        synchronized (list) {
            this.qosEventHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQosEventHandler(ILivePlayer.QosEventHandler handler) {
        Assert.assertNotNull((Object)handler);
        List<ILivePlayer.QosEventHandler> list = this.qosEventHandlers;
        synchronized (list) {
            this.qosEventHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamEventHandler(ILivePlayer.StreamEventHandler handler) {
        Assert.assertNotNull((Object)handler);
        List<ILivePlayer.StreamEventHandler> list = this.streamEventHandlers;
        synchronized (list) {
            this.streamEventHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStreamEventHandler(ILivePlayer.StreamEventHandler handler) {
        Assert.assertNotNull((Object)handler);
        List<ILivePlayer.StreamEventHandler> list = this.streamEventHandlers;
        synchronized (list) {
            this.streamEventHandlers.remove(handler);
        }
    }

    public abstract boolean isStartState();

    protected abstract void setupMessageHandle();

    protected void registerHandler(Integer key, IHandleMsg msg) {
        this.handleCache.put(key, msg);
    }

    protected void unRegisterHandler() {
        this.handleCache.clear();
        this.msgHandlerThread.quit();
    }

    private void processMessage(final int what, final Object obj) {
        final IHandleMsg handleMsg = this.handleCache.get(what);
        if (handleMsg == null || !this.isStartState() || obj == null) {
            return;
        }
        if (what == 503) {
            YLKLog.i(TAG, "processMessage what=" + what + ",obj:" + obj + "handleMsg:" + handleMsg);
            SERIAL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    if (handleMsg != null && AbsLivePlayer.this.isStartState() && obj != null) {
                        handleMsg.handle(obj);
                        YLKLog.i(AbsLivePlayer.TAG, "execute what=" + what + ",obj:" + obj + "handleMsg:" + handleMsg);
                    }
                }
            });
        } else {
            RunInMain.dispatch(new Runnable(){

                @Override
                public void run() {
                    if (handleMsg != null && AbsLivePlayer.this.isStartState() && obj != null) {
                        handleMsg.handle(obj);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void iterateViewerEventHandlers(CollectionUtils.Visitor<ILivePlayer.ViewerEventHandler> visitor) {
        List<ILivePlayer.ViewerEventHandler> list = this.viewerEventHandlers;
        synchronized (list) {
            CollectionUtils.iterate(this.viewerEventHandlers, visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void iterateQosEventHandlers(CollectionUtils.Visitor<ILivePlayer.QosEventHandler> visitor) {
        List<ILivePlayer.QosEventHandler> list = this.qosEventHandlers;
        synchronized (list) {
            CollectionUtils.iterate(this.qosEventHandlers, visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void iteratePlayerEventHandlers(CollectionUtils.Visitor<ILivePlayer.PlayerEventHandler> visitor) {
        List<ILivePlayer.PlayerEventHandler> list = this.playerEventHandlers;
        synchronized (list) {
            CollectionUtils.iterate(this.playerEventHandlers, visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void iterateStreamEventHandlers(CollectionUtils.Visitor<ILivePlayer.StreamEventHandler> visitor) {
        List<ILivePlayer.StreamEventHandler> list = this.streamEventHandlers;
        synchronized (list) {
            CollectionUtils.iterate(this.streamEventHandlers, visitor);
        }
    }

    private static class SerialExecutor
    implements Executor {
        final ArrayDeque<Runnable> mTasks = new ArrayDeque();
        Runnable mActive;

        private SerialExecutor() {
        }

        @Override
        public synchronized void execute(final Runnable r) {
            this.mTasks.offer(new Runnable(){

                @Override
                public void run() {
                    try {
                        r.run();
                    }
                    finally {
                        SerialExecutor.this.scheduleNext();
                    }
                }
            });
            if (this.mActive == null) {
                this.scheduleNext();
            }
        }

        protected synchronized void scheduleNext() {
            this.mActive = this.mTasks.poll();
            if (this.mActive != null) {
                RunInMain.dispatchAtFrontOfQueue(this.mActive);
            }
        }
    }

    private static class MsgHandlerThread
    extends HandlerThread {
        MsgHandlerThread(String name) {
            super(name);
            this.start();
        }
    }
}

