/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivekit;

import android.content.Context;
import android.os.Build;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.yylivekit.log.YLKLog;
import com.yy.yylivekit.model.AppIDSet;
import com.yy.yylivekit.model.AppNames;
import com.yy.yylivekit.model.Channel;
import com.yy.yylivekit.model.ClientRole;
import com.yy.yylivekit.model.HardwareEncodeBlacklist;
import com.yy.yylivekit.model.HeartbeatIntervalSec;
import com.yy.yylivekit.model.LiveMeta;
import com.yy.yylivekit.model.NewSystemSupports;
import com.yy.yylivekit.model.VideoQuality;
import com.yy.yylivekit.model.YLKMediaConfigs;
import com.yy.yylivekit.services.Service;
import com.yy.yylivekit.utils.VideoQualityCalc;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class Env {
    public static final String TAG = "YLK";
    public static final int STREAM_SERVICE_ROUTER = 10588;
    public static final int STREAM_UPDATE_APPID = 10599;
    public static final int STREAM_RECORD_APPID = 10557;
    public int defaultVideoLineNum = -1;
    public long currentStreamVersion = 0L;
    private HardwareEncodeBlacklist blacklist;
    private Context context;
    private Integer modifyInterval;
    private Map<VideoQuality, LiveMeta.EncodeMeta> qualityEncodeMetaMap;
    private Map<Integer, LiveMeta.EncodeMeta> encodeMetaMap;
    private YLKMediaConfigs ylkMediaConfigs;
    private NewSystemSupports newSystem;
    private HeartbeatIntervalSec heartbeatSec;
    private String streamManageToken;
    private long streaManageVer;
    private AppNames names;
    private String configsVersion;
    private AppIDSet appIDs;
    private ClientRole role = ClientRole.Audience;
    private byte hwEnableCustomerVal = 0;

    private Env() {
    }

    public static Env instance() {
        return Holder.instance;
    }

    static boolean isReady() {
        return Service.isReady();
    }

    public void onInitSysParams(NewSystemSupports newSystemSupports, HeartbeatIntervalSec heartbeatIntervalSec) {
        this.newSystem = newSystemSupports;
        this.heartbeatSec = heartbeatIntervalSec;
    }

    public void onUpdateEncodeMeta(Integer modifyInterval, Map<Integer, LiveMeta.EncodeMeta> encodeMetaMap, HardwareEncodeBlacklist blacklist) {
        YLKLog.i(TAG, "onUpdateEncodeMeta: " + encodeMetaMap);
        if (FP.empty(encodeMetaMap)) {
            YLKLog.e(TAG, "onUpdateEncodeMeta encodeMetaMap empty ");
            return;
        }
        this.blacklist = blacklist;
        this.encodeMetaMap = encodeMetaMap;
        HashMap<VideoQuality, LiveMeta.EncodeMeta> h264EncodeMap = new HashMap<VideoQuality, LiveMeta.EncodeMeta>();
        HashMap<VideoQuality, LiveMeta.EncodeMeta> h265EncodeMap = new HashMap<VideoQuality, LiveMeta.EncodeMeta>();
        for (LiveMeta.EncodeMeta encodeMeta : encodeMetaMap.values()) {
            if (encodeMeta.type == 200 || encodeMeta.type == 201) {
                h264EncodeMap.put(VideoQualityCalc.eval(encodeMeta.currate, encodeMeta.type), encodeMeta);
                continue;
            }
            if (encodeMeta.type != 220 && encodeMeta.type != 221) continue;
            h265EncodeMap.put(VideoQualityCalc.eval(encodeMeta.currate, encodeMeta.type), encodeMeta);
        }
        HashMap<VideoQuality, LiveMeta.EncodeMeta> qualityEncodeMetaMap = new HashMap<VideoQuality, LiveMeta.EncodeMeta>(h265EncodeMap);
        for (Map.Entry entry : h264EncodeMap.entrySet()) {
            if (h265EncodeMap.keySet().contains(entry.getKey())) continue;
            qualityEncodeMetaMap.put((VideoQuality)((Object)entry.getKey()), (LiveMeta.EncodeMeta)entry.getValue());
        }
        this.modifyInterval = modifyInterval;
        this.qualityEncodeMetaMap = qualityEncodeMetaMap;
        YLKLog.i(TAG, "qualityEncodeMetaMap:" + qualityEncodeMetaMap);
    }

    public void onUpdateMediaConfig(YLKMediaConfigs params) {
        YLKLog.i(TAG, "updateMediaConfig: " + params);
        this.ylkMediaConfigs = params;
    }

    void init(Context ctx, AppNames names, String configsVersion, AppIDSet appIDs) {
        this.context = ctx;
        this.names = names;
        this.configsVersion = configsVersion;
        this.appIDs = appIDs;
        this.streamManageToken = String.valueOf(System.currentTimeMillis()) + "_" + UUID.randomUUID().toString();
        this.streaManageVer = System.currentTimeMillis() * 1000L;
    }

    boolean isNewSysSupport(Channel channel) {
        return this.newSystem.channelSupported(channel);
    }

    public Context context() {
        return this.context;
    }

    public AppIDSet appIDs() {
        return this.appIDs;
    }

    void setAppIDs(AppIDSet appIDs) {
        this.appIDs = appIDs;
    }

    public AppNames names() {
        return this.names;
    }

    public String configsVersion() {
        return this.configsVersion;
    }

    public HeartbeatIntervalSec heartbeatIntervalSec() {
        return this.heartbeatSec;
    }

    public List<VideoQuality> availableQualities() {
        return new ArrayList<VideoQuality>(this.qualityEncodeMetaMap().keySet());
    }

    public Map<VideoQuality, LiveMeta.EncodeMeta> qualityEncodeMetaMap() {
        this.onUpdateEncodeMeta(this.modifyInterval, this.encodeMetaMap, this.blacklist);
        return new HashMap<VideoQuality, LiveMeta.EncodeMeta>(this.qualityEncodeMetaMap);
    }

    public int modifyInterval() {
        return this.modifyInterval;
    }

    public YLKMediaConfigs getYlkMediaConfigs() {
        if (this.ylkMediaConfigs == null) {
            this.ylkMediaConfigs = VideoQualityCalc.getDefaultMediaConfigs();
        }
        return this.ylkMediaConfigs;
    }

    public ClientRole getRole() {
        return this.role;
    }

    public void setRole(ClientRole role) {
        this.role = role;
    }

    public String getStreamManageToken() {
        return this.streamManageToken;
    }

    public long getStreamManageVer() {
        return this.streaManageVer;
    }

    public long incStreamManageVer() {
        return ++this.streaManageVer;
    }

    public void setHwEnableCustomerValue(int hwEnableKey) {
        switch (hwEnableKey) {
            case 302: {
                this.hwEnableCustomerVal = (byte)(this.hwEnableCustomerVal | 0xF);
                break;
            }
            case 316: {
                this.hwEnableCustomerVal = (byte)(this.hwEnableCustomerVal | 0xF0);
                break;
            }
        }
    }

    public boolean isCustomerSetH265HwEnable() {
        return (this.hwEnableCustomerVal & 0xF0) > 0;
    }

    public boolean isCustomerSetH264HwEnable() {
        return (this.hwEnableCustomerVal & 0xF) > 0;
    }

    public boolean isHardwareEncoderType(int normalized) {
        switch (normalized) {
            case 201: 
            case 221: {
                return false;
            }
            case 200: 
            case 220: {
                return true;
            }
        }
        return false;
    }

    public void adjustHardwareEncode() {
        HashMap<VideoQuality, LiveMeta.EncodeMeta> encodeMetaMap = new HashMap<VideoQuality, LiveMeta.EncodeMeta>();
        Set<Map.Entry<VideoQuality, LiveMeta.EncodeMeta>> entrySet = this.qualityEncodeMetaMap().entrySet();
        for (Map.Entry<VideoQuality, LiveMeta.EncodeMeta> entry : entrySet) {
            LiveMeta.EncodeMeta meta = entry.getValue();
            VideoQuality quality = entry.getKey();
            int encodeId = this.adjustedEncodeId(meta.type, this.blacklist);
            if (encodeId != meta.type) {
                YLKLog.i(TAG, "adjustHardwareEncode from: " + meta.type + " to:" + encodeId);
                if (!this.isHardwareEncoderType(encodeId)) {
                    meta.param = "";
                }
                for (LiveMeta.ModifyMeta modifyMeta : meta.modifyMetaList) {
                    modifyMeta.encodeId = encodeId;
                    if (this.isHardwareEncoderType(encodeId)) continue;
                    modifyMeta.encodeParam = "";
                }
                meta.type = encodeId;
            }
            encodeMetaMap.put(quality, meta);
        }
        this.qualityEncodeMetaMap = encodeMetaMap;
        YLKLog.i(TAG, "adjustHardwareEncode qualityEncodeMeta: " + this.qualityEncodeMetaMap);
    }

    private int adjustedEncodeId(int raw, HardwareEncodeBlacklist blacklist) {
        if (blacklist.contains(Build.MODEL) || blacklist.contains(YYVideoCodec.getH264EncodeName()) || blacklist.contains(YYVideoCodec.getH265EncodeName())) {
            if (raw == 200) {
                return 201;
            }
            if (raw == 220) {
                return 221;
            }
        }
        return raw;
    }

    private static class Holder {
        private static final Env instance = new Env();

        private Holder() {
        }
    }
}

