/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.transfer;

import com.yy.yycloud.bs2.BS2ClientException;
import com.yy.yycloud.bs2.transfer.PersistableTransfer;
import com.yy.yycloud.bs2.utility.Utility;
import org.json.JSONObject;

public class PersistableUpload
implements PersistableTransfer {
    private String bucketName;
    private String key;
    private String file;
    private String uploadId;
    private long partSize;

    public PersistableUpload() {
    }

    PersistableUpload(String bucketName, String key, String file, String uploadId, long partSize) {
        this.bucketName = bucketName;
        this.key = key;
        this.file = file;
        this.uploadId = uploadId;
        this.partSize = partSize;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKey() {
        return this.key;
    }

    public String getFile() {
        return this.file;
    }

    String getUploadId() {
        return this.uploadId;
    }

    long getPartSize() {
        return this.partSize;
    }

    @Override
    public String serialize() {
        return String.format("{\"version\":\"1.0\",\"bucket\":\"%s\",\"key\":\"%s\",\"uploadId\":\"%s\",\"file\":\"%s\",\"partSize\":%d}", this.bucketName, this.key, this.uploadId, this.file, this.partSize);
    }

    @Override
    public void deserialize(String str) {
        try {
            JSONObject json = new JSONObject(str);
            this.bucketName = (String)json.get("bucket");
            this.key = (String)json.get("key");
            this.uploadId = (String)json.get("uploadId");
            this.file = (String)json.get("file");
            this.partSize = ((Integer)json.get("partSize")).intValue();
            Utility.rejectNull(this.bucketName, "bucketname is not setted");
            Utility.rejectNull(this.key, "keyname is not setted");
            Utility.rejectNull(this.uploadId, "uploadId is not setted");
            Utility.rejectNull(this.file, "file is not setted");
            Utility.rejectEmptyValue(this.bucketName, "bucketname can't be empty string");
            Utility.rejectEmptyValue(this.key, "keyname can't be empty string");
            Utility.rejectEmptyValue(this.uploadId, "uploadId can't be empty string");
            Utility.rejectEmptyValue(this.file, "file can't be empty string");
            Utility.rejectEmptyValue(this.partSize, "partSize can't be empty string");
        }
        catch (Exception e) {
            throw new BS2ClientException("deserialize from string error", e);
        }
    }
}

