/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.transfer;

import com.yy.yycloud.bs2.BS2ClientException;
import com.yy.yycloud.bs2.BS2ServiceException;
import com.yy.yycloud.bs2.transfer.Delete;
import com.yy.yycloud.bs2.transfer.DeleteCallable;
import com.yy.yycloud.bs2.transfer.Transfer;
import com.yy.yycloud.bs2.transfer.TransferProgress;
import com.yy.yycloud.bs2.transfer.model.DeleteResult;
import com.yy.yycloud.bs2.utility.Logger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class DeleteImpl
implements Delete {
    private static Logger log = Logger.getLogger(DeleteImpl.class);
    private Future<DeleteResult> future;
    private DeleteCallable callable;

    public DeleteImpl(Future<DeleteResult> future, DeleteCallable callable) {
        this.future = future;
        this.callable = callable;
    }

    @Override
    public DeleteResult waitForDeleteResult() throws BS2ServiceException, BS2ClientException, InterruptedException {
        try {
            return this.future.get();
        }
        catch (ExecutionException ee) {
            log.warn("get future result exception , ee:%s ", ee.toString());
            ee.printStackTrace();
            Throwable e = ee.getCause();
            if (e instanceof BS2ClientException) {
                throw (BS2ClientException)e;
            }
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            throw new BS2ClientException(e.toString(), e);
        }
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public Transfer.TransferState getState() {
        return this.callable.getState();
    }

    @Override
    public TransferProgress getProgress() {
        return null;
    }

    @Override
    public BS2ClientException getException() {
        return this.callable.getException();
    }
}

