/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.utility;

import com.yy.yycloud.bs2.conf.ConfigLogging;

public class Logger {
    private java.util.logging.Logger logger;
    private static final String TAG = "BS2SDK";
    private String className;

    private Logger(java.util.logging.Logger logger, String className) {
        this.logger = logger;
        this.className = className;
    }

    private String prefix() {
        return String.format("[%s] [%s]  ", TAG, this.className);
    }

    public static Logger getLogger(Class<?> cls) {
        return new Logger(java.util.logging.Logger.getLogger(cls.getName()), cls.getName());
    }

    public void trace(String format, Object ... args) {
        if (!ConfigLogging.isLoggingOn()) {
            return;
        }
        if (ConfigLogging.getLevel().ordinal() > ConfigLogging.Level.TRACE.ordinal()) {
            return;
        }
        this.logger.info(this.prefix() + String.format(format, args));
    }

    public void debug(String format, Object ... args) {
        if (!ConfigLogging.isLoggingOn()) {
            return;
        }
        if (ConfigLogging.getLevel().ordinal() > ConfigLogging.Level.DEBUG.ordinal()) {
            return;
        }
        this.logger.info(this.prefix() + String.format(format, args));
    }

    public void info(String format, Object ... args) {
        if (!ConfigLogging.isLoggingOn()) {
            return;
        }
        if (ConfigLogging.getLevel().ordinal() > ConfigLogging.Level.INFO.ordinal()) {
            return;
        }
        this.logger.info(this.prefix() + String.format(format, args));
    }

    public void warn(String format, Object ... args) {
        if (!ConfigLogging.isLoggingOn()) {
            return;
        }
        if (ConfigLogging.getLevel().ordinal() > ConfigLogging.Level.WARN.ordinal()) {
            return;
        }
        this.logger.warning(this.prefix() + String.format(format, args));
    }

    public void error(String format, Object ... args) {
        if (!ConfigLogging.isLoggingOn()) {
            return;
        }
        if (ConfigLogging.getLevel().ordinal() > ConfigLogging.Level.ERROR.ordinal()) {
            return;
        }
        this.logger.severe(this.prefix() + String.format(format, args));
    }
}

