/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.uploader.impl;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.yy.yycloud.bs2.BS2ClientException;
import com.yy.yycloud.bs2.BS2Consts;
import com.yy.yycloud.bs2.BS2ServiceException;
import com.yy.yycloud.bs2.auth.BS2SessionCredentials;
import com.yy.yycloud.bs2.dns.SmartDnsResolver;
import com.yy.yycloud.bs2.event.ProgressEvent;
import com.yy.yycloud.bs2.event.ProgressEventType;
import com.yy.yycloud.bs2.event.UiProgressListener;
import com.yy.yycloud.bs2.model.PutObjectRequest;
import com.yy.yycloud.bs2.model.ResumeUploadRequest;
import com.yy.yycloud.bs2.transfer.PersistableTransfer;
import com.yy.yycloud.bs2.transfer.PersistableUpload;
import com.yy.yycloud.bs2.transfer.TransferManager;
import com.yy.yycloud.bs2.transfer.TransferProgress;
import com.yy.yycloud.bs2.transfer.Upload;
import com.yy.yycloud.bs2.transfer.model.UploadResult;
import com.yy.yycloud.bs2.uploader.IUploader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class UploaderImpl
implements IUploader,
BS2SessionCredentials {
    private static final String TAG = "UploaderImpl";
    private Set<IUploader.IUploaderEventListener> m_uploader_listener_set = new HashSet<IUploader.IUploaderEventListener>();
    private IUploader.IUploaderTokenDelegate m_token_delegate;
    private String m_file_key;
    private String m_bucket;
    private long m_block_size = 0x100000L;
    private Upload m_upload;
    private PersistableUpload m_persist_upload;
    private TransferManager m_transfer_manager = new TransferManager((BS2SessionCredentials)this, new SmartDnsResolver());
    private String m_download_url;
    private Handler m_handler;
    private InputStream m_input_stream;
    private String m_contentType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int init(String bucket, String file_key, InputStream input_stream, IUploader.IUploaderTokenDelegate delegate) {
        if (null == bucket || null == file_key || null == input_stream || null == delegate) {
            return BS2Consts.RES.e_param_error;
        }
        this.m_bucket = bucket;
        this.m_file_key = file_key;
        this.m_input_stream = input_stream;
        UploaderImpl uploaderImpl = this;
        synchronized (uploaderImpl) {
            this.m_token_delegate = delegate;
        }
        this.m_handler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                ProgressEvent progressEvent = (ProgressEvent)msg.obj;
                for (IUploader.IUploaderEventListener listener : UploaderImpl.this.m_uploader_listener_set) {
                    if (null != UploaderImpl.this.m_upload) {
                        TransferProgress progress = UploaderImpl.this.m_upload.getProgress();
                        listener.onProcess(UploaderImpl.this, (float)progress.getPercentTransferred(), progress.getTotalBytesToTransfer(), progress.getBytesTransferred());
                    }
                    switch (progressEvent.getEventType()) {
                        case TRANSFER_STARTED_EVENT: {
                            listener.onStart(UploaderImpl.this);
                            break;
                        }
                        case TRANSFER_COMPLETED_EVENT: {
                            listener.onComplete(UploaderImpl.this, UploaderImpl.this.m_download_url);
                            UploaderImpl.this.m_upload = null;
                            UploaderImpl.this.m_persist_upload = null;
                            break;
                        }
                        case TRANSFER_FAILED_EVENT: {
                            listener.onError(UploaderImpl.this, BS2Consts.RES.e_upload_error);
                        }
                    }
                }
            }
        };
        return BS2Consts.RES.success;
    }

    @Override
    public void setContentType(String type) {
        this.m_contentType = type;
    }

    @Override
    public int start() {
        if (this.m_upload != null) {
            return BS2Consts.RES.success;
        }
        try {
            PutObjectRequest request = new PutObjectRequest();
            request.withBucketName(this.m_bucket).withKeyName(this.m_file_key).withInput(this.m_input_stream).withBlockSize(this.m_block_size).withSize(this.m_input_stream.available()).withProgressListener(new UiProgressListener(){

                @Override
                public void HandleProgressChanged(ProgressEvent progressEvent) {
                    if (progressEvent.getEventType() == ProgressEventType.TRANSFER_COMPLETED_EVENT && UploaderImpl.this.m_upload != null) {
                        try {
                            UploadResult result = UploaderImpl.this.m_upload.waitForUploadResult();
                            UploaderImpl.this.m_download_url = result.getDownloadUrl();
                        }
                        catch (InterruptedException e) {
                            for (IUploader.IUploaderEventListener listener : UploaderImpl.this.m_uploader_listener_set) {
                                listener.onError(UploaderImpl.this, BS2Consts.RES.e_upload_error);
                            }
                        }
                    }
                    Message msg = UploaderImpl.this.m_handler.obtainMessage();
                    msg.obj = progressEvent;
                    msg.sendToTarget();
                }

                @Override
                public void HandlePersistableTransfer(PersistableTransfer persistableTransfer) {
                }
            });
            if (this.m_contentType != null) {
                request.setContentType(this.m_contentType);
            }
            this.m_upload = this.m_transfer_manager.upload(request);
        }
        catch (IOException e) {
            return BS2Consts.RES.error;
        }
        return BS2Consts.RES.success;
    }

    @Override
    public int stop() {
        if (null == this.m_upload) {
            Log.e((String)TAG, (String)"unable to stop,need to start upload first");
            return BS2Consts.RES.e_param_error;
        }
        this.m_persist_upload = this.m_upload.cancel();
        if (null == this.m_persist_upload) {
            return BS2Consts.RES.error;
        }
        return BS2Consts.RES.success;
    }

    @Override
    public int pause() {
        if (null == this.m_upload) {
            Log.e((String)TAG, (String)"unable to pause, need to start upload first");
            return BS2Consts.RES.e_param_error;
        }
        this.m_persist_upload = this.m_upload.cancel();
        if (null == this.m_persist_upload) {
            return BS2Consts.RES.error;
        }
        return BS2Consts.RES.success;
    }

    @Override
    public int resume() {
        if (null == this.m_persist_upload) {
            Log.e((String)TAG, (String)"unable to resume,need to start upload from a file and cancel");
            return BS2Consts.RES.e_param_error;
        }
        ResumeUploadRequest request = new ResumeUploadRequest();
        request.withPersistableUpload(this.m_persist_upload).withProgressListener(new UiProgressListener(){

            @Override
            public void HandleProgressChanged(ProgressEvent progressEvent) {
                Message msg = UploaderImpl.this.m_handler.obtainMessage();
                msg.obj = progressEvent;
                msg.sendToTarget();
            }

            @Override
            public void HandlePersistableTransfer(PersistableTransfer persistableTransfer) {
            }
        });
        if (this.m_contentType != null) {
            request.setContentType(this.m_contentType);
        }
        this.m_upload = this.m_transfer_manager.resumeUpload(request);
        this.m_persist_upload = null;
        return BS2Consts.RES.success;
    }

    @Override
    public synchronized String getDownloadUrl() {
        return this.m_download_url;
    }

    @Override
    public int addEventListener(IUploader.IUploaderEventListener e) {
        if (this.m_uploader_listener_set.add(e)) {
            return BS2Consts.RES.success;
        }
        return BS2Consts.RES.error;
    }

    @Override
    public int removeEventListener(IUploader.IUploaderEventListener e) {
        if (this.m_uploader_listener_set.remove(e)) {
            return BS2Consts.RES.success;
        }
        return BS2Consts.RES.error;
    }

    @Override
    public int setUploadBlockSize(long block_size) {
        if (block_size <= 0L) {
            return BS2Consts.RES.e_param_error;
        }
        this.m_block_size = block_size;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSessionToken(String bucket, String key, String method) throws BS2ServiceException, BS2ClientException {
        UploaderImpl uploaderImpl = this;
        synchronized (uploaderImpl) {
            if (null != this.m_token_delegate) {
                return this.m_token_delegate.getToken(bucket, key, method);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSessionToken(String bucket, String key, String method, int exp) throws BS2ServiceException, BS2ClientException {
        UploaderImpl uploaderImpl = this;
        synchronized (uploaderImpl) {
            if (null != this.m_token_delegate) {
                return this.m_token_delegate.getToken(bucket, key, method);
            }
        }
        return null;
    }
}

