/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.transfer;

import com.yy.yycloud.bs2.BS2ClientException;
import com.yy.yycloud.bs2.BS2ServiceException;
import com.yy.yycloud.bs2.auth.BS2SessionCredentials;
import com.yy.yycloud.bs2.dns.DnsResolver;
import com.yy.yycloud.bs2.event.ProgressEvent;
import com.yy.yycloud.bs2.event.ProgressEventType;
import com.yy.yycloud.bs2.event.ProgressListener;
import com.yy.yycloud.bs2.model.BS2WebServiceRequest;
import com.yy.yycloud.bs2.model.CompleteMultiPartUploadRequest;
import com.yy.yycloud.bs2.model.CompleteMultiPartUploadResult;
import com.yy.yycloud.bs2.model.GetLastPartRequest;
import com.yy.yycloud.bs2.model.GetLastPartResult;
import com.yy.yycloud.bs2.model.InitMultiPartUploadRequest;
import com.yy.yycloud.bs2.model.InitMultiPartUploadResult;
import com.yy.yycloud.bs2.model.UploadOnceRequest;
import com.yy.yycloud.bs2.model.UploadOnceResult;
import com.yy.yycloud.bs2.model.UploadPartRequest;
import com.yy.yycloud.bs2.model.UploadPartResult;
import com.yy.yycloud.bs2.stat.StatReporter;
import com.yy.yycloud.bs2.stat.model.TxUploadStat;
import com.yy.yycloud.bs2.transfer.BS2;
import com.yy.yycloud.bs2.transfer.PersistableUpload;
import com.yy.yycloud.bs2.transfer.Transfer;
import com.yy.yycloud.bs2.transfer.model.UploadResult;
import com.yy.yycloud.bs2.utility.Logger;
import com.yy.yycloud.bs2.utility.Utility;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.Callable;

class UploadCallable
implements Callable<UploadResult> {
    private static final long DEFAULT_BLOCK_SIZE = 524288L;
    private static final long MIN_BLOCK_SIZE = 10240L;
    private static final long MAX_BLOCK_SIZE = 102400L;
    private static final long MAX_FILE_SIZE = 0x2000000L;
    private static Logger log = Logger.getLogger(UploadCallable.class);
    private BS2 bs2Client;
    private String bucket;
    private String key;
    private String uploadId;
    private BufferedInputStream input;
    private File file;
    private Long blockSize;
    private boolean forceOnceUpload;
    private BS2SessionCredentials requestCredentials;
    private Integer retryTimes;
    private Integer retryInterval;
    private Integer connectTimeout;
    private Integer readTimeout;
    private Integer writeTimeout;
    private Map<String, String> customQueryParameters;
    private Map<String, String> customRequestHeaders;
    private DnsResolver dnsResolver;
    private ProgressListener progressListener;
    private boolean isCanceled = false;
    private volatile long size = 0L;
    private volatile long bytesCompleted = 0L;
    private Transfer.TransferState state = Transfer.TransferState.Waiting;
    private PersistableUpload persistUpload = null;
    private String requestId;
    private TxUploadStat txStat;
    private BS2ClientException exception;

    public UploadCallable(BS2 bs2Client, String bucket, String key, String uploadId, InputStream input, File file, long size, Long blockSize, boolean forceOnceUpload, BS2SessionCredentials requestCredentials, Integer retryTimes, Integer retryInterval, Integer connectTimeout, Integer readTimeout, Integer writeTimeout, Map<String, String> customQueryParameters, Map<String, String> customRequestHeaders, DnsResolver dnsResolver, ProgressListener progressListener) {
        this.bs2Client = bs2Client;
        this.bucket = bucket;
        this.key = key;
        this.uploadId = uploadId;
        this.input = new BufferedInputStream(input);
        this.file = file;
        this.size = size;
        this.forceOnceUpload = forceOnceUpload;
        this.requestCredentials = requestCredentials;
        this.retryTimes = retryTimes;
        this.retryInterval = retryInterval;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.customQueryParameters = customQueryParameters;
        this.customRequestHeaders = customRequestHeaders;
        this.dnsResolver = dnsResolver;
        this.progressListener = progressListener;
        this.blockSize = blockSize != null ? blockSize : 524288L;
        this.blockSize = Math.max(this.blockSize, 10240L);
        this.requestId = Utility.generateRequestId();
        this.txStat = new TxUploadStat();
        this.txStat.calledTick = System.currentTimeMillis();
        this.txStat.txRequestId = this.requestId;
        this.txStat.bucketName = bucket;
        this.txStat.keyName = key;
        this.txStat.uploadId = uploadId;
        this.txStat.forceOnceUpload = forceOnceUpload ? 1 : 0;
        this.txStat.confPartSize = this.blockSize;
        this.txStat.confRetryTimes = retryTimes;
        this.txStat.confRetryInterval = retryInterval;
        this.txStat.confConnectTimeout = connectTimeout;
        this.txStat.confReadTimeout = readTimeout;
        this.txStat.confWriteTimeout = writeTimeout;
        this.txStat.totalUploadParts = 0;
        this.txStat.totalUploadBytes = 0L;
        this.txStat.fileSize = size == -1L ? null : Long.valueOf(size);
    }

    private void info(String msg, Object ... array) {
        log.info(String.format("[%d] ", this.hashCode()) + String.format(msg, array), new Object[0]);
    }

    private void warn(String msg, Object ... array) {
        log.warn(String.format("[%d] ", this.hashCode()) + String.format(msg, array), new Object[0]);
    }

    private void handleStart() throws InterruptedException {
        this.checkCanceled();
        this.state = Transfer.TransferState.InProgress;
        this.progressListener.progressChanged(new ProgressEvent(ProgressEventType.TRANSFER_STARTED_EVENT, this.bytesCompleted));
    }

    private void handleGetUploadId() throws InterruptedException {
        this.checkCanceled();
        if (this.file == null) {
            return;
        }
        this.persistUpload = new PersistableUpload(this.bucket, this.key, this.file.getPath().replace("\\", "/"), this.uploadId, this.blockSize);
        this.progressListener.onPersistableTransfer(this.persistUpload);
    }

    private void handlePartStart() throws InterruptedException {
        this.checkCanceled();
        this.progressListener.progressChanged(new ProgressEvent(ProgressEventType.TRANSFER_PART_STARTED_EVENT, this.bytesCompleted));
    }

    private void handlePartComplete() throws InterruptedException {
        this.checkCanceled();
        this.progressListener.progressChanged(new ProgressEvent(ProgressEventType.TRANSFER_PART_COMPLETED_EVENT, this.bytesCompleted));
    }

    private void handleComplete() throws InterruptedException {
        this.checkCanceled();
        this.state = Transfer.TransferState.Completed;
        this.progressListener.progressChanged(new ProgressEvent(ProgressEventType.TRANSFER_COMPLETED_EVENT, this.bytesCompleted));
    }

    private void handleFailed() {
        if (this.isCanceled()) {
            this.handleCanceled();
            return;
        }
        this.state = Transfer.TransferState.Failed;
        this.progressListener.progressChanged(new ProgressEvent(ProgressEventType.TRANSFER_FAILED_EVENT, this.bytesCompleted));
    }

    private void handleCanceled() {
        this.state = Transfer.TransferState.Canceled;
        this.progressListener.progressChanged(new ProgressEvent(ProgressEventType.TRANSFER_CANCELED_EVENT, this.bytesCompleted));
    }

    private void setCommonParam(BS2WebServiceRequest<? extends BS2WebServiceRequest> request) {
        if (this.customRequestHeaders != null) {
            for (Map.Entry<String, String> entry : this.customRequestHeaders.entrySet()) {
                request.putCustomRequestHeader(entry.getKey(), entry.getValue());
            }
        }
        if (this.customQueryParameters != null) {
            for (Map.Entry<String, String> entry : this.customQueryParameters.entrySet()) {
                request.putCustomQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        request.putCustomQueryParameter("txrequestid", this.requestId);
        if (this.retryTimes != null) {
            request.withRetryTimes(this.retryTimes);
        }
        if (this.retryInterval != null) {
            request.withRetryInterval(this.retryInterval);
        }
        if (this.connectTimeout != null) {
            request.withConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout != null) {
            request.withReadTimeout(this.readTimeout);
        }
        if (this.writeTimeout != null) {
            request.withWriteTimeout(this.writeTimeout);
        }
        request.withRequestCredentials(this.requestCredentials).withDnsResolver(this.dnsResolver);
    }

    private void setException(Exception e) {
        if (e instanceof BS2ClientException) {
            this.exception = (BS2ClientException)e;
        }
        this.exception = new BS2ClientException(e.toString(), e);
    }

    public void isForceOnceUpload() {
        if (this.forceOnceUpload) {
            return;
        }
        try {
            InitMultiPartUploadRequest initRequest = new InitMultiPartUploadRequest();
            this.setCommonParam(initRequest);
            initRequest.withBucketName(this.bucket).withKeyName(this.key);
            InitMultiPartUploadResult initResult = this.bs2Client.initMultiPartUpload(initRequest);
            if (!initResult.getUploadId().isEmpty()) {
                this.forceOnceUpload = false;
            }
        }
        catch (Exception e) {
            BS2ServiceException bsException;
            int errorCode;
            if (e instanceof BS2ServiceException && 422 == (errorCode = (bsException = (BS2ServiceException)e).getStatusCode())) {
                this.forceOnceUpload = true;
            }
            throw e;
        }
    }

    @Override
    public UploadResult call() throws Exception {
        this.info("bucket :%s, key :%s, uploadId :%s , size :%d , blockSize :%d, retryTimes : %d, retryInterval : %d, connectTimeout :%d, readTimeout :%d, writeTimeout :%d, forceOnceUpload : %b", this.bucket, this.key, this.uploadId, this.size, this.blockSize, this.retryTimes, this.retryInterval, this.connectTimeout, this.readTimeout, this.writeTimeout, this.forceOnceUpload);
        try {
            this.txStat.startTick = System.currentTimeMillis();
            this.isForceOnceUpload();
            this.info("forceOnceUpload:%b", this.forceOnceUpload);
            if (this.uploadId == null && this.size != -1L && this.size <= this.blockSize || this.forceOnceUpload) {
                UploadResult uploadResult = this.OnceUpload();
                return uploadResult;
            }
            UploadResult uploadResult = this.MultipartUpload();
            return uploadResult;
        }
        catch (InterruptedException e) {
            this.warn("uploadcallable canceled, e :%s", e.toString());
            this.txStat.canceled = 1;
            this.handleCanceled();
            throw e;
        }
        catch (Exception e) {
            this.warn("uploadcallable throws exception, e :%s", e.toString());
            this.txStat.exception = Utility.getStackTrace(e);
            this.setException(e);
            this.handleFailed();
            throw e;
        }
        finally {
            this.txStat.endTick = System.currentTimeMillis();
            StatReporter.report(this.txStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploadResult OnceUpload() throws InterruptedException {
        this.handleStart();
        this.info("once upload starts", new Object[0]);
        this.checkCanceled();
        this.txStat.onceUploadTick = System.currentTimeMillis();
        UploadOnceResult onceResult = null;
        try {
            UploadOnceRequest onceRequest = new UploadOnceRequest();
            this.setCommonParam(onceRequest);
            onceRequest.withBucketName(this.bucket).withKeyName(this.key).withInput(this.input).withSize(this.size);
            onceResult = this.bs2Client.uploadOnce(onceRequest);
            this.info("once upload complete, etag :%s, bytesTransfered :%d", onceResult.getETag(), onceResult.getBytesTransfered());
            this.bytesCompleted += onceResult.getBytesTransfered();
            this.txStat.totalUploadParts = 1;
            this.txStat.totalUploadBytes = this.bytesCompleted;
            this.handleComplete();
        }
        catch (Throwable throwable) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                log.warn("close uploadOnceRequest inputStream exception %s, uploadId: %d", e.toString(), this.uploadId);
                BS2ClientException bs2Exception = new BS2ClientException(e.toString(), e);
                throw bs2Exception;
            }
            throw throwable;
        }
        try {
            this.input.close();
        }
        catch (IOException e) {
            log.warn("close uploadOnceRequest inputStream exception %s, uploadId: %d", e.toString(), this.uploadId);
            BS2ClientException bs2Exception = new BS2ClientException(e.toString(), e);
            throw bs2Exception;
        }
        UploadResult result = new UploadResult();
        result.setETag(onceResult.getETag());
        result.setDownloadUrl(onceResult.getDownloadUrl());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private UploadResult MultipartUpload() throws InterruptedException {
        this.handleStart();
        int partNumber = 0;
        if (this.uploadId != null) {
            this.handleGetUploadId();
            this.info("upload is continue upload, get last part", new Object[0]);
            this.checkCanceled();
            this.txStat.getLastPartTick = System.currentTimeMillis();
            GetLastPartRequest lastPartRequest = new GetLastPartRequest();
            this.setCommonParam(lastPartRequest);
            lastPartRequest.withBucketName(this.bucket).withKeyName(this.key).withUploadId(this.uploadId);
            GetLastPartResult lastPartResult = this.bs2Client.getLastPart(lastPartRequest);
            this.uploadId = lastPartResult.getUploadId();
            partNumber = lastPartResult.getPartNumber() + 1;
            this.bytesCompleted = lastPartResult.getCurrentSize();
            this.info(String.format("get last part succ, uploadId %s, partnumber %s, bytesCompleted %d", this.uploadId, partNumber, this.bytesCompleted), new Object[0]);
            this.txStat.lastUploadParts = partNumber;
            this.txStat.lastUploadBytes = this.bytesCompleted;
            this.txStat.totalUploadParts = partNumber;
            this.txStat.totalUploadBytes = this.bytesCompleted;
        } else {
            this.info("uploadtype is new, init multipart upload", new Object[0]);
            this.checkCanceled();
            this.txStat.initUploadTick = System.currentTimeMillis();
            InitMultiPartUploadRequest initRequest = new InitMultiPartUploadRequest();
            this.setCommonParam(initRequest);
            initRequest.withBucketName(this.bucket).withKeyName(this.key);
            InitMultiPartUploadResult initResult = this.bs2Client.initMultiPartUpload(initRequest);
            this.uploadId = initResult.getUploadId();
            this.info("init multipart upload succ, uploadId %s", this.uploadId);
            this.handleGetUploadId();
        }
        this.txStat.uploadId = this.uploadId;
        if (this.bytesCompleted > 0L) {
            try {
                long skipSize = this.input.skip(this.bytesCompleted);
                if (skipSize != this.bytesCompleted) {
                    throw new BS2ClientException("continue upload , unable to seek to last position");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BS2ClientException(e.toString(), e);
            }
        }
        this.txStat.uploadPartsTick = System.currentTimeMillis();
        block14: while (true) {
            while (true) {
                this.handlePartStart();
                this.info("upload part, partSize :%d,  partNumber: %d", this.blockSize, partNumber);
                this.checkCanceled();
                UploadPartRequest partRequest = new UploadPartRequest();
                this.setCommonParam(partRequest);
                partRequest.withBucketName(this.bucket).withKeyName(this.key).withUploadId(this.uploadId).withPartNumber(partNumber).withPartSize(this.blockSize).withInput(this.input);
                try {
                    this.input.mark(this.blockSize.intValue());
                    UploadPartResult partResult = this.bs2Client.uploadPart(partRequest);
                    this.info("multipart upload succ , bytesTransfered: %d", partResult.getBytesTransfered());
                    this.bytesCompleted += partResult.getBytesTransfered();
                    this.handlePartComplete();
                    if (partResult.getBytesTransfered() == 0L) break block14;
                    this.txStat.totalUploadParts = partNumber;
                    this.txStat.totalUploadBytes = this.bytesCompleted;
                    if (this.size != -1L && this.bytesCompleted > this.size) {
                        throw new BS2ClientException("input stream size not equals to size param");
                    }
                    ++partNumber;
                    continue block14;
                }
                catch (BS2ServiceException ex) {
                    if (ex.getStatusCode() != 400) continue;
                    GetLastPartRequest lastpartRequest = new GetLastPartRequest();
                    this.setCommonParam(lastpartRequest);
                    lastpartRequest.withBucketName(this.bucket);
                    lastpartRequest.withUploadId(this.uploadId);
                    lastpartRequest.withKeyName(this.key);
                    try {
                        GetLastPartResult lastPartResult = this.bs2Client.getLastPart(lastpartRequest);
                        int server_part_number = lastPartResult.getPartNumber();
                        this.info("query server part number from server %d, local parat number is %d", server_part_number, partNumber);
                        if (server_part_number + 1 == partNumber) break block14;
                        partNumber = server_part_number + 1;
                        this.bytesCompleted = lastPartResult.getCurrentSize();
                        try {
                            this.input.reset();
                        }
                        catch (IOException ex_reset) {
                            this.warn("input reset error %s", ex_reset.toString());
                        }
                    }
                    catch (BS2ClientException client_ex) {
                        break block14;
                    }
                    continue block14;
                }
                break;
            }
            break;
        }
        try {
            this.input.close();
        }
        catch (IOException e) {
            log.warn("close uploadPartRequest inputStream exception %s, uploadId: %d", e.toString(), this.uploadId);
            BS2ClientException bs2Exception = new BS2ClientException(e.toString(), e);
            throw bs2Exception;
        }
        catch (Throwable throwable) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                log.warn("close uploadPartRequest inputStream exception %s, uploadId: %d", e.toString(), this.uploadId);
                BS2ClientException bs2Exception = new BS2ClientException(e.toString(), e);
                throw bs2Exception;
            }
            throw throwable;
        }
        if (this.bytesCompleted == 0L) {
            throw new BS2ClientException("input stream is empty");
        }
        if (this.size != -1L && this.bytesCompleted != this.size) {
            throw new BS2ClientException("input stream size not equals to size param");
        }
        this.info("complete multipart upload , bytesCompleted: %d", this.bytesCompleted);
        this.checkCanceled();
        this.txStat.completeUploadTick = System.currentTimeMillis();
        CompleteMultiPartUploadRequest completeRequest = new CompleteMultiPartUploadRequest();
        this.setCommonParam(completeRequest);
        completeRequest.withBucketName(this.bucket).withKeyName(this.key).withUploadId(this.uploadId).withPartCount(partNumber);
        CompleteMultiPartUploadResult completeResult = this.bs2Client.completeMultiPartUpload(completeRequest);
        this.info("complete multipart upload upload succ , etag %s", completeResult.getETag());
        this.handleComplete();
        UploadResult result = new UploadResult();
        result.setETag(completeResult.getETag());
        result.setDownloadUrl(completeResult.getDownloadUrl());
        return result;
    }

    public void abort() {
        this.isCanceled = true;
    }

    public PersistableUpload cancel() {
        this.isCanceled = true;
        return this.persistUpload;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void checkCanceled() throws InterruptedException {
        if (this.isCanceled()) {
            throw new InterruptedException("upload is interrupted");
        }
    }

    public Transfer.TransferState getState() {
        return this.state;
    }

    public long getBytesTransferred() {
        return this.bytesCompleted;
    }

    public long getTotalBytesToTransfer() {
        return this.size;
    }

    public BS2ClientException getException() {
        return this.exception;
    }
}

