/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.transfer;

import com.yy.yycloud.bs2.BS2ClientException;
import com.yy.yycloud.bs2.auth.BS2SessionCredentials;
import com.yy.yycloud.bs2.dns.DnsResolver;
import com.yy.yycloud.bs2.event.ProgressListener;
import com.yy.yycloud.bs2.event.TransferStateChangeListener;
import com.yy.yycloud.bs2.model.DeleteObjectRequest;
import com.yy.yycloud.bs2.model.PutObjectRequest;
import com.yy.yycloud.bs2.model.ResumeUploadRequest;
import com.yy.yycloud.bs2.transfer.BS2;
import com.yy.yycloud.bs2.transfer.BS2Client;
import com.yy.yycloud.bs2.transfer.Delete;
import com.yy.yycloud.bs2.transfer.DeleteCallable;
import com.yy.yycloud.bs2.transfer.DeleteImpl;
import com.yy.yycloud.bs2.transfer.PersistableUpload;
import com.yy.yycloud.bs2.transfer.Upload;
import com.yy.yycloud.bs2.transfer.UploadCallable;
import com.yy.yycloud.bs2.transfer.UploadImpl;
import com.yy.yycloud.bs2.transfer.model.DeleteResult;
import com.yy.yycloud.bs2.transfer.model.UploadResult;
import com.yy.yycloud.bs2.utility.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class TransferManager {
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private ExecutorService executor;
    private BS2 bs2Client;

    public TransferManager() {
        this(null, null, Executors.newFixedThreadPool(10));
    }

    public TransferManager(DnsResolver resolver) {
        this(null, resolver, Executors.newFixedThreadPool(10));
    }

    public TransferManager(BS2SessionCredentials credentials) {
        this(credentials, null, Executors.newFixedThreadPool(10));
    }

    public TransferManager(ExecutorService executor) {
        this(null, null, executor);
    }

    public TransferManager(BS2SessionCredentials credentials, DnsResolver resolver) {
        this(credentials, resolver, Executors.newFixedThreadPool(10));
    }

    public TransferManager(DnsResolver resolver, ExecutorService executor) {
        this(null, resolver, executor);
    }

    public TransferManager(BS2SessionCredentials credentials, ExecutorService executor) {
        this(credentials, null, executor);
    }

    public TransferManager(BS2SessionCredentials credentials, DnsResolver resolver, ExecutorService executor) {
        Utility.rejectNull(executor, "executor is not setted");
        this.bs2Client = new BS2Client(credentials, resolver);
        this.executor = executor;
    }

    public Upload doUpload(PutObjectRequest request, String uploadId) {
        String bucket = request.getBucketName();
        String key = request.getKeyName();
        InputStream input = request.getInput();
        Long size = request.getSize();
        File file = request.getFile();
        boolean forceOnceUpload = request.getForceOnceUpload();
        BS2SessionCredentials requestCredentials = request.getRequestCredentials();
        ProgressListener progressListener = request.getProgressListener();
        Utility.rejectNull(bucket, "bucketname is not setted");
        Utility.rejectNull(key, "keyname is not setted");
        Utility.rejectNull(progressListener, "progressListener is not setted");
        Utility.rejectEmptyValue(bucket, "bucketname can't be empty string");
        if (!forceOnceUpload) {
            Utility.rejectEmptyValue(key, "keyname can't be empty string");
        }
        if (file == null && input == null || file != null && input != null) {
            throw new IllegalArgumentException("input stream or file param invalid");
        }
        if (file != null) {
            size = file.length();
            Utility.rejectEmptyValue(size, "size can't be 0");
            try {
                input = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new BS2ClientException(e.toString(), e);
            }
            Utility.rejectNull(input, "file input stream is null");
        } else if (input != null) {
            if (forceOnceUpload) {
                Utility.rejectNull(size, "size is not setted");
            }
            if (size == null) {
                size = -1L;
            } else {
                Utility.rejectEmptyValue(size, "size can't be 0");
            }
        }
        Long blockSize = request.getBlockSize();
        Integer retryTimes = request.getRetryTimes();
        Integer retryInterval = request.getRetryInterval();
        Integer connectTimeout = request.getConnectTimeout();
        Integer readTimeout = request.getReadTimeout();
        Integer writeTimeout = request.getWriteTimeout();
        Map<String, String> customQueryParameters = Utility.copyMap(request.getCustomQueryParameters());
        Map<String, String> customRequestHeaders = Utility.copyMap(request.getCustomRequestHeaders());
        DnsResolver dnsResolver = request.getDnsResolver();
        UploadCallable callable = new UploadCallable(this.bs2Client, bucket, key, uploadId, input, file, size, blockSize, forceOnceUpload, requestCredentials, retryTimes, retryInterval, connectTimeout, readTimeout, writeTimeout, customQueryParameters, customRequestHeaders, dnsResolver, progressListener);
        Future<UploadResult> future = this.executor.submit(callable);
        return new UploadImpl(future, callable);
    }

    public Upload upload(PutObjectRequest request) {
        Utility.rejectNull(request, "request is null");
        return this.doUpload(request, null);
    }

    public Upload resumeUpload(ResumeUploadRequest request) {
        Utility.rejectNull(request, "request is null");
        PersistableUpload persistUpload = request.getPersistableUpload();
        Utility.rejectNull(persistUpload, "persist upload is null");
        PutObjectRequest putRequest = new PutObjectRequest();
        ((PutObjectRequest)putRequest.withBucketName(persistUpload.getBucketName()).withKeyName(persistUpload.getKey()).withFile(new File(persistUpload.getFile())).withBlockSize(persistUpload.getPartSize()).withRequestCredentials(request.getRequestCredentials())).withProgressListener(request.getProgressListener()).withDnsResolver(request.getDnsResolver());
        if (request.getRetryTimes() != null) {
            putRequest.withRetryTimes(request.getRetryTimes());
        }
        if (request.getRetryInterval() != null) {
            putRequest.withRetryInterval(request.getRetryInterval());
        }
        if (request.getConnectTimeout() != null) {
            putRequest.withConnectTimeout(request.getConnectTimeout());
        }
        if (request.getReadTimeout() != null) {
            putRequest.withReadTimeout(request.getReadTimeout());
        }
        if (request.getWriteTimeout() != null) {
            putRequest.withWriteTimeout(request.getWriteTimeout());
        }
        if (request.getCustomRequestHeaders() != null) {
            for (Map.Entry<String, String> entry : request.getCustomRequestHeaders().entrySet()) {
                putRequest.putCustomRequestHeader(entry.getKey(), entry.getValue());
            }
        }
        if (request.getCustomQueryParameters() != null) {
            for (Map.Entry<String, String> entry : request.getCustomQueryParameters().entrySet()) {
                putRequest.putCustomQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        return this.doUpload(putRequest, persistUpload.getUploadId());
    }

    public Delete delete(DeleteObjectRequest request) {
        Utility.rejectNull(request, "request is null");
        String bucket = request.getBucketName();
        String key = request.getKeyName();
        BS2SessionCredentials requestCredentials = request.getRequestCredentials();
        TransferStateChangeListener transferStateChangeListener = request.getTransferStateChangeListener();
        Utility.rejectNull(bucket, "bucketname is not setted");
        Utility.rejectNull(key, "keyname is not setted");
        Utility.rejectNull(transferStateChangeListener, "transferStateChangeListener is not setted");
        Utility.rejectEmptyValue(bucket, "bucketname can't be empty string");
        Utility.rejectEmptyValue(key, "key can't be empty string");
        Integer retryTimes = request.getRetryTimes();
        Integer retryInterval = request.getRetryInterval();
        Integer connectTimeout = request.getConnectTimeout();
        Integer readTimeout = request.getReadTimeout();
        Integer writeTimeout = request.getWriteTimeout();
        Map<String, String> customQueryParameters = Utility.copyMap(request.getCustomQueryParameters());
        Map<String, String> customRequestHeaders = Utility.copyMap(request.getCustomRequestHeaders());
        DnsResolver dnsResolver = request.getDnsResolver();
        DeleteCallable callable = new DeleteCallable(this.bs2Client, bucket, key, requestCredentials, retryTimes, retryInterval, connectTimeout, readTimeout, writeTimeout, customQueryParameters, customRequestHeaders, dnsResolver, transferStateChangeListener);
        Future<DeleteResult> future = this.executor.submit(callable);
        return new DeleteImpl(future, callable);
    }
}

