/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.stat;

import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yycloud.bs2.conf.ConfigAppInfo;
import com.yy.yycloud.bs2.conf.ConfigStatistic;
import com.yy.yycloud.bs2.stat.model.BS2ClientStat;
import com.yy.yycloud.bs2.stat.model.RequestStat;
import com.yy.yycloud.bs2.stat.model.TxUploadStat;
import com.yy.yycloud.bs2.utility.Logger;
import java.lang.reflect.Field;

public class StatReporter {
    private static Logger log = Logger.getLogger(StatReporter.class);
    private static HiidoSDK hidoInstance = null;

    public static void setHidoSDK(HiidoSDK hido) {
        hidoInstance = hido;
    }

    public static void report(RequestStat stat) {
        StatReporter.doReport(stat, "bs2requeststat");
    }

    public static void report(BS2ClientStat stat) {
        StatReporter.doReport(stat, "bs2client");
    }

    public static void report(TxUploadStat stat) {
        StatReporter.doReport(stat, "bs2txupload");
    }

    private static void doReport(Object statObj, String act) {
        if (hidoInstance == null) {
            return;
        }
        try {
            Field[] fields;
            if (!ConfigStatistic.isReportOn()) {
                return;
            }
            Class<?> statClass = statObj.getClass();
            String logContent = "";
            StatisContent statContent = new StatisContent();
            for (Field field : fields = statClass.getDeclaredFields()) {
                field.setAccessible(true);
                String value = null;
                try {
                    value = field.get(statObj).toString();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                logContent = logContent + String.format("%s = %s\n", field.getName().toLowerCase(), value);
                statContent.put(field.getName().toLowerCase(), value);
            }
            log.debug("do report, stat act: %s, content: %s", act, logContent);
            log.debug("app info, appid :%s , appversion :%s , deviceid :%s , network :%d", ConfigAppInfo.getAppId(), ConfigAppInfo.getAppVersion(), ConfigAppInfo.getDeviceId(), ConfigAppInfo.getNetworkType());
            statContent.put("appid", ConfigAppInfo.getAppId());
            statContent.put("appversion", ConfigAppInfo.getAppVersion());
            statContent.put("deviceid", ConfigAppInfo.getDeviceId());
            if (ConfigAppInfo.getNetworkType() != null) {
                statContent.put("network", ConfigAppInfo.getNetworkType().intValue());
            }
            String sysVerion = null;
            int platform = 1;
            if (System.getProperties().getProperty("java.vendor.url").equals("http://www.android.com/")) {
                String androidVer = null;
                try {
                    Field field = Class.forName("android.os.Build$VERSION").getDeclaredField("RELEASE");
                    androidVer = field.get(null).toString();
                    sysVerion = "android:" + androidVer;
                }
                catch (Exception e) {
                    log.warn("get android version failed, exception: %s", e.toString());
                }
                platform = 0;
            } else {
                sysVerion = System.getProperties().getProperty("os.name") + ":" + System.getProperties().getProperty("os.version");
                platform = 1;
            }
            String sdkVersion = "1.1.8";
            log.debug("sys info, platform: %d, sysver: %s , sdkversion: %s", platform, sysVerion, sdkVersion);
            statContent.put("platform", platform);
            statContent.put("sysver", sysVerion);
            statContent.put("bs2sdkver", sdkVersion);
            hidoInstance.reportStatisticContent(act, statContent);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("report stat failed, stat act: %s, exception: %s", act, e.toString());
        }
    }
}

