/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.model;

import com.yy.yycloud.bs2.auth.BS2SessionCredentials;
import com.yy.yycloud.bs2.dns.DnsResolver;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BS2WebServiceRequest<T extends BS2WebServiceRequest> {
    private static final String CONTENTTYPE_HEADER = "Content-Type";
    private Integer retryTimes;
    private Integer retryInterval;
    private Integer connectTimeout;
    private Integer readTimeout;
    private Integer writeTimeout;
    private Map<String, String> customQueryParameters;
    private Map<String, String> customRequestHeaders;
    private BS2SessionCredentials requestCredentials;
    private DnsResolver dnsResolver;

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public Integer getRetryTimes() {
        return this.retryTimes;
    }

    public T withRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
        BS2WebServiceRequest t = this;
        return (T)t;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Integer getRetryInterval() {
        return this.retryInterval;
    }

    public T withRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
        BS2WebServiceRequest t = this;
        return (T)t;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public T withConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        BS2WebServiceRequest t = this;
        return (T)t;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public T withReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        BS2WebServiceRequest t = this;
        return (T)t;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public Integer getWriteTimeout() {
        return this.writeTimeout;
    }

    public T withWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
        BS2WebServiceRequest t = this;
        return (T)t;
    }

    public void putCustomQueryParameter(String name, String value) {
        if (this.customQueryParameters == null) {
            this.customQueryParameters = new HashMap<String, String>();
        }
        this.customQueryParameters.put(name, value);
    }

    public Map<String, String> getCustomQueryParameters() {
        if (this.customQueryParameters == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.customQueryParameters);
    }

    public T withCustomQueryParameter(String name, String value) {
        if (this.customQueryParameters == null) {
            this.customQueryParameters = new HashMap<String, String>();
        }
        this.customQueryParameters.put(name, value);
        BS2WebServiceRequest t = this;
        return (T)t;
    }

    public String putCustomRequestHeader(String name, String value) {
        if (this.customRequestHeaders == null) {
            this.customRequestHeaders = new HashMap<String, String>();
        }
        return this.customRequestHeaders.put(name, value);
    }

    public Map<String, String> getCustomRequestHeaders() {
        if (this.customRequestHeaders == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.customRequestHeaders);
    }

    public T withCustomRequestHeader(String name, String value) {
        if (this.customRequestHeaders == null) {
            this.customRequestHeaders = new HashMap<String, String>();
        }
        this.customRequestHeaders.put(name, value);
        BS2WebServiceRequest t = this;
        return (T)t;
    }

    public void setRequestCredentials(BS2SessionCredentials requestCredentials) {
        this.requestCredentials = requestCredentials;
    }

    public BS2SessionCredentials getRequestCredentials() {
        return this.requestCredentials;
    }

    public T withRequestCredentials(BS2SessionCredentials requestCredentials) {
        this.requestCredentials = requestCredentials;
        BS2WebServiceRequest t = this;
        return (T)t;
    }

    public void setDnsResolver(DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
    }

    public DnsResolver getDnsResolver() {
        return this.dnsResolver;
    }

    public T withDnsResolver(DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
        BS2WebServiceRequest t = this;
        return (T)t;
    }

    public void setContentType(String contentType) {
        this.putCustomRequestHeader(CONTENTTYPE_HEADER, contentType);
    }

    public T withContentType(String contentType) {
        this.putCustomRequestHeader(CONTENTTYPE_HEADER, contentType);
        BS2WebServiceRequest t = this;
        return (T)t;
    }
}

