/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.downloader.impl;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.yy.yycloud.bs2.BS2Consts;
import com.yy.yycloud.bs2.downloader.impl.DownloaderImpl;
import com.yy.yycloud.bs2.downloader.impl.DownloaderThreadPool;
import java.util.HashSet;
import java.util.Set;

public class TaskCenter {
    static final int DOWNLOAD_FAILED = -1;
    static final int DOWNLOAD_STARTED = 1;
    static final int DOWNLOAD_COMPLETE = 2;
    static final int DOWNLOAD_PROCESS = 3;
    static final int TASK_COMPLETE = 4;
    static final int UNKNOW = 255;
    private static TaskCenter ourInstance = new TaskCenter();
    private final Set<String> mSetTask = new HashSet<String>();
    private DownloaderThreadPool m_threadPool = new DownloaderThreadPool();
    private Handler mHandler;

    public static TaskCenter getInstance() {
        return ourInstance;
    }

    public TaskCenter() {
        this.m_threadPool.run();
        this.mHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message inputMessage) {
                DownloaderImpl downloader = (DownloaderImpl)inputMessage.obj;
                int errcode = downloader.getErrorCode();
                switch (inputMessage.what) {
                    case 3: {
                        downloader.handleProcess(downloader.getPercent(), downloader.getTotal(), downloader.getProgress());
                        break;
                    }
                    case 2: {
                        TaskCenter.this.mSetTask.remove(downloader.getDownloadFile());
                        downloader.handleState(2, errcode);
                        break;
                    }
                    case -1: {
                        TaskCenter.this.mSetTask.remove(downloader.getDownloadFile());
                        downloader.handleState(-1, errcode);
                        break;
                    }
                    case 1: {
                        downloader.handleState(1, errcode);
                        break;
                    }
                    default: {
                        TaskCenter.this.mSetTask.remove(downloader.getDownloadFile());
                        downloader.handleState(255, errcode);
                    }
                }
            }
        };
    }

    public int startTask(DownloaderImpl downloader) {
        String fileKeyPath = downloader.getDownloadFile();
        if (this.mSetTask.contains(fileKeyPath)) {
            return BS2Consts.RES.success;
        }
        this.mSetTask.add(fileKeyPath);
        if (!this.m_threadPool.addTask(downloader.getDownloadTask())) {
            return BS2Consts.RES.error;
        }
        return BS2Consts.RES.success;
    }

    public int stopTask(DownloaderImpl downloader) {
        if (!this.m_threadPool.stopTask(downloader.getDownloadTask())) {
            return BS2Consts.RES.error;
        }
        return BS2Consts.RES.success;
    }

    public int pauseTask(DownloaderImpl downloader) {
        if (!this.m_threadPool.pauseTask(downloader.getDownloadTask())) {
            return BS2Consts.RES.error;
        }
        return BS2Consts.RES.success;
    }

    public int resumeTask(DownloaderImpl downloader) {
        if (!this.m_threadPool.addTask(downloader.getDownloadTask())) {
            return BS2Consts.RES.error;
        }
        return BS2Consts.RES.success;
    }

    public void handleState(int state, DownloaderImpl downloader) {
        Message completeMessage = this.mHandler.obtainMessage(state, (Object)downloader);
        completeMessage.sendToTarget();
    }
}

