/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.downloader.impl;

import com.yy.yycloud.bs2.BS2Consts;
import com.yy.yycloud.bs2.downloader.IDownloader;
import com.yy.yycloud.bs2.downloader.impl.DownloadTask;
import com.yy.yycloud.bs2.downloader.impl.DownloaderVerify;
import com.yy.yycloud.bs2.downloader.impl.ProgressInfo;
import com.yy.yycloud.bs2.downloader.impl.TaskCenter;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class DownloaderImpl
implements IDownloader {
    private Set<IDownloader.IDownloaderEventListener> m_downloader_listener_set = new HashSet<IDownloader.IDownloaderEventListener>();
    private String m_bucket;
    private String m_token;
    private String m_file_key;
    private DownloadTask downloadTask;
    private String m_local_file_path;
    private String m_path;
    private int m_down_state;
    private ProgressInfo m_cur_progress;
    private String m_exception = "";
    private int m_error_code = BS2Consts.RES.error;
    private Integer m_retry_times;
    private long m_dns_time;
    private long m_request_time;

    public DownloaderImpl() {
        this.downloadTask = new DownloadTask(this);
        this.m_cur_progress = new ProgressInfo(0L, 1L);
    }

    @Override
    public synchronized int init(String bucket, String key) {
        if (null == bucket || null == key) {
            return BS2Consts.RES.e_param_error;
        }
        this.m_bucket = bucket;
        this.m_file_key = key;
        DownloaderVerify verify = new DownloaderVerify();
        this.m_local_file_path = verify.genDownloadUrlFile("://" + this.m_bucket + "/" + this.m_file_key);
        return BS2Consts.RES.success;
    }

    @Override
    public synchronized String getBucket() {
        return this.m_bucket;
    }

    @Override
    public synchronized String getFileKey() {
        return this.m_file_key;
    }

    @Override
    public synchronized int setToken(String token) {
        if (null == token) {
            return BS2Consts.RES.e_param_error;
        }
        this.m_token = token;
        return BS2Consts.RES.e_not_implement;
    }

    @Override
    public synchronized String getToken() {
        return this.m_token;
    }

    @Override
    public synchronized int start() {
        if (null == this.m_bucket) {
            return BS2Consts.RES.e_param_error;
        }
        this.m_down_state = 1;
        return TaskCenter.getInstance().startTask(this);
    }

    @Override
    public synchronized int pause() {
        this.m_down_state = 2;
        return BS2Consts.RES.success;
    }

    @Override
    public synchronized int resume() {
        this.m_down_state = 3;
        return TaskCenter.getInstance().startTask(this);
    }

    @Override
    public synchronized int stop() {
        this.m_down_state = 4;
        return BS2Consts.RES.success;
    }

    @Override
    public synchronized int deleteTempFile() {
        this.m_down_state = 4;
        File tmpFile = new File(this.m_local_file_path);
        if (tmpFile.delete()) {
            return BS2Consts.RES.success;
        }
        return BS2Consts.RES.error;
    }

    @Override
    public synchronized String getDownloadFile() {
        return this.m_local_file_path;
    }

    @Override
    public int addEventListener(IDownloader.IDownloaderEventListener e) {
        if (this.m_downloader_listener_set.add(e)) {
            return BS2Consts.RES.success;
        }
        return BS2Consts.RES.error;
    }

    @Override
    public int removeEventListener(IDownloader.IDownloaderEventListener e) {
        if (this.m_downloader_listener_set.remove(e)) {
            return BS2Consts.RES.success;
        }
        return BS2Consts.RES.error;
    }

    public synchronized DownloadTask getDownloadTask() {
        return this.downloadTask;
    }

    public synchronized int getDownloadState() {
        return this.m_down_state;
    }

    public void handleProcess(float percent, long current_size, long total_size) {
        for (IDownloader.IDownloaderEventListener i : this.m_downloader_listener_set) {
            i.onProcess(this, percent, current_size, total_size);
        }
    }

    public void handleState(int state, int error_code) {
        block5: for (IDownloader.IDownloaderEventListener i : this.m_downloader_listener_set) {
            switch (state) {
                case 2: {
                    i.onComplete(this, this.m_local_file_path);
                    continue block5;
                }
                case -1: {
                    i.onError(this, error_code);
                    continue block5;
                }
                case 1: {
                    i.onStart(this);
                    continue block5;
                }
            }
            i.onError(this, error_code);
        }
    }

    public synchronized String getPath() {
        return this.m_path;
    }

    public synchronized void setPath(String path) {
        this.m_path = path;
    }

    protected synchronized void setExceptionStr(String estr) {
        this.m_exception = estr;
    }

    protected synchronized String getExceptionStr() {
        return this.m_exception;
    }

    protected synchronized void setErrorCode(int err) {
        this.m_error_code = err;
    }

    protected synchronized int getErrorCode() {
        return this.m_error_code;
    }

    protected synchronized void setProgress(long progress, long total) {
        this.m_cur_progress.setProgress(progress);
        this.m_cur_progress.setTotal(total);
    }

    protected synchronized long getProgress() {
        return this.m_cur_progress.getProgress();
    }

    protected synchronized long getTotal() {
        return this.m_cur_progress.getTotal();
    }

    protected synchronized float getPercent() {
        return this.m_cur_progress.getPercent();
    }

    public synchronized Integer getRetryTimes() {
        return this.m_retry_times;
    }

    public synchronized void setRetryTimes(Integer m_retry_times) {
        this.m_retry_times = m_retry_times;
    }

    public synchronized long getDNSTime() {
        return this.m_dns_time;
    }

    public synchronized void setDNSTime(long m_dns_time) {
        this.m_dns_time = m_dns_time;
    }

    public synchronized long getRequestTime() {
        return this.m_request_time;
    }

    public synchronized void setRequestTime(long m_request_time) {
        this.m_request_time = m_request_time;
    }
}

