/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.dns;

import android.content.Context;
import com.yy.gslbsdk.DnsResultInfo;
import com.yy.gslbsdk.HttpDnsService;
import com.yy.yycloud.bs2.BS2ClientException;
import com.yy.yycloud.bs2.BS2Factory;
import com.yy.yycloud.bs2.BS2ServiceException;
import com.yy.yycloud.bs2.dns.DnsResolver;
import com.yy.yycloud.bs2.utility.Logger;
import java.util.ArrayList;
import java.util.List;

public class SmartDnsResolver
implements DnsResolver {
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int DEFAULT_RETRY_TIMES = 5;
    private static final int DEFAULT_RETRY_INTERVAL = 1000;
    private static Logger log = Logger.getLogger(SmartDnsResolver.class);
    private int timeOut = 5000;
    private int retryTimes = 5;
    private int retryInterval = 1000;

    private void throwException(String errMsg) {
        BS2ServiceException bs2Exception = new BS2ServiceException(errMsg);
        bs2Exception.setErrorType(BS2ServiceException.ErrorType.Service);
        throw bs2Exception;
    }

    public void setTimeout(int timeOut) {
        this.timeOut = timeOut;
    }

    public SmartDnsResolver withTimeout(int timeOut) {
        this.timeOut = timeOut;
        return this;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public SmartDnsResolver withRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
        return this;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public SmartDnsResolver withRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    @Override
    public List<String> resovle(String host) throws BS2ServiceException, BS2ClientException {
        log.info("smart dns resolve start, host :%s , timeout :%d , retryTimes :%d , retryInterval :%d", host, this.timeOut, this.retryTimes, this.retryInterval);
        int triedTimes = 0;
        while (triedTimes <= this.retryTimes) {
            ++triedTimes;
            HttpDnsService gslbService = HttpDnsService.getService((Context)BS2Factory.getInstance().getContent(), (String)BS2Factory.getInstance().getGSLBAccountId(), null, (String)"");
            DnsResultInfo dnsinfo = gslbService.getIpsByHost(host);
            if (dnsinfo.mErrorCode == 0) {
                ArrayList<String> ipList = new ArrayList<String>();
                for (String i : dnsinfo.mIps) {
                    ipList.add(i);
                }
                log.info("smart dns resolve succ, host :%s ,ip addr list: %s", host, ipList.toString());
                return ipList;
            }
            log.warn("smart dns resolve failed, host :%s, errCode: %d", host, dnsinfo.mErrorCode);
            try {
                Thread.sleep(this.retryInterval);
            }
            catch (InterruptedException e) {
                log.warn("smart dns resolve sleep interrupted, host :%s", host);
            }
        }
        return new ArrayList<String>();
    }
}

