/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.delete.impl;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.yy.yycloud.bs2.BS2ClientException;
import com.yy.yycloud.bs2.BS2Consts;
import com.yy.yycloud.bs2.BS2ServiceException;
import com.yy.yycloud.bs2.auth.BS2SessionCredentials;
import com.yy.yycloud.bs2.delete.IDeleter;
import com.yy.yycloud.bs2.dns.SmartDnsResolver;
import com.yy.yycloud.bs2.event.UiTransferStateChangeListener;
import com.yy.yycloud.bs2.model.DeleteObjectRequest;
import com.yy.yycloud.bs2.transfer.Delete;
import com.yy.yycloud.bs2.transfer.Transfer;
import com.yy.yycloud.bs2.transfer.TransferManager;
import java.util.HashSet;
import java.util.Set;

public class DeleterImpl
implements IDeleter,
BS2SessionCredentials {
    private static final String TAG = "DeleterImpl";
    private final Handler m_handler;
    private String m_bucket;
    private String m_file_key;
    private TransferManager m_transferManager;
    private String m_token;
    private Delete m_delete;
    private Set<IDeleter.IDeleterEventListener> m_deleter_listener_set = new HashSet<IDeleter.IDeleterEventListener>();

    public DeleterImpl() {
        this.m_transferManager = new TransferManager((BS2SessionCredentials)this, new SmartDnsResolver());
        this.m_handler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                Transfer.TransferState state = (Transfer.TransferState)((Object)msg.obj);
                for (IDeleter.IDeleterEventListener listener : DeleterImpl.this.m_deleter_listener_set) {
                    switch (state) {
                        case InProgress: {
                            listener.onDeleteStart(DeleterImpl.this, BS2Consts.RES.success);
                            break;
                        }
                        case Completed: {
                            listener.onDeleted(DeleterImpl.this, BS2Consts.RES.success);
                            break;
                        }
                        case Failed: {
                            listener.onDeleteFailed(DeleterImpl.this, BS2Consts.RES.e_delete_error);
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteFile(String bucket, String file_key, String token) {
        if (null == bucket || null == file_key || null == token) {
            return BS2Consts.RES.e_param_error;
        }
        DeleterImpl deleterImpl = this;
        synchronized (deleterImpl) {
            this.m_token = token;
        }
        this.m_bucket = bucket;
        this.m_file_key = file_key;
        DeleteObjectRequest request = new DeleteObjectRequest();
        request.withBucketName(this.m_bucket).withKeyName(this.m_file_key).withTransferStateChangeListener(new UiTransferStateChangeListener(){

            @Override
            public void HandleTransferStateChanged(Transfer.TransferState state) {
                if (DeleterImpl.this.m_delete.getException() != null) {
                    Log.i((String)DeleterImpl.TAG, (String)("exception of delete: " + DeleterImpl.this.m_delete.getException().toString()));
                }
                Message msg = DeleterImpl.this.m_handler.obtainMessage();
                msg.obj = state;
                msg.sendToTarget();
            }
        });
        this.m_delete = this.m_transferManager.delete(request);
        return BS2Consts.RES.success;
    }

    @Override
    public String getFileKey() {
        return this.m_file_key;
    }

    @Override
    public String getBucket() {
        return this.m_bucket;
    }

    @Override
    public int addEventListener(IDeleter.IDeleterEventListener e) {
        if (this.m_deleter_listener_set.add(e)) {
            return BS2Consts.RES.success;
        }
        return BS2Consts.RES.error;
    }

    @Override
    public int removeEventListener(IDeleter.IDeleterEventListener e) {
        if (this.m_deleter_listener_set.remove(e)) {
            return BS2Consts.RES.success;
        }
        return BS2Consts.RES.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToken() {
        DeleterImpl deleterImpl = this;
        synchronized (deleterImpl) {
            return this.m_token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSessionToken(String bucket, String key, String method) throws BS2ServiceException, BS2ClientException {
        DeleterImpl deleterImpl = this;
        synchronized (deleterImpl) {
            return this.m_token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSessionToken(String bucket, String key, String method, int expires) throws BS2ServiceException, BS2ClientException {
        DeleterImpl deleterImpl = this;
        synchronized (deleterImpl) {
            return this.m_token;
        }
    }
}

