/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2;

import android.content.Context;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.yycloud.bs2.conf.ConfigYYDomain;
import com.yy.yycloud.bs2.delete.IDeleter;
import com.yy.yycloud.bs2.delete.impl.DeleterImpl;
import com.yy.yycloud.bs2.downloader.IDownloader;
import com.yy.yycloud.bs2.downloader.impl.DownloaderImpl;
import com.yy.yycloud.bs2.stat.StatReporter;
import com.yy.yycloud.bs2.uploader.IUploader;
import com.yy.yycloud.bs2.uploader.impl.UploaderImpl;

public class BS2Factory {
    private static BS2Factory ourInstance = new BS2Factory();
    private Context m_content;
    private String m_appId = "bs2Sdk";

    public static BS2Factory getInstance() {
        return ourInstance;
    }

    public Context getContent() {
        return this.m_content;
    }

    public IDownloader createDownloader(Context context) {
        if (null == context) {
            return null;
        }
        this.m_content = context;
        return new DownloaderImpl();
    }

    public IUploader createUploader(Context context) {
        if (null == context) {
            return null;
        }
        this.m_content = context;
        return new UploaderImpl();
    }

    public IDeleter createDeleter(Context context) {
        if (null == context) {
            return null;
        }
        this.m_content = context;
        return new DeleterImpl();
    }

    public void useYYDomain(boolean isYYDomain) {
        ConfigYYDomain.setIsYYDomain(isYYDomain);
    }

    public String getDownLoadUrl(String bucket, String file_key, String token) {
        if (null == bucket || null == file_key) {
            throw new IllegalArgumentException("argument error.");
        }
        StringBuilder sb = new StringBuilder("http://");
        sb.append(bucket).append(ConfigYYDomain.getBs2DownloadDomain()).append("/").append(file_key);
        if (null != token) {
            sb.append("?token=").append(token);
        }
        return sb.toString();
    }

    public void setGSLBAccountId(String appId) {
        this.m_appId = appId;
    }

    public String getGSLBAccountId() {
        return this.m_appId;
    }

    private BS2Factory() {
    }

    public void setHidoInstance(HiidoSDK hido) {
        StatReporter.setHidoSDK(hido);
    }
}

