/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.transfer;

import com.yy.yycloud.bs2.BS2ClientException;
import com.yy.yycloud.bs2.BS2ServiceException;
import com.yy.yycloud.bs2.transfer.PersistableUpload;
import com.yy.yycloud.bs2.transfer.Transfer;
import com.yy.yycloud.bs2.transfer.TransferProgress;
import com.yy.yycloud.bs2.transfer.Upload;
import com.yy.yycloud.bs2.transfer.UploadCallable;
import com.yy.yycloud.bs2.transfer.model.UploadResult;
import com.yy.yycloud.bs2.utility.Logger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class UploadImpl
implements Upload {
    private static Logger log = Logger.getLogger(UploadImpl.class);
    private Future<UploadResult> future;
    private UploadCallable callable;

    public UploadImpl(Future<UploadResult> future, UploadCallable callable) {
        this.future = future;
        this.callable = callable;
    }

    @Override
    public UploadResult waitForUploadResult() throws BS2ServiceException, BS2ClientException, InterruptedException {
        try {
            return this.future.get();
        }
        catch (ExecutionException ee) {
            log.warn("get future result exception , ee:%s ", ee.toString());
            ee.printStackTrace();
            Throwable e = ee.getCause();
            if (e instanceof BS2ClientException) {
                throw (BS2ClientException)e;
            }
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            throw new BS2ClientException(e.toString(), e);
        }
    }

    @Override
    public void abort() {
        this.callable.abort();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public Transfer.TransferState getState() {
        return this.callable.getState();
    }

    @Override
    public TransferProgress getProgress() {
        return new TransferProgress(){

            @Override
            public long getBytesTransferred() {
                return UploadImpl.this.callable.getBytesTransferred();
            }

            @Override
            public long getTotalBytesToTransfer() {
                return UploadImpl.this.callable.getTotalBytesToTransfer();
            }

            @Override
            public double getPercentTransferred() {
                long bytesTransfered = this.getBytesTransferred();
                long totalBytesToTransfer = this.getTotalBytesToTransfer();
                if (totalBytesToTransfer == -1L) {
                    return -1.0;
                }
                if (totalBytesToTransfer == 0L) {
                    return 0.0;
                }
                return (double)bytesTransfered / (double)totalBytesToTransfer;
            }
        };
    }

    @Override
    public BS2ClientException getException() {
        return this.callable.getException();
    }

    @Override
    public PersistableUpload cancel() {
        return this.callable.cancel();
    }
}

