/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.downloader.impl;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import com.yy.yycloud.bs2.BS2Consts;
import com.yy.yycloud.bs2.BS2Factory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DownloaderVerify {
    private Context m_context;

    public long getRomFeeBlockSize() {
        this.m_context = BS2Factory.getInstance().getContent();
        File file = new File(this.m_context.getCacheDir().getPath());
        StatFs stat = new StatFs(file.getPath());
        long blockSize = stat.getBlockSize();
        long freeBlocks = stat.getFreeBlocks();
        return blockSize * freeBlocks;
    }

    public boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    public int verifySha1(String file_path, String verify_value) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            return BS2Consts.RES.e_no_sha1_algorithm;
        }
        File file = new File(file_path);
        if (file.isDirectory() || !file.exists()) {
            return BS2Consts.RES.e_not_such_file;
        }
        try {
            FileInputStream inputStream = new FileInputStream(file_path);
            DigestInputStream digestInputStream = new DigestInputStream(inputStream, md);
            byte[] buffer = new byte[262144];
            while (digestInputStream.read(buffer) > 0) {
            }
            md = digestInputStream.getMessageDigest();
            String sha1_str = this.byteArrayToHex(md.digest());
            digestInputStream.close();
            if (sha1_str.compareTo(verify_value) == 0) {
                return BS2Consts.RES.success;
            }
            return BS2Consts.RES.e_verify_file_not_match;
        }
        catch (FileNotFoundException e) {
            return BS2Consts.RES.e_not_such_file;
        }
        catch (IOException e) {
            return BS2Consts.RES.e_read_file_error;
        }
    }

    private String keyMd5Hash(String key) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            String md5 = this.byteArrayToHex(md.digest(key.getBytes()));
            return md5;
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    private String keyHash(String key) {
        if (null == key) {
            return "nokey";
        }
        String md5_str = this.keyMd5Hash(key);
        if (!md5_str.isEmpty()) {
            return md5_str;
        }
        int k = key.length();
        int u = 0;
        char n = '\u0000';
        for (int i = 0; i < k; ++i) {
            n = key.charAt(i);
            u += 7 * n % 31;
        }
        Integer v = u;
        return v.toString();
    }

    public String genDownloadUrlFile(String url) {
        this.m_context = BS2Factory.getInstance().getContent();
        assert (this.m_context != null);
        String cache_file = this.m_context.getCacheDir().getPath() + "/";
        String temp_str = url.substring(url.indexOf("://"));
        cache_file = cache_file + new String(this.keyHash(temp_str).toString());
        cache_file = cache_file + ".tmp";
        return cache_file;
    }

    public String byteArrayToHex(byte[] byteArray) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = hexDigits[b >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[b & 0xF];
        }
        return new String(resultCharArray);
    }
}

