/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yycloud.bs2.downloader.impl;

import com.yy.yycloud.bs2.BS2ClientException;
import com.yy.yycloud.bs2.BS2Consts;
import com.yy.yycloud.bs2.conf.ConfigYYDomain;
import com.yy.yycloud.bs2.dns.DnsResolver;
import com.yy.yycloud.bs2.dns.SmartDnsResolver;
import com.yy.yycloud.bs2.downloader.impl.DownloaderImpl;
import com.yy.yycloud.bs2.downloader.impl.DownloaderReport;
import com.yy.yycloud.bs2.downloader.impl.DownloaderVerify;
import com.yy.yycloud.bs2.downloader.impl.TaskCenter;
import com.yy.yycloud.bs2.utility.Utility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DownloadTask
implements Runnable {
    private static final String AUTH_HEADER = "Authorization";
    private static final String HOST_HEADER = "Host";
    private static final String CONTENTTYPE_HEADER = "Content-Type";
    private static final String ERRCODE_HEADER = "error-code";
    private static final String ETAG_HEADER = "ETag";
    private static final String BS2FILENAME_HEADER = "x-bs2-filename";
    private static final String RANGE_HEADER = "Range";
    private static final String CONTENT_RANGE = "Content-Range";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static final String PUT_METHOD = "PUT";
    private static final String DELETE_METHOD = "DELETE";
    private static final long MAX_SIZE_PER_REQUEST = 0x1000000L;
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final int DEFAULT_RETRY_TIMES = 2;
    private static final int DEFAULT_RETRY_INTERVAL = 2000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_READ_TIMEOUT = 120000;
    private static final int DEFAULT_WRITE_TIMEOUT = 120000;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final String TMP_SURFIX = ".tmp";
    private RandomAccessFile mRandomAccessFile;
    private String downloadFile = "";
    private String downloadTmpFile = "";
    private OkHttpClient client;
    private DownloaderImpl m_down_loader;
    private Thread m_thread;
    private static final int MAX_TRY_TIMES = 3;
    private boolean m_use_YY_domain;

    public DownloadTask(DownloaderImpl download) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(30000L, TimeUnit.MILLISECONDS);
        builder.readTimeout(120000L, TimeUnit.MILLISECONDS);
        builder.writeTimeout(120000L, TimeUnit.MILLISECONDS);
        this.client = builder.build();
        this.m_use_YY_domain = false;
        this.m_down_loader = download;
    }

    public synchronized Thread getThread() {
        return this.m_thread;
    }

    public synchronized void setThread(Thread t) {
        this.m_thread = t;
    }

    public void setYYDomain(boolean b_use_YY_domain) {
        this.m_use_YY_domain = b_use_YY_domain;
    }

    @Override
    public void run() {
        this.setThread(Thread.currentThread());
        this.m_down_loader.setErrorCode(BS2Consts.RES.success);
        TaskCenter.getInstance().handleState(1, this.m_down_loader);
        this.downloadTmpFile = this.m_down_loader.getDownloadFile();
        String fileSuffix = TMP_SURFIX;
        this.downloadFile = this.downloadTmpFile.substring(0, this.downloadTmpFile.length() - fileSuffix.length());
        String host = this.m_down_loader.getBucket() + ConfigYYDomain.getBs2DownloadDomain();
        List<String> iplist = new ArrayList<String>();
        int retry = 0;
        String addr = host;
        int ret = BS2Consts.RES.error;
        long requestStartTick = System.currentTimeMillis();
        while (retry++ < 3) {
            String url = String.format("http://%s/%s", addr, this.m_down_loader.getFileKey());
            this.m_down_loader.setPath(url);
            this.m_down_loader.setRetryTimes(retry);
            ret = this.executeDownloadTask(url, host, this.m_down_loader.getToken());
            if (ret == BS2Consts.RES.success || ret == BS2Consts.RES.e_not_enough_disk_space || ret == BS2Consts.RES.e_token_is_invalid || ret == BS2Consts.RES.e_down_stop || ret == BS2Consts.RES.e_down_pause) break;
            try {
                long dnsStartTick = System.currentTimeMillis();
                SmartDnsResolver resolver = new SmartDnsResolver();
                resolver.setRetryInterval(50);
                resolver.setRetryTimes(2);
                resolver.setTimeout(500);
                iplist = this.getIpList(host, resolver);
                this.m_down_loader.setDNSTime(System.currentTimeMillis() - dnsStartTick);
            }
            catch (BS2ClientException e) {
                this.m_down_loader.setExceptionStr(e.getMessage());
                ret = BS2Consts.RES.e_dns_resolve_error;
            }
            addr = this.getAddr(host, iplist, addr);
        }
        this.m_down_loader.setErrorCode(ret);
        this.m_down_loader.setRequestTime(System.currentTimeMillis() - requestStartTick);
        if (ret == BS2Consts.RES.success) {
            TaskCenter.getInstance().handleState(2, this.m_down_loader);
        } else {
            TaskCenter.getInstance().handleState(-1, this.m_down_loader);
            DownloaderReport.reportState(this.m_down_loader, String.valueOf(ret), this.m_down_loader.getExceptionStr());
        }
    }

    private List<String> getIpList(String host, DnsResolver resovler) {
        List<String> iplist = null;
        try {
            iplist = resovler.resovle(host);
            if (iplist == null || iplist.size() == 0) {
                throw new BS2ClientException("iplist from dns resolver is empty, check implemention");
            }
            Collections.shuffle(iplist);
            return iplist;
        }
        catch (BS2ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BS2ClientException(e.toString(), e);
        }
    }

    private String getAddr(String host, List<String> iplist, String lastAddr) {
        if (iplist == null || iplist.size() == 0) {
            return host;
        }
        if (iplist.size() == 1) {
            return iplist.get(0);
        }
        int nextIndex = iplist.indexOf(lastAddr) + 1;
        if (nextIndex >= iplist.size()) {
            nextIndex = 0;
        }
        return iplist.get(nextIndex);
    }

    public int executeDownloadTask(String url, String host, String token) {
        try {
            Request.Builder builder = new Request.Builder();
            builder.get();
            File tempFile = new File(this.downloadTmpFile);
            long rangeBegin = 0L;
            if (tempFile.exists()) {
                rangeBegin = tempFile.length();
                Object[] ret = this.getExsistFileRange(tempFile, rangeBegin, url, token, host);
                boolean isSuccess = (Boolean)ret[0];
                if (isSuccess) {
                    return BS2Consts.RES.success;
                }
                rangeBegin = (Long)ret[1];
                builder.header(RANGE_HEADER, "bytes=" + rangeBegin + "-");
            } else {
                builder.header(RANGE_HEADER, "bytes=0-");
                tempFile.createNewFile();
            }
            this.mRandomAccessFile = new RandomAccessFile(tempFile, "rwd");
            Request httpRequest = builder.url(url).header(AUTH_HEADER, token).header(HOST_HEADER, host).build();
            Response response = this.client.newCall(httpRequest).execute();
            if (response.isSuccessful()) {
                Object[] size = this.getCurSize(response);
                long totalSize = (Long)size[1];
                long curSize = (Long)size[0];
                ResponseBody entity = response.body();
                if (entity != null) {
                    return this.readBodyToFile(response, totalSize, rangeBegin);
                }
                this.m_down_loader.setExceptionStr("Response Entity Empty:" + response.code());
                return BS2Consts.RES.e_http_server_error;
            }
            if (response.code() == 404) {
                this.m_down_loader.setExceptionStr("HttpResCode:" + response.code());
                return BS2Consts.RES.e_server_not_have_file;
            }
            if (response.code() == 403) {
                this.m_down_loader.setExceptionStr("HttpResCode:" + response.code());
                return BS2Consts.RES.e_token_is_invalid;
            }
            int rescode = response.code();
            this.m_down_loader.setExceptionStr("HttpResCode:" + rescode);
            return BS2Consts.RES.e_http_server_error;
        }
        catch (NumberFormatException e) {
            this.m_down_loader.setExceptionStr(Utility.getStackTrace(e));
            return BS2Consts.RES.e_http_server_error;
        }
        catch (ProtocolException e) {
            this.m_down_loader.setExceptionStr(Utility.getStackTrace(e));
            return BS2Consts.RES.e_http_server_error;
        }
        catch (IOException e) {
            this.m_down_loader.setExceptionStr(Utility.getStackTrace(e));
            return BS2Consts.RES.e_request_time_out;
        }
        catch (Exception e) {
            this.m_down_loader.setExceptionStr(Utility.getStackTrace(e));
            return BS2Consts.RES.error;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object[] getExsistFileRange(File tempFile, long rangeBegin, String url, String token, String host) throws IOException {
        Request.Builder builder1 = new Request.Builder();
        builder1.head();
        Request httpRequest1 = builder1.url(url).header(AUTH_HEADER, token).header(HOST_HEADER, host).build();
        Response response1 = this.client.newCall(httpRequest1).execute();
        long totalSize = Long.parseLong(response1.headers().get(CONTENT_LENGTH));
        if (totalSize == rangeBegin) {
            String etag = response1.headers().get(ETAG_HEADER);
            DownloaderVerify downVerify = new DownloaderVerify();
            int ret = downVerify.verifySha1(this.downloadTmpFile, etag = etag.substring(1, etag.length() - 1));
            if (ret == BS2Consts.RES.success) return new Object[]{true, rangeBegin};
            tempFile.delete();
            tempFile.createNewFile();
            rangeBegin = 0L;
            this.m_down_loader.setExceptionStr("GET All Length Content,But Verify Invalid!");
            return new Object[]{false, rangeBegin};
        } else {
            if (totalSize >= rangeBegin) return new Object[]{false, rangeBegin};
            tempFile.delete();
            tempFile.createNewFile();
            rangeBegin = 0L;
        }
        return new Object[]{false, rangeBegin};
    }

    protected Object[] getCurSize(Response response) {
        long seekLocation = 0L;
        long totalSize = Long.parseLong(response.headers().get(CONTENT_LENGTH));
        return new Object[]{seekLocation, totalSize};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int readBodyToFile(Response response, long totalSize, long curLocation) {
        ResponseBody entity = response.body();
        byte[] buffer = new byte[8192];
        long progress = curLocation;
        DownloaderVerify downVerify = new DownloaderVerify();
        String etag = "";
        totalSize += curLocation;
        try {
            int count;
            etag = response.headers().get(ETAG_HEADER);
            etag = etag.substring(1, etag.length() - 1);
            if (totalSize - curLocation >= downVerify.getRomFeeBlockSize()) {
                this.m_down_loader.setExceptionStr("Not Enough Disk Space!");
                int n = BS2Consts.RES.e_not_enough_disk_space;
                return n;
            }
            InputStream in = entity.byteStream();
            if (in == null) {
                throw new IOException();
            }
            this.mRandomAccessFile.seek(curLocation);
            this.m_down_loader.setProgress(progress, totalSize);
            float prePercent = this.m_down_loader.getPercent();
            while ((count = in.read(buffer)) != -1) {
                int downState = this.m_down_loader.getDownloadState();
                if (downState == 2) {
                    this.m_down_loader.setExceptionStr("Downloaded Pause!");
                    int n = BS2Consts.RES.e_down_pause;
                    return n;
                }
                if (downState == 4) {
                    this.mRandomAccessFile.close();
                    this.removeTask();
                    this.m_down_loader.setExceptionStr("Downloaded Pause!");
                    int n = BS2Consts.RES.e_down_stop;
                    return n;
                }
                this.mRandomAccessFile.write(buffer, 0, count);
                this.m_down_loader.setProgress(progress += (long)count, totalSize);
                float curPercent = this.m_down_loader.getPercent();
                if (!((double)(curPercent - prePercent) > 1.0E-4)) continue;
                prePercent = curPercent;
                TaskCenter.getInstance().handleState(3, this.m_down_loader);
            }
            int ret = downVerify.verifySha1(this.downloadTmpFile, etag);
            if (ret != BS2Consts.RES.success) {
                this.m_down_loader.setExceptionStr("Downloaded File Verify Invalid!");
            }
            int n = ret;
            return n;
        }
        catch (IOException e) {
            this.m_down_loader.setExceptionStr(Utility.getStackTrace(e));
            int n = BS2Consts.RES.e_http_server_error;
            return n;
        }
        finally {
            try {
                entity.close();
                this.mRandomAccessFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    private int removeTask() {
        File tempFile = new File(this.downloadTmpFile);
        tempFile.delete();
        return BS2Consts.RES.success;
    }
}

